/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.mojang.serialization.MapCodec;
import de.teamlapen.vampirism.advancements.critereon.FactionSubPredicate;
import de.teamlapen.vampirism.advancements.critereon.PlayerFactionSubPredicate;
import de.teamlapen.vampirism.api.VEnums;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.convertible.Converter;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.datamaps.EntityExistsCondition;
import de.teamlapen.vampirism.entity.AreaParticleCloudEntity;
import de.teamlapen.vampirism.entity.BlindingBatEntity;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.DarkBloodProjectileEntity;
import de.teamlapen.vampirism.entity.GhostEntity;
import de.teamlapen.vampirism.entity.RemainsDefenderEntity;
import de.teamlapen.vampirism.entity.SoulOrbEntity;
import de.teamlapen.vampirism.entity.ThrowableItemEntity;
import de.teamlapen.vampirism.entity.VulnerableRemainsDummyEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedCamelEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedCowEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedCreatureEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedDonkeyEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedFoxEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedGoatEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedHorseEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedMuleEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedSheepEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedVillagerEntity;
import de.teamlapen.vampirism.entity.converted.converter.DefaultConverter;
import de.teamlapen.vampirism.entity.converted.converter.SpecialConverter;
import de.teamlapen.vampirism.entity.hunter.AdvancedHunterEntity;
import de.teamlapen.vampirism.entity.hunter.AggressiveVillagerEntity;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.vampirism.entity.hunter.DummyHunterTrainerEntity;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.hunter.HunterTaskMasterEntity;
import de.teamlapen.vampirism.entity.hunter.HunterTrainerEntity;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import de.teamlapen.vampirism.entity.vampire.BasicVampireEntity;
import de.teamlapen.vampirism.entity.vampire.DummyBittenAnimalEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireTaskMasterEntity;
import de.teamlapen.vampirism.sit.SitEntity;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"vampirism");
    public static final DeferredRegister<MapCodec<? extends Converter>> CONVERTING_HELPER = DeferredRegister.create(VampirismRegistries.Keys.ENTITY_CONVERTER, (String)"vampirism");
    public static final DeferredRegister<MapCodec<? extends EntitySubPredicate>> ENTITY_SUB_PREDICATES = DeferredRegister.create((ResourceKey)Registries.ENTITY_SUB_PREDICATE_TYPE, (String)"vampirism");
    public static final DeferredRegister<MapCodec<? extends ICondition>> CONDITIONS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.CONDITION_CODECS, (String)"vampirism");
    public static final DeferredHolder<EntityType<?>, EntityType<BasicHunterEntity>> HUNTER = ModEntities.prepareEntityType("hunter", () -> EntityType.Builder.of(BasicHunterEntity::new, (MobCategory)((MobCategory)VEnums.HUNTER_CATEGORY.getValue())).sized(0.6f, 1.95f), true);
    public static final DeferredHolder<EntityType<?>, EntityType<HunterTrainerEntity>> HUNTER_TRAINER = ModEntities.prepareEntityType("hunter_trainer", () -> EntityType.Builder.of(HunterTrainerEntity::new, (MobCategory)((MobCategory)VEnums.HUNTER_CATEGORY.getValue())).sized(0.6f, 1.95f), true);
    public static final DeferredHolder<EntityType<?>, EntityType<AdvancedHunterEntity>> ADVANCED_HUNTER = ModEntities.prepareEntityType("advanced_hunter", () -> EntityType.Builder.of(AdvancedHunterEntity::new, (MobCategory)((MobCategory)VEnums.HUNTER_CATEGORY.getValue())).sized(0.6f, 1.95f), true);
    public static final DeferredHolder<EntityType<?>, EntityType<VampireBaronEntity>> VAMPIRE_BARON = ModEntities.prepareEntityType("vampire_baron", () -> EntityType.Builder.of(VampireBaronEntity::new, (MobCategory)((MobCategory)VEnums.VAMPIRE_CATEGORY.getValue())).sized(0.6f, 1.95f), true);
    public static final DeferredHolder<EntityType<?>, EntityType<BasicVampireEntity>> VAMPIRE = ModEntities.prepareEntityType("vampire", () -> EntityType.Builder.of(BasicVampireEntity::new, (MobCategory)((MobCategory)VEnums.VAMPIRE_CATEGORY.getValue())).sized(0.6f, 1.95f), true);
    public static final DeferredHolder<EntityType<?>, EntityType<AdvancedVampireEntity>> ADVANCED_VAMPIRE = ModEntities.prepareEntityType("advanced_vampire", () -> EntityType.Builder.of(AdvancedVampireEntity::new, (MobCategory)((MobCategory)VEnums.VAMPIRE_CATEGORY.getValue())).sized(0.6f, 1.95f), true);
    public static final DeferredHolder<EntityType<?>, EntityType<ConvertedCreatureEntity<?>>> CONVERTED_CREATURE = ModEntities.prepareEntityType("converted_creature", () -> EntityType.Builder.of(ConvertedCreatureEntity::new, (MobCategory)MobCategory.CREATURE), false);
    public static final DeferredHolder<EntityType<?>, EntityType<DummyBittenAnimalEntity>> DUMMY_CREATURE = ModEntities.prepareEntityType("dummy_creature", () -> EntityType.Builder.of(DummyBittenAnimalEntity::new, (MobCategory)MobCategory.CREATURE), true);
    public static final DeferredHolder<EntityType<?>, EntityType<BlindingBatEntity>> BLINDING_BAT = ModEntities.prepareEntityType("blinding_bat", () -> EntityType.Builder.of(BlindingBatEntity::new, (MobCategory)MobCategory.AMBIENT).sized(0.5f, 0.9f), true);
    public static final DeferredHolder<EntityType<?>, EntityType<AdvancedHunterEntity.IMob>> ADVANCED_HUNTER_IMOB = ModEntities.prepareEntityType("advanced_hunter_imob", () -> EntityType.Builder.of(AdvancedHunterEntity.IMob::new, (MobCategory)((MobCategory)VEnums.HUNTER_CATEGORY.getValue())).sized(0.6f, 1.95f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<AdvancedVampireEntity.IMob>> ADVANCED_VAMPIRE_IMOB = ModEntities.prepareEntityType("advanced_vampire_imob", () -> EntityType.Builder.of(AdvancedVampireEntity.IMob::new, (MobCategory)((MobCategory)VEnums.VAMPIRE_CATEGORY.getValue())).sized(0.6f, 1.95f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<ConvertedCreatureEntity.IMob<?>>> CONVERTED_CREATURE_IMOB = ModEntities.prepareEntityType("converted_creature_imob", () -> EntityType.Builder.of(ConvertedCreatureEntity.IMob::new, (MobCategory)MobCategory.CREATURE), false);
    public static final DeferredHolder<EntityType<?>, EntityType<ConvertedSheepEntity>> CONVERTED_SHEEP = ModEntities.prepareEntityType("converted_sheep", () -> EntityType.Builder.of(ConvertedSheepEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.3f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<ConvertedCowEntity>> CONVERTED_COW = ModEntities.prepareEntityType("converted_cow", () -> EntityType.Builder.of(ConvertedCowEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.4f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<CrossbowArrowEntity>> CROSSBOW_ARROW = ModEntities.prepareEntityType("crossbow_arrow", () -> EntityType.Builder.of(CrossbowArrowEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<DarkBloodProjectileEntity>> DARK_BLOOD_PROJECTILE = ModEntities.prepareEntityType("dark_blood_projectile", () -> EntityType.Builder.of(DarkBloodProjectileEntity::new, (MobCategory)MobCategory.MISC).sized(0.6f, 0.6f).fireImmune(), false);
    public static final DeferredHolder<EntityType<?>, EntityType<DummyHunterTrainerEntity>> HUNTER_TRAINER_DUMMY = ModEntities.prepareEntityType("hunter_trainer_dummy", () -> EntityType.Builder.of(DummyHunterTrainerEntity::new, (MobCategory)MobCategory.MISC).sized(0.6f, 1.95f), true);
    public static final DeferredHolder<EntityType<?>, EntityType<AreaParticleCloudEntity>> PARTICLE_CLOUD = ModEntities.prepareEntityType("particle_cloud", () -> EntityType.Builder.of(AreaParticleCloudEntity::new, (MobCategory)MobCategory.MISC).sized(6.0f, 0.5f).fireImmune(), false);
    public static final DeferredHolder<EntityType<?>, EntityType<SoulOrbEntity>> SOUL_ORB = ModEntities.prepareEntityType("soul_orb", () -> EntityType.Builder.of(SoulOrbEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).fireImmune(), false);
    public static final DeferredHolder<EntityType<?>, EntityType<ThrowableItemEntity>> THROWABLE_ITEM = ModEntities.prepareEntityType("throwable_item", () -> EntityType.Builder.of(ThrowableItemEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<BasicVampireEntity.IMob>> VAMPIRE_IMOB = ModEntities.prepareEntityType("vampire_imob", () -> EntityType.Builder.of(BasicVampireEntity.IMob::new, (MobCategory)((MobCategory)VEnums.VAMPIRE_CATEGORY.getValue())).sized(0.6f, 1.95f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<BasicHunterEntity.IMob>> HUNTER_IMOB = ModEntities.prepareEntityType("hunter_imob", () -> EntityType.Builder.of(BasicHunterEntity.IMob::new, (MobCategory)((MobCategory)VEnums.HUNTER_CATEGORY.getValue())).sized(0.6f, 1.95f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<AggressiveVillagerEntity>> VILLAGER_ANGRY = ModEntities.prepareEntityType("villager_angry", () -> EntityType.Builder.of(AggressiveVillagerEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.95f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<ConvertedVillagerEntity>> VILLAGER_CONVERTED = ModEntities.prepareEntityType("villager_converted", () -> EntityType.Builder.of(ConvertedVillagerEntity::new, (MobCategory)((MobCategory)VEnums.VAMPIRE_CATEGORY.getValue())).sized(0.6f, 1.95f), true);
    public static final DeferredHolder<EntityType<?>, EntityType<ConvertedHorseEntity>> CONVERTED_HORSE = ModEntities.prepareEntityType("converted_horse", () -> EntityType.Builder.of(ConvertedHorseEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.3964844f, 1.6f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<VampireMinionEntity>> VAMPIRE_MINION = ModEntities.prepareEntityType("vampire_minion", () -> EntityType.Builder.of(VampireMinionEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.95f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<ConvertedDonkeyEntity>> CONVERTED_DONKEY = ModEntities.prepareEntityType("converted_donkey", () -> EntityType.Builder.of(ConvertedDonkeyEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.3964844f, 1.5f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<ConvertedMuleEntity>> CONVERTED_MULE = ModEntities.prepareEntityType("converted_mule", () -> EntityType.Builder.of(ConvertedMuleEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.3964844f, 1.5f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<HunterMinionEntity>> HUNTER_MINION = ModEntities.prepareEntityType("hunter_minion", () -> EntityType.Builder.of(HunterMinionEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.95f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<VampireTaskMasterEntity>> TASK_MASTER_VAMPIRE = ModEntities.prepareEntityType("task_master_vampire", () -> EntityType.Builder.of(VampireTaskMasterEntity::new, (MobCategory)((MobCategory)VEnums.VAMPIRE_CATEGORY.getValue())).sized(0.6f, 1.95f), true);
    public static final DeferredHolder<EntityType<?>, EntityType<HunterTaskMasterEntity>> TASK_MASTER_HUNTER = ModEntities.prepareEntityType("task_master_hunter", () -> EntityType.Builder.of(HunterTaskMasterEntity::new, (MobCategory)((MobCategory)VEnums.HUNTER_CATEGORY.getValue())).sized(0.6f, 1.95f), true);
    public static final DeferredHolder<EntityType<?>, EntityType<SitEntity>> dummy_sit_entity = ModEntities.prepareEntityType("dummy_sit_entity", () -> EntityType.Builder.of(SitEntity::new, (MobCategory)MobCategory.MISC).sized(1.0E-4f, 1.0E-4f).setTrackingRange(256).setUpdateInterval(20), false);
    public static final DeferredHolder<EntityType<?>, EntityType<ConvertedFoxEntity>> CONVERTED_FOX = ModEntities.prepareEntityType("converted_fox", () -> EntityType.Builder.of(ConvertedFoxEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.7f).immuneTo(new Block[]{Blocks.SWEET_BERRY_BUSH}), false);
    public static final DeferredHolder<EntityType<?>, EntityType<ConvertedGoatEntity>> CONVERTED_GOAT = ModEntities.prepareEntityType("converted_goat", () -> EntityType.Builder.of(ConvertedGoatEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.3f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<VulnerableRemainsDummyEntity>> VULNERABLE_REMAINS_DUMMY = ModEntities.prepareEntityType("vulnerable_remains_dummy", () -> EntityType.Builder.of(VulnerableRemainsDummyEntity::new, (MobCategory)MobCategory.MISC).sized(1.02f, 1.02f).setTrackingRange(10).setUpdateInterval(20), false);
    public static final DeferredHolder<EntityType<?>, EntityType<RemainsDefenderEntity>> REMAINS_DEFENDER = ModEntities.prepareEntityType("remains_defender", () -> EntityType.Builder.of(RemainsDefenderEntity::new, (MobCategory)MobCategory.MISC).sized(0.3f, 0.3f).setTrackingRange(10).setUpdateInterval(20), false);
    public static final DeferredHolder<EntityType<?>, EntityType<GhostEntity>> GHOST = ModEntities.prepareEntityType("ghost", () -> EntityType.Builder.of(GhostEntity::new, (MobCategory)((MobCategory)VEnums.VAMPIRE_CATEGORY.getValue())).sized(0.35f, 0.5f).setTrackingRange(10).setUpdateInterval(20).fireImmune(), true);
    public static final DeferredHolder<EntityType<?>, EntityType<ConvertedCamelEntity>> CONVERTED_CAMEL = ModEntities.prepareEntityType("converted_camel", () -> EntityType.Builder.of(ConvertedCamelEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.7f, 2.375f), false);
    public static final DeferredHolder<MapCodec<? extends Converter>, MapCodec<? extends Converter>> DEFAULT_CONVERTER = CONVERTING_HELPER.register("default", () -> DefaultConverter.CODEC);
    public static final DeferredHolder<MapCodec<? extends Converter>, MapCodec<? extends Converter>> SPECIAL_CONVERTER = CONVERTING_HELPER.register("special", () -> SpecialConverter.CODEC);
    public static final DeferredHolder<MapCodec<? extends EntitySubPredicate>, MapCodec<PlayerFactionSubPredicate>> PLAYER_FACTION_SUB_PREDICATE = ENTITY_SUB_PREDICATES.register("player_faction", () -> PlayerFactionSubPredicate.CODEC);
    public static final DeferredHolder<MapCodec<? extends EntitySubPredicate>, MapCodec<FactionSubPredicate>> FACTION_SUB_PREDICATE = ENTITY_SUB_PREDICATES.register("faction", () -> FactionSubPredicate.CODEC);
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<? extends ICondition>> ENTITY_EXISTS = CONDITIONS.register("entity_exists", () -> EntityExistsCondition.CODEC);

    static void register(IEventBus bus) {
        ENTITY_TYPES.register(bus);
        CONVERTING_HELPER.register(bus);
        ENTITY_SUB_PREDICATES.register(bus);
        CONDITIONS.register(bus);
    }

    static void onRegisterSpawns(@NotNull RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)ADVANCED_HUNTER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HunterBaseEntity::spawnPredicateHunter, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)ADVANCED_VAMPIRE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, VampireBaseEntity::spawnPredicateVampire, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)BLINDING_BAT.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BlindingBatEntity::spawnPredicate, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)DUMMY_CREATURE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DummyBittenAnimalEntity::spawnPredicate, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)CONVERTED_CREATURE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedCreatureEntity::spawnPredicate, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)CONVERTED_SHEEP.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedSheepEntity::checkConvertedSheepSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)CONVERTED_COW.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedCowEntity::checkConvertedCowSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)HUNTER_TRAINER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)HUNTER_TRAINER_DUMMY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)VAMPIRE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, VampireBaseEntity::spawnPredicateVampire, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)VAMPIRE_BARON.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, VampireBaronEntity::spawnPredicateBaron, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)HUNTER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HunterBaseEntity::spawnPredicateHunter, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)VILLAGER_ANGRY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)VILLAGER_CONVERTED.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)CONVERTED_HORSE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedHorseEntity::checkConvertedHorseSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)CONVERTED_DONKEY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedDonkeyEntity::checkConvertedDonkeySpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)CONVERTED_MULE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedMuleEntity::checkConvertedMuleSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)CONVERTED_FOX.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedFoxEntity::checkConvertedFoxSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)CONVERTED_GOAT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedGoatEntity::checkConvertedGoatSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)CONVERTED_CAMEL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedCamelEntity::checkConvertedCamelSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
    }

    static void onRegisterEntityTypeAttributes(@NotNull EntityAttributeCreationEvent event) {
        event.put((EntityType)ADVANCED_HUNTER.get(), AdvancedHunterEntity.getAttributeBuilder().build());
        event.put((EntityType)ADVANCED_HUNTER_IMOB.get(), AdvancedHunterEntity.getAttributeBuilder().build());
        event.put((EntityType)ADVANCED_VAMPIRE.get(), AdvancedVampireEntity.getAttributeBuilder().build());
        event.put((EntityType)ADVANCED_VAMPIRE_IMOB.get(), AdvancedVampireEntity.getAttributeBuilder().build());
        event.put((EntityType)BLINDING_BAT.get(), Bat.createAttributes().build());
        event.put((EntityType)CONVERTED_CREATURE.get(), BasicVampireEntity.getAttributeBuilder().build());
        event.put((EntityType)CONVERTED_CREATURE_IMOB.get(), BasicVampireEntity.getAttributeBuilder().build());
        event.put((EntityType)CONVERTED_HORSE.get(), ConvertedHorseEntity.getAttributeBuilder().build());
        event.put((EntityType)CONVERTED_SHEEP.get(), ConvertedSheepEntity.getAttributeBuilder().build());
        event.put((EntityType)CONVERTED_COW.get(), ConvertedCowEntity.getAttributeBuilder().build());
        event.put((EntityType)CONVERTED_DONKEY.get(), ConvertedDonkeyEntity.getAttributeBuilder().build());
        event.put((EntityType)CONVERTED_MULE.get(), ConvertedMuleEntity.getAttributeBuilder().build());
        event.put((EntityType)DUMMY_CREATURE.get(), BasicVampireEntity.getAttributeBuilder().build());
        event.put((EntityType)HUNTER.get(), BasicHunterEntity.getAttributeBuilder().build());
        event.put((EntityType)HUNTER_IMOB.get(), BasicHunterEntity.getAttributeBuilder().build());
        event.put((EntityType)HUNTER_TRAINER.get(), HunterTrainerEntity.getAttributeBuilder().build());
        event.put((EntityType)HUNTER_TRAINER_DUMMY.get(), HunterTrainerEntity.getAttributeBuilder().build());
        event.put((EntityType)VAMPIRE.get(), BasicVampireEntity.getAttributeBuilder().build());
        event.put((EntityType)VAMPIRE_IMOB.get(), BasicVampireEntity.getAttributeBuilder().build());
        event.put((EntityType)VAMPIRE_BARON.get(), VampireBaronEntity.getAttributeBuilder().build());
        event.put((EntityType)VILLAGER_ANGRY.get(), AggressiveVillagerEntity.getAttributeBuilder().build());
        event.put((EntityType)VILLAGER_CONVERTED.get(), ConvertedVillagerEntity.getAttributeBuilder().build());
        event.put((EntityType)HUNTER_MINION.get(), HunterMinionEntity.getAttributeBuilder().build());
        event.put((EntityType)VAMPIRE_MINION.get(), VampireMinionEntity.getAttributeBuilder().build());
        event.put((EntityType)TASK_MASTER_HUNTER.get(), HunterTaskMasterEntity.getAttributeBuilder().build());
        event.put((EntityType)TASK_MASTER_VAMPIRE.get(), VampireTaskMasterEntity.getAttributeBuilder().build());
        event.put((EntityType)CONVERTED_FOX.get(), ConvertedFoxEntity.createAttributes().build());
        event.put((EntityType)CONVERTED_GOAT.get(), ConvertedGoatEntity.createAttributes().build());
        event.put((EntityType)VULNERABLE_REMAINS_DUMMY.get(), VulnerableRemainsDummyEntity.createAttributes().build());
        event.put((EntityType)REMAINS_DEFENDER.get(), RemainsDefenderEntity.createAttributes().build());
        event.put((EntityType)GHOST.get(), GhostEntity.createAttributes().build());
        event.put((EntityType)CONVERTED_CAMEL.get(), ConvertedCamelEntity.getAttributeBuilder().build());
    }

    static void onModifyEntityTypeAttributes(@NotNull EntityAttributeModificationEvent event) {
        event.add(EntityType.PLAYER, ModAttributes.SUNDAMAGE);
        event.add(EntityType.PLAYER, ModAttributes.BLOOD_EXHAUSTION);
        event.add(EntityType.PLAYER, ModAttributes.NEONATAL_DURATION);
        event.add(EntityType.PLAYER, ModAttributes.DBNO_DURATION);
    }

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> prepareEntityType(String id, @NotNull Supplier<EntityType.Builder<T>> builder, boolean spawnable) {
        return ENTITY_TYPES.register(id, () -> {
            EntityType.Builder type = ((EntityType.Builder)builder.get()).setTrackingRange(80).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true);
            if (!spawnable) {
                type.noSummon();
            }
            return type.build("vampirism:" + id);
        });
    }

    @NotNull
    public static Set<EntityType<?>> getAllEntities() {
        return ENTITY_TYPES.getEntries().stream().map(DeferredHolder::get).collect(Collectors.toUnmodifiableSet());
    }
}

