/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.mojang.serialization.MapCodec;
import de.teamlapen.vampirism.particle.FlyingBloodEntityParticleOptions;
import de.teamlapen.vampirism.particle.FlyingBloodParticleOptions;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class ModParticles {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"vampirism");
    public static final DeferredHolder<ParticleType<?>, ParticleType<FlyingBloodParticleOptions>> FLYING_BLOOD = PARTICLE_TYPES.register("flying_blood", () -> new ParticleType<FlyingBloodParticleOptions>(false){

        @NotNull
        public MapCodec<FlyingBloodParticleOptions> codec() {
            return FlyingBloodParticleOptions.CODEC;
        }

        @NotNull
        public StreamCodec<? super RegistryFriendlyByteBuf, FlyingBloodParticleOptions> streamCodec() {
            return FlyingBloodParticleOptions.STREAM_CODEC;
        }
    });
    public static final DeferredHolder<ParticleType<?>, ParticleType<FlyingBloodEntityParticleOptions>> FLYING_BLOOD_ENTITY = PARTICLE_TYPES.register("flying_blood_entity", () -> new ParticleType<FlyingBloodEntityParticleOptions>(false){

        @NotNull
        public MapCodec<FlyingBloodEntityParticleOptions> codec() {
            return FlyingBloodEntityParticleOptions.CODEC;
        }

        @NotNull
        public StreamCodec<? super RegistryFriendlyByteBuf, FlyingBloodEntityParticleOptions> streamCodec() {
            return FlyingBloodEntityParticleOptions.STREAM_CODEC;
        }
    });
    public static final DeferredHolder<ParticleType<?>, ParticleType<GenericParticleOptions>> GENERIC = PARTICLE_TYPES.register("generic", () -> new ParticleType<GenericParticleOptions>(false){

        @NotNull
        public MapCodec<GenericParticleOptions> codec() {
            return GenericParticleOptions.CODEC;
        }

        @NotNull
        public StreamCodec<? super RegistryFriendlyByteBuf, GenericParticleOptions> streamCodec() {
            return GenericParticleOptions.STREAM_CODEC;
        }
    });

    static void register(IEventBus bus) {
        PARTICLE_TYPES.register(bus);
    }

    public static void spawnParticlesClient(Level worldIn, @NotNull ParticleOptions particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int count, double maxDist, @NotNull RandomSource rand) {
        assert (!(worldIn instanceof ServerLevel)) : "Calling spawnParticlesClient on ServerWorld is pointless";
        for (int i = 0; i < count; ++i) {
            worldIn.addParticle(particle, x + maxDist * (2.0 * rand.nextDouble() - 1.0), y + (2.0 * rand.nextDouble() - 1.0) * maxDist, z + (2.0 * rand.nextDouble() - 1.0) * maxDist, xSpeed, ySpeed, zSpeed);
        }
    }

    public static void spawnParticlesClient(Level worldIn, @NotNull ParticleOptions particle, double x, double y, double z, int count, double maxDist, @NotNull RandomSource rand) {
        ModParticles.spawnParticlesClient(worldIn, particle, x, y, z, 0.0, 0.0, 0.0, count, maxDist, rand);
    }

    public static void spawnParticleClient(@NotNull Level worldIn, @NotNull ParticleOptions particle, double x, double y, double z) {
        ModParticles.spawnParticleClient(worldIn, particle, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void spawnParticleClient(@NotNull Level worldIn, @NotNull ParticleOptions particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        assert (!(worldIn instanceof ServerLevel)) : "Calling spawnParticleClient on ServerWorld is pointless";
        worldIn.addParticle(particle, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public static int spawnParticlesServer(Level worldIn, @NotNull ParticleOptions particle, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        assert (worldIn instanceof ServerLevel) : "Calling spawnParticlesServer on client side is pointless";
        if (worldIn instanceof ServerLevel) {
            return ((ServerLevel)worldIn).sendParticles(particle, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed);
        }
        return 0;
    }
}

