/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.entity.player.refinements.RefinementSet;
import java.util.function.Supplier;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class ModRefinementSets {
    public static final DeferredRegister<IRefinementSet> REFINEMENT_SETS = DeferredRegister.create(VampirismRegistries.Keys.REFINEMENT_SET, (String)"vampirism");

    public static void register(IEventBus bus) {
        REFINEMENT_SETS.register(bus);
    }

    @SafeVarargs
    @NotNull
    private static IRefinementSet commonV(Supplier<? extends IRefinement> ... refinements) {
        return ModRefinementSets.vampire(IRefinementSet.Rarity.COMMON, refinements);
    }

    @SafeVarargs
    @NotNull
    private static IRefinementSet uncommonV(Supplier<? extends IRefinement> ... refinements) {
        return ModRefinementSets.vampire(IRefinementSet.Rarity.UNCOMMON, refinements);
    }

    @SafeVarargs
    @NotNull
    private static IRefinementSet rareV(Supplier<? extends IRefinement> ... refinements) {
        return ModRefinementSets.vampire(IRefinementSet.Rarity.RARE, refinements);
    }

    @SafeVarargs
    @NotNull
    private static IRefinementSet epicV(Supplier<? extends IRefinement> ... refinements) {
        return ModRefinementSets.vampire(IRefinementSet.Rarity.EPIC, refinements);
    }

    @SafeVarargs
    @NotNull
    private static RefinementSet vampire(@NotNull IRefinementSet.Rarity rarity, Supplier<? extends IRefinement> ... refinements) {
        return new RefinementSet.VampireRefinementSet(rarity, (int)rarity.color.getColor(), refinements);
    }

    static {
        REFINEMENT_SETS.register("armor1", () -> ModRefinementSets.commonV(new Supplier[]{ModRefinements.ARMOR1}));
        REFINEMENT_SETS.register("health1", () -> ModRefinementSets.commonV(new Supplier[]{ModRefinements.HEALTH1}));
        REFINEMENT_SETS.register("speed1", () -> ModRefinementSets.commonV(new Supplier[]{ModRefinements.SPEED1}));
        REFINEMENT_SETS.register("attack_speed1", () -> ModRefinementSets.commonV(new Supplier[]{ModRefinements.ATTACK_SPEED1}));
        REFINEMENT_SETS.register("damage1", () -> ModRefinementSets.commonV(new Supplier[]{ModRefinements.DAMAGE1}));
        REFINEMENT_SETS.register("damage1_attack_speed1_n_armor2", () -> ModRefinementSets.commonV(new Supplier[]{ModRefinements.DAMAGE1, ModRefinements.ATTACK_SPEED1, ModRefinements.N_ARMOR2}));
        REFINEMENT_SETS.register("armor1_health1_n_attack_speed2", () -> ModRefinementSets.commonV(new Supplier[]{ModRefinements.ARMOR1, ModRefinements.HEALTH1, ModRefinements.N_ATTACK_SPEED2}));
        REFINEMENT_SETS.register("regeneration", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15580939, new Supplier[]{ModRefinements.REGENERATION}));
        REFINEMENT_SETS.register("sword_trained_amount", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15547147, new Supplier[]{ModRefinements.SWORD_TRAINED_AMOUNT}));
        REFINEMENT_SETS.register("blood_charge_speed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15541515, new Supplier[]{ModRefinements.BLOOD_CHARGE_SPEED}));
        REFINEMENT_SETS.register("freeze_duration", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 778221, new Supplier[]{ModRefinements.FREEZE_DURATION}));
        REFINEMENT_SETS.register("sword_finisher", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 13697286, new Supplier[]{ModRefinements.SWORD_FINISHER}));
        REFINEMENT_SETS.register("regeneration_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15580939, new Supplier[]{ModRefinements.REGENERATION, ModRefinements.SPEED1}));
        REFINEMENT_SETS.register("sword_trained_amount_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15547147, new Supplier[]{ModRefinements.SWORD_TRAINED_AMOUNT, ModRefinements.DAMAGE1}));
        REFINEMENT_SETS.register("blood_charge_speed_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15541515, new Supplier[]{ModRefinements.BLOOD_CHARGE_SPEED, ModRefinements.ATTACK_SPEED1}));
        REFINEMENT_SETS.register("freeze_duration_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 778221, new Supplier[]{ModRefinements.FREEZE_DURATION, ModRefinements.HEALTH1}));
        REFINEMENT_SETS.register("sword_finisher_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 13697286, new Supplier[]{ModRefinements.SWORD_FINISHER, ModRefinements.ARMOR1}));
        REFINEMENT_SETS.register("regeneration_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15580939, new Supplier[]{ModRefinements.REGENERATION, ModRefinements.N_SPEED1}));
        REFINEMENT_SETS.register("sword_trained_amount_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15547147, new Supplier[]{ModRefinements.SWORD_TRAINED_AMOUNT, ModRefinements.N_DAMAGE1}));
        REFINEMENT_SETS.register("blood_charge_speed_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15541515, new Supplier[]{ModRefinements.BLOOD_CHARGE_SPEED, ModRefinements.N_ATTACK_SPEED1}));
        REFINEMENT_SETS.register("freeze_duration_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 778221, new Supplier[]{ModRefinements.FREEZE_DURATION, ModRefinements.N_HEALTH1}));
        REFINEMENT_SETS.register("sword_finisher_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 13697286, new Supplier[]{ModRefinements.SWORD_FINISHER, ModRefinements.N_ARMOR1}));
        REFINEMENT_SETS.register("armor2_n_health2", () -> ModRefinementSets.uncommonV(new Supplier[]{ModRefinements.ARMOR2, ModRefinements.N_HEALTH2}));
        REFINEMENT_SETS.register("health2_n_damage1", () -> ModRefinementSets.uncommonV(new Supplier[]{ModRefinements.HEALTH2, ModRefinements.N_DAMAGE1}));
        REFINEMENT_SETS.register("attack_speed2_n_armor1", () -> ModRefinementSets.uncommonV(new Supplier[]{ModRefinements.ATTACK_SPEED2, ModRefinements.N_ARMOR1}));
        REFINEMENT_SETS.register("damage2_n_speed1", () -> ModRefinementSets.uncommonV(new Supplier[]{ModRefinements.DAMAGE2, ModRefinements.N_SPEED1}));
        REFINEMENT_SETS.register("speed2_n_damage1", () -> ModRefinementSets.uncommonV(new Supplier[]{ModRefinements.SPEED2, ModRefinements.N_DAMAGE1}));
        REFINEMENT_SETS.register("armor3_n_health3", () -> ModRefinementSets.uncommonV(new Supplier[]{ModRefinements.ARMOR3, ModRefinements.N_HEALTH3}));
        REFINEMENT_SETS.register("health3_n_damage2", () -> ModRefinementSets.uncommonV(new Supplier[]{ModRefinements.HEALTH3, ModRefinements.N_DAMAGE2}));
        REFINEMENT_SETS.register("attack_speed3_n_armor2", () -> ModRefinementSets.uncommonV(new Supplier[]{ModRefinements.ATTACK_SPEED3, ModRefinements.N_ARMOR2}));
        REFINEMENT_SETS.register("damage3_n_speed2", () -> ModRefinementSets.uncommonV(new Supplier[]{ModRefinements.DAMAGE3, ModRefinements.N_SPEED3}));
        REFINEMENT_SETS.register("speed3_n_damage2", () -> ModRefinementSets.uncommonV(new Supplier[]{ModRefinements.SPEED3, ModRefinements.N_DAMAGE2}));
        REFINEMENT_SETS.register("vista", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 765933, new Supplier[]{ModRefinements.VISTA}));
        REFINEMENT_SETS.register("teleport_distance", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 427861, new Supplier[]{ModRefinements.TELEPORT_DISTANCE}));
        REFINEMENT_SETS.register("dark_blood_projectile_damage", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, new Supplier[]{ModRefinements.DARK_BLOOD_PROJECTILE_DAMAGE}));
        REFINEMENT_SETS.register("dark_blood_projectile_penetration", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, new Supplier[]{ModRefinements.DARK_BLOOD_PROJECTILE_PENETRATION}).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("dark_blood_projectile_multi_shot", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, new Supplier[]{ModRefinements.DARK_BLOOD_PROJECTILE_MULTI_SHOT}).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("vista_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 765933, new Supplier[]{ModRefinements.VISTA, ModRefinements.SPEED1}));
        REFINEMENT_SETS.register("teleport_distance_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 427861, new Supplier[]{ModRefinements.TELEPORT_DISTANCE, ModRefinements.SPEED1}));
        REFINEMENT_SETS.register("dark_blood_projectile_damage_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, new Supplier[]{ModRefinements.DARK_BLOOD_PROJECTILE_DAMAGE, ModRefinements.DAMAGE1}));
        REFINEMENT_SETS.register("dark_blood_projectile_penetration_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, new Supplier[]{ModRefinements.DARK_BLOOD_PROJECTILE_PENETRATION, ModRefinements.ATTACK_SPEED1}).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("dark_blood_projectile_multi_shot_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, new Supplier[]{ModRefinements.DARK_BLOOD_PROJECTILE_MULTI_SHOT, ModRefinements.ATTACK_SPEED1}).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("vista_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 765933, new Supplier[]{ModRefinements.VISTA, ModRefinements.N_SPEED1}));
        REFINEMENT_SETS.register("teleport_distance_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 427861, new Supplier[]{ModRefinements.TELEPORT_DISTANCE, ModRefinements.N_SPEED1}));
        REFINEMENT_SETS.register("dark_blood_projectile_damage_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, new Supplier[]{ModRefinements.DARK_BLOOD_PROJECTILE_DAMAGE, ModRefinements.N_DAMAGE1}));
        REFINEMENT_SETS.register("dark_blood_projectile_penetration_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, new Supplier[]{ModRefinements.DARK_BLOOD_PROJECTILE_PENETRATION, ModRefinements.N_ATTACK_SPEED1}).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("dark_blood_projectile_multi_shot_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, new Supplier[]{ModRefinements.DARK_BLOOD_PROJECTILE_MULTI_SHOT, ModRefinements.N_ATTACK_SPEED1}).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("armor3_n_health2", () -> ModRefinementSets.rareV(new Supplier[]{ModRefinements.ARMOR3, ModRefinements.N_HEALTH2}));
        REFINEMENT_SETS.register("health3_n_armor1", () -> ModRefinementSets.rareV(new Supplier[]{ModRefinements.HEALTH3, ModRefinements.N_ARMOR1}));
        REFINEMENT_SETS.register("attack_speed3_n_speed1", () -> ModRefinementSets.rareV(new Supplier[]{ModRefinements.ATTACK_SPEED3, ModRefinements.N_SPEED1}));
        REFINEMENT_SETS.register("speed1_armor1_health1", () -> ModRefinementSets.rareV(new Supplier[]{ModRefinements.SPEED1, ModRefinements.ARMOR1, ModRefinements.HEALTH1}));
        REFINEMENT_SETS.register("damage3_n_armor1", () -> ModRefinementSets.rareV(new Supplier[]{ModRefinements.DAMAGE3, ModRefinements.N_ARMOR2}));
        REFINEMENT_SETS.register("speed3_n_attack_speed1", () -> ModRefinementSets.rareV(new Supplier[]{ModRefinements.SPEED3, ModRefinements.N_ATTACK_SPEED1}));
        REFINEMENT_SETS.register("damage1_attack_speed1", () -> ModRefinementSets.rareV(new Supplier[]{ModRefinements.DAMAGE1, ModRefinements.ATTACK_SPEED1}));
        REFINEMENT_SETS.register("half_invulnerable", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.RARE, 11103671, new Supplier[]{ModRefinements.HALF_INVULNERABLE}));
        REFINEMENT_SETS.register("summon_bats", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.RARE, 9144977, new Supplier[]{ModRefinements.SUMMON_BATS}));
        REFINEMENT_SETS.register("sun_screen", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.RARE, 15581707, new Supplier[]{ModRefinements.SUN_SCREEN}));
        REFINEMENT_SETS.register("dark_blood_projectile_speed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.RARE, 15641549, new Supplier[]{ModRefinements.DARK_BLOOD_PROJECTILE_SPEED}));
        REFINEMENT_SETS.register("half_invulnerable_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.RARE, 11103671, new Supplier[]{ModRefinements.HALF_INVULNERABLE, ModRefinements.N_ARMOR1}));
        REFINEMENT_SETS.register("summon_bats_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.RARE, 9144977, new Supplier[]{ModRefinements.SUMMON_BATS, ModRefinements.N_HEALTH1}));
        REFINEMENT_SETS.register("sun_screen_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.RARE, 15581707, new Supplier[]{ModRefinements.SUN_SCREEN, ModRefinements.N_ARMOR1}));
        REFINEMENT_SETS.register("crucifix_resistant", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 8241873, new Supplier[]{ModRefinements.CRUCIFIX_RESISTANT}));
        REFINEMENT_SETS.register("vampire_sword", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 15547147, new Supplier[]{ModRefinements.SWORD_TRAINED_AMOUNT, ModRefinements.BLOOD_CHARGE_SPEED}));
        REFINEMENT_SETS.register("dark_blood_projectile", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 14877695, new Supplier[]{ModRefinements.DARK_BLOOD_PROJECTILE_PENETRATION, ModRefinements.DARK_BLOOD_PROJECTILE_MULTI_SHOT}).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("rage_fury", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 12648962, new Supplier[]{ModRefinements.RAGE_FURY}));
        REFINEMENT_SETS.register("summon_bats_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 9144977, new Supplier[]{ModRefinements.SUMMON_BATS, ModRefinements.HEALTH1}));
        REFINEMENT_SETS.register("dark_blood_projectile_aoe", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 14877695, new Supplier[]{ModRefinements.DARK_BLOOD_PROJECTILE_AOE}).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("half_invulnerable_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 11103671, new Supplier[]{ModRefinements.HALF_INVULNERABLE, ModRefinements.ARMOR1}));
        REFINEMENT_SETS.register("sun_screen_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 15581707, new Supplier[]{ModRefinements.SUN_SCREEN, ModRefinements.ARMOR1}));
        REFINEMENT_SETS.register("dark_blood_projectile_speed_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 15641453, new Supplier[]{ModRefinements.DARK_BLOOD_PROJECTILE_SPEED, ModRefinements.SPEED1}));
        REFINEMENT_SETS.register("dark_blood_projectile_aoe_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 14877695, new Supplier[]{ModRefinements.DARK_BLOOD_PROJECTILE_AOE, ModRefinements.N_HEALTH1}).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("rage_fury_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 12648962, new Supplier[]{ModRefinements.RAGE_FURY, ModRefinements.N_ARMOR1}));
        REFINEMENT_SETS.register("crucifix_resistant_speed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 8213969, new Supplier[]{ModRefinements.CRUCIFIX_RESISTANT, ModRefinements.ATTACK_SPEED1}));
        REFINEMENT_SETS.register("crucifix_resistant_health", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 8213969, new Supplier[]{ModRefinements.CRUCIFIX_RESISTANT, ModRefinements.HEALTH2}));
        REFINEMENT_SETS.register("dark_blood_projectile_aoe_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.LEGENDARY, 14877695, new Supplier[]{ModRefinements.DARK_BLOOD_PROJECTILE_AOE, ModRefinements.HEALTH1}).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("rage_fury_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.LEGENDARY, 12648962, new Supplier[]{ModRefinements.RAGE_FURY, ModRefinements.ARMOR1}));
        REFINEMENT_SETS.register("dark_blood_projectile_speed_double_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.LEGENDARY, 15620813, new Supplier[]{ModRefinements.DARK_BLOOD_PROJECTILE_SPEED, ModRefinements.SPEED3}));
    }
}

