/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.api.VEnums;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.blocks.TotemTopBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.world.gen.VanillaStructureModifications;
import de.teamlapen.vampirism.world.gen.structure.crypt.CryptStructurePieces;
import de.teamlapen.vampirism.world.gen.structure.huntercamp.HunterCampPieces;
import de.teamlapen.vampirism.world.gen.structure.huntercamp.HunterCampStructure;
import de.teamlapen.vampirism.world.gen.structure.hunteroutpost.BadlandsHunterOutpostPools;
import de.teamlapen.vampirism.world.gen.structure.hunteroutpost.DesertHunterOutpostPools;
import de.teamlapen.vampirism.world.gen.structure.hunteroutpost.HunterOutpostPools;
import de.teamlapen.vampirism.world.gen.structure.hunteroutpost.PlainsHunterOutpostPools;
import de.teamlapen.vampirism.world.gen.structure.hunteroutpost.VampireForestHunterOutpostPools;
import de.teamlapen.vampirism.world.gen.structure.mother.MotherPiece;
import de.teamlapen.vampirism.world.gen.structure.mother.MotherStructure;
import de.teamlapen.vampirism.world.gen.structure.templatesystem.BiomeTopBlockProcessor;
import de.teamlapen.vampirism.world.gen.structure.templatesystem.RandomBlockStateRule;
import de.teamlapen.vampirism.world.gen.structure.templatesystem.RandomStructureProcessor;
import de.teamlapen.vampirism.world.gen.structure.vampirealtar.VampireAltarPieces;
import de.teamlapen.vampirism.world.gen.structure.vampirealtar.VampireAltarStructure;
import de.teamlapen.vampirism.world.gen.structure.vampirehut.VampireHutPieces;
import de.teamlapen.vampirism.world.gen.structure.vampirehut.VampireHutStructure;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModStructures {
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPES = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_TYPE, (String)"vampirism");
    public static final DeferredRegister<StructurePieceType> STRUCTURE_PIECES = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PIECE, (String)"vampirism");
    public static final DeferredRegister<StructureProcessorType<?>> STRUCTURE_PROCESSOR_TYPES = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PROCESSOR, (String)"vampirism");
    public static final DeferredHolder<StructureType<?>, StructureType<HunterCampStructure>> HUNTER_CAMP_TYPE = STRUCTURE_TYPES.register("hunter_camp", () -> () -> HunterCampStructure.CODEC);
    public static final DeferredHolder<StructureType<?>, StructureType<VampireHutStructure>> VAMPIRE_HUT_TYPE = STRUCTURE_TYPES.register("vampire_hut", () -> () -> VampireHutStructure.CODEC);
    public static final DeferredHolder<StructureType<?>, StructureType<VampireAltarStructure>> VAMPIRE_ALTAR_TYPE = STRUCTURE_TYPES.register("vampire_altar", () -> () -> VampireAltarStructure.CODEC);
    public static final DeferredHolder<StructureType<?>, StructureType<MotherStructure>> MOTHER_TYPE = STRUCTURE_TYPES.register("mother", () -> () -> MotherStructure.CODEC);
    public static final DeferredHolder<StructurePieceType, StructurePieceType> HUNTER_CAMP_FIREPLACE = STRUCTURE_PIECES.register("hunter_camp_fireplace", () -> HunterCampPieces.Fireplace::new);
    public static final DeferredHolder<StructurePieceType, StructurePieceType> HUNTER_CAMP_TENT = STRUCTURE_PIECES.register("hunter_camp_tent", () -> HunterCampPieces.Tent::new);
    public static final DeferredHolder<StructurePieceType, StructurePieceType> HUNTER_CAMP_SPECIAL = STRUCTURE_PIECES.register("hunter_camp_craftingtable", () -> HunterCampPieces.SpecialBlock::new);
    public static final DeferredHolder<StructurePieceType, StructurePieceType> VAMPIRE_HUT_PIECE = STRUCTURE_PIECES.register("vampire_hut", () -> VampireHutPieces.VampireHutPiece::new);
    public static final DeferredHolder<StructurePieceType, StructurePieceType> VAMPIRE_ALTAR_PIECE = STRUCTURE_PIECES.register("vampire_altar", () -> VampireAltarPieces.VampireAltarPiece::new);
    public static final DeferredHolder<StructurePieceType, StructurePieceType> MOTHER_PIECE = STRUCTURE_PIECES.register("mother", () -> MotherPiece::new);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<RandomStructureProcessor>> RANDOM_SELECTOR = STRUCTURE_PROCESSOR_TYPES.register("random_selector", () -> () -> RandomStructureProcessor.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<BiomeTopBlockProcessor>> BIOME_BASED = STRUCTURE_PROCESSOR_TYPES.register("biome_based", () -> () -> BiomeTopBlockProcessor.CODEC);
    public static final ResourceKey<Structure> HUNTER_CAMP = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)VResourceLocation.mod("hunter_camp"));
    public static final ResourceKey<Structure> VAMPIRE_HUT = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)VResourceLocation.mod("vampire_hut"));
    public static final ResourceKey<Structure> HUNTER_OUTPOST_PLAINS = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)VResourceLocation.mod("hunter_outpost_plains"));
    public static final ResourceKey<Structure> HUNTER_OUTPOST_DESERT = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)VResourceLocation.mod("hunter_outpost_desert"));
    public static final ResourceKey<Structure> HUNTER_OUTPOST_VAMPIRE_FOREST = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)VResourceLocation.mod("hunter_outpost_vampire_forest"));
    public static final ResourceKey<Structure> HUNTER_OUTPOST_BADLANDS = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)VResourceLocation.mod("hunter_outpost_badlands"));
    public static final ResourceKey<Structure> VAMPIRE_ALTAR = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)VResourceLocation.mod("vampire_altar"));
    public static final ResourceKey<Structure> MOTHER = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)VResourceLocation.mod("mother"));
    public static final ResourceKey<Structure> CRYPT = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)VResourceLocation.mod("crypt"));
    public static final ResourceKey<StructureTemplatePool> HUNTER_TRAINER = ModStructures.createTemplatePool("village/entities/hunter_trainer");
    public static final ResourceKey<StructureProcessorList> TOTEM_FACTION = ModStructures.createProcessorList("totem_faction");
    public static final ResourceKey<StructureSet> HUNTER_CAMP_SET = ModStructures.createStructureSetKey("hunter_camp");
    public static final ResourceKey<StructureSet> VAMPIRE_HUT_SET = ModStructures.createStructureSetKey("vampire_hut");
    public static final ResourceKey<StructureSet> VAMPIRE_ALTAR_SET = ModStructures.createStructureSetKey("vampire_altar");
    public static final ResourceKey<StructureSet> HUNTER_OUTPOST = ModStructures.createStructureSetKey("hunter_outpost");
    public static final ResourceKey<StructureSet> MOTHER_SET = ModStructures.createStructureSetKey("mother");
    public static final ResourceKey<StructureSet> CRYPT_SET = ModStructures.createStructureSetKey("crypt");

    private static ResourceKey<StructureSet> createStructureSetKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)VResourceLocation.mod(name));
    }

    public static ResourceKey<StructureTemplatePool> createTemplatePool(String name) {
        return ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)VResourceLocation.mod(name));
    }

    private static ResourceKey<StructureProcessorList> createProcessorList(String name) {
        return ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)VResourceLocation.mod(name));
    }

    static void register(IEventBus bus) {
        STRUCTURE_TYPES.register(bus);
        STRUCTURE_PIECES.register(bus);
        STRUCTURE_PROCESSOR_TYPES.register(bus);
    }

    static void createStructurePoolTemplates(BootstrapContext<StructureTemplatePool> context) {
        HolderGetter holderGetter = context.lookup(Registries.TEMPLATE_POOL);
        HolderGetter processorList = context.lookup(Registries.PROCESSOR_LIST);
        Holder.Reference empty = holderGetter.getOrThrow(Pools.EMPTY);
        context.register(HUNTER_TRAINER, (Object)new StructureTemplatePool((Holder)empty, (List)Lists.newArrayList((Object[])new Pair[]{Pair.of(VanillaStructureModifications.singleJigsawPieceFunction((HolderGetter<StructureProcessorList>)processorList, "village/entities/hunter_trainer"), (Object)1)}), StructureTemplatePool.Projection.RIGID));
        CryptStructurePieces.bootstrap(context);
        HunterOutpostPools.bootstrap(context);
    }

    static void createStructureProcessorLists(BootstrapContext<StructureProcessorList> context) {
        RandomStructureProcessor factionProcessor = new RandomStructureProcessor((List<RandomBlockStateRule>)ImmutableList.of((Object)((Object)new RandomBlockStateRule((RuleTest)new RandomBlockMatchTest((Block)ModBlocks.TOTEM_TOP.get(), 0.6f), (RuleTest)AlwaysTrueTest.INSTANCE, ((TotemTopBlock)((Object)ModBlocks.TOTEM_TOP.get())).defaultBlockState(), TotemTopBlock.getBlocks().stream().filter(totemx -> totemx != ModBlocks.TOTEM_TOP.get() && !totemx.isCrafted()).map(Block::defaultBlockState).collect(Collectors.toList())))));
        BiomeTopBlockProcessor biomeTopBlockProcessor = new BiomeTopBlockProcessor(Blocks.DIRT.defaultBlockState());
        context.register(TOTEM_FACTION, (Object)new StructureProcessorList((List)ImmutableList.of((Object)((Object)factionProcessor), (Object)((Object)biomeTopBlockProcessor))));
    }

    static void createStructureSets(BootstrapContext<StructureSet> context) {
        HolderGetter structureLookup = context.lookup(Registries.STRUCTURE);
        HolderGetter structureSetLookup = context.lookup(Registries.STRUCTURE_SET);
        Holder.Reference villageSet = structureSetLookup.getOrThrow(BuiltinStructureSets.VILLAGES);
        context.register(VAMPIRE_HUT_SET, (Object)new StructureSet((Holder)structureLookup.getOrThrow(VAMPIRE_HUT), (StructurePlacement)new RandomSpreadStructurePlacement(32, 10, RandomSpreadType.LINEAR, 1937195837)));
        context.register(VAMPIRE_ALTAR_SET, (Object)new StructureSet((Holder)structureLookup.getOrThrow(VAMPIRE_ALTAR), (StructurePlacement)new RandomSpreadStructurePlacement(32, 15, RandomSpreadType.LINEAR, 573190874)));
        context.register(MOTHER_SET, (Object)new StructureSet((Holder)structureLookup.getOrThrow(MOTHER), (StructurePlacement)new RandomSpreadStructurePlacement(48, 6, RandomSpreadType.TRIANGULAR, 1897236459)));
        context.register(CRYPT_SET, (Object)new StructureSet((Holder)structureLookup.getOrThrow(CRYPT), (StructurePlacement)new RandomSpreadStructurePlacement(32, 8, RandomSpreadType.LINEAR, 643510199)));
        context.register(HUNTER_OUTPOST, (Object)new StructureSet(List.of(StructureSet.entry((Holder)structureLookup.getOrThrow(HUNTER_OUTPOST_PLAINS)), StructureSet.entry((Holder)structureLookup.getOrThrow(HUNTER_OUTPOST_DESERT)), StructureSet.entry((Holder)structureLookup.getOrThrow(HUNTER_OUTPOST_VAMPIRE_FOREST)), StructureSet.entry((Holder)structureLookup.getOrThrow(HUNTER_OUTPOST_BADLANDS))), (StructurePlacement)new RandomSpreadStructurePlacement(45, 25, RandomSpreadType.LINEAR, 36413509)));
    }

    static void createStructures(BootstrapContext<Structure> context) {
        HolderGetter lookup = context.lookup(Registries.BIOME);
        HolderGetter lookup1 = context.lookup(Registries.TEMPLATE_POOL);
        context.register(VAMPIRE_HUT, (Object)new VampireHutStructure(new Structure.StructureSettings.Builder((HolderSet)lookup.getOrThrow(ModTags.Biomes.HasStructure.VAMPIRE_HUT)).terrainAdapation(TerrainAdjustment.NONE).build()));
        context.register(HUNTER_OUTPOST_PLAINS, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)lookup.getOrThrow(ModTags.Biomes.HasStructure.HUNTER_OUTPOST_PLAINS)).spawnOverrides(Map.of((MobCategory)VEnums.HUNTER_CATEGORY.getValue(), new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.create((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)ModEntities.HUNTER.get(), 80, 2, 4), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ADVANCED_HUNTER.get(), 20, 1, 22)})))).generationStep(GenerationStep.Decoration.SURFACE_STRUCTURES).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), (Holder)lookup1.getOrThrow(PlainsHunterOutpostPools.START), 7, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
        context.register(HUNTER_OUTPOST_DESERT, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)lookup.getOrThrow(ModTags.Biomes.HasStructure.HUNTER_OUTPOST_DESERT)).spawnOverrides(Map.of((MobCategory)VEnums.HUNTER_CATEGORY.getValue(), new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.create((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)ModEntities.HUNTER.get(), 80, 2, 4), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ADVANCED_HUNTER.get(), 20, 1, 22)})))).generationStep(GenerationStep.Decoration.SURFACE_STRUCTURES).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), (Holder)lookup1.getOrThrow(DesertHunterOutpostPools.START), 7, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
        context.register(HUNTER_OUTPOST_VAMPIRE_FOREST, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)lookup.getOrThrow(ModTags.Biomes.HasStructure.HUNTER_OUTPOST_VAMPIRE_FOREST)).spawnOverrides(Map.of((MobCategory)VEnums.HUNTER_CATEGORY.getValue(), new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.create((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)ModEntities.HUNTER.get(), 80, 2, 4), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ADVANCED_HUNTER.get(), 20, 1, 22)})))).generationStep(GenerationStep.Decoration.SURFACE_STRUCTURES).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), (Holder)lookup1.getOrThrow(VampireForestHunterOutpostPools.START), 7, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
        context.register(HUNTER_OUTPOST_BADLANDS, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)lookup.getOrThrow(ModTags.Biomes.HasStructure.HUNTER_OUTPOST_BADLANDS)).spawnOverrides(Map.of((MobCategory)VEnums.HUNTER_CATEGORY.getValue(), new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.create((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)ModEntities.HUNTER.get(), 80, 2, 4), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ADVANCED_HUNTER.get(), 20, 1, 22)})))).generationStep(GenerationStep.Decoration.SURFACE_STRUCTURES).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), (Holder)lookup1.getOrThrow(BadlandsHunterOutpostPools.START), 7, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
        context.register(VAMPIRE_ALTAR, (Object)new VampireAltarStructure(new Structure.StructureSettings.Builder((HolderSet)lookup.getOrThrow(ModTags.Biomes.HasStructure.VAMPIRE_ALTAR)).terrainAdapation(TerrainAdjustment.BEARD_BOX).build()));
        context.register(MOTHER, (Object)new MotherStructure(new Structure.StructureSettings.Builder((HolderSet)lookup.getOrThrow(ModTags.Biomes.HasStructure.MOTHER)).terrainAdapation(TerrainAdjustment.NONE).build()));
        context.register(CRYPT, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)lookup.getOrThrow(ModTags.Biomes.HasStructure.CRYPT)).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), (Holder)lookup1.getOrThrow(CryptStructurePieces.START), 7, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), false, Heightmap.Types.WORLD_SURFACE_WG));
    }
}

