/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.provider;

import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.data.ModBlockFamilies;
import de.teamlapen.vampirism.data.provider.AdvancementProvider;
import de.teamlapen.vampirism.data.provider.BlockStateProvider;
import de.teamlapen.vampirism.data.provider.DataMapsProvider;
import de.teamlapen.vampirism.data.provider.ItemModelGenerator;
import de.teamlapen.vampirism.data.provider.LootModifierGenerator;
import de.teamlapen.vampirism.data.provider.LootTablesProvider;
import de.teamlapen.vampirism.data.provider.RecipesProvider;
import de.teamlapen.vampirism.data.provider.SingleJigsawPiecesProvider;
import de.teamlapen.vampirism.data.provider.SkillTreeProvider;
import de.teamlapen.vampirism.data.provider.SundamageProvider;
import de.teamlapen.vampirism.data.provider.TagProvider;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="vampirism", bus=EventBusSubscriber.Bus.MOD)
public class DataProvider {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProviderFuture = event.getLookupProvider();
        ModBlockFamilies.init();
        DatapackBuiltinEntriesProvider provider = new DatapackBuiltinEntriesProvider(packOutput, lookupProviderFuture, ModRegistries.DATA_BUILDER, Set.of("vampirism"));
        lookupProviderFuture = provider.getRegistryProvider();
        generator.addProvider(event.includeServer(), (net.minecraft.data.DataProvider)provider);
        TagProvider.register(generator, event, packOutput, lookupProviderFuture, existingFileHelper);
        generator.addProvider(event.includeServer(), (net.minecraft.data.DataProvider)LootTablesProvider.getProvider(packOutput, lookupProviderFuture));
        generator.addProvider(event.includeServer(), (net.minecraft.data.DataProvider)new AdvancementProvider(packOutput, lookupProviderFuture, existingFileHelper));
        generator.addProvider(event.includeServer(), (net.minecraft.data.DataProvider)new RecipesProvider(packOutput, lookupProviderFuture));
        generator.addProvider(event.includeClient(), (net.minecraft.data.DataProvider)new BlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (net.minecraft.data.DataProvider)new ItemModelGenerator(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (net.minecraft.data.DataProvider)new SingleJigsawPiecesProvider(packOutput, "vampirism"));
        generator.addProvider(event.includeServer(), (net.minecraft.data.DataProvider)new SundamageProvider(packOutput, "vampirism"));
        generator.addProvider(event.includeServer(), (net.minecraft.data.DataProvider)new SkillTreeProvider(packOutput, lookupProviderFuture));
        generator.addProvider(event.includeServer(), (net.minecraft.data.DataProvider)new DataMapsProvider(packOutput, lookupProviderFuture));
        generator.addProvider(event.includeServer(), (net.minecraft.data.DataProvider)new LootModifierGenerator(packOutput, lookupProviderFuture));
    }
}

