/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.recipebuilder;

import de.teamlapen.vampirism.advancements.critereon.SkillUnlockedCriterionTrigger;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.recipes.ShapelessWeaponTableRecipe;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShapelessWeaponTableRecipeBuilder
extends ShapelessRecipeBuilder {
    private int lava = 1;
    private final List<ISkill<IHunterPlayer>> skills = new LinkedList<ISkill<IHunterPlayer>>();
    private int level = 1;

    @NotNull
    public static ShapelessWeaponTableRecipeBuilder shapelessWeaponTable(@NotNull RecipeCategory category, @NotNull ItemLike result, int count) {
        return new ShapelessWeaponTableRecipeBuilder(category, result, count);
    }

    @NotNull
    public static ShapelessWeaponTableRecipeBuilder shapelessWeaponTable(@NotNull RecipeCategory category, @NotNull ItemLike result) {
        return new ShapelessWeaponTableRecipeBuilder(category, result, 1);
    }

    public ShapelessWeaponTableRecipeBuilder(@NotNull RecipeCategory category, @NotNull ItemLike resultIn, int countIn) {
        super(category, resultIn, countIn);
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder group(@Nullable String groupIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.group(groupIn);
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder requires(@NotNull ItemLike itemIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.requires(itemIn);
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder requires(@NotNull ItemLike itemIn, int quantity) {
        return (ShapelessWeaponTableRecipeBuilder)super.requires(itemIn, quantity);
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder requires(@NotNull Ingredient ingredientIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.requires(ingredientIn);
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder requires(@NotNull Ingredient ingredientIn, int quantity) {
        return (ShapelessWeaponTableRecipeBuilder)super.requires(ingredientIn, quantity);
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder requires(@NotNull TagKey<Item> tagIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.requires(tagIn);
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        this.ensureValid(id);
        Advancement.Builder advancement$builder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        advancement$builder.addCriterion("has_skill", ((SkillUnlockedCriterionTrigger)((Object)ModAdvancements.TRIGGER_SKILL_UNLOCKED.get())).createCriterion((CriterionTriggerInstance)new SkillUnlockedCriterionTrigger.TriggerInstance(Optional.empty(), (ISkill)HunterSkills.WEAPON_TABLE.get())));
        this.skills.forEach(skill -> advancement$builder.addCriterion("has_skill_" + RegUtil.id(skill).toString().replace(":", "_"), ((SkillUnlockedCriterionTrigger)((Object)((Object)ModAdvancements.TRIGGER_SKILL_UNLOCKED.get()))).createCriterion((CriterionTriggerInstance)new SkillUnlockedCriterionTrigger.TriggerInstance(Optional.empty(), (ISkill<?>)skill))));
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        ShapelessWeaponTableRecipe shapelessrecipe = new ShapelessWeaponTableRecipe(Objects.requireNonNullElse(this.group, ""), RecipeBuilder.determineBookCategory((RecipeCategory)this.category), (NonNullList<Ingredient>)this.ingredients, new ItemStack((ItemLike)this.result, this.count), this.level, this.lava, this.skills);
        output.accept(id, (Recipe)shapelessrecipe, advancement$builder.build(id.withPrefix("recipes/weapontable/")));
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder lava(int amount) {
        this.lava = amount;
        return this;
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder level(int level) {
        this.level = level;
        return this;
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder unlockedBy(String p_176781_, Criterion<?> p_300897_) {
        return (ShapelessWeaponTableRecipeBuilder)super.unlockedBy(p_176781_, p_300897_);
    }

    @SafeVarargs
    @NotNull
    public final ShapelessWeaponTableRecipeBuilder skills(ISkill<IHunterPlayer> ... skills) {
        this.skills.addAll(Arrays.asList(skills));
        return this;
    }
}

