/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.effects;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.util.TotemHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BadOmenEffect
extends MobEffect {
    public static void handlePotentialBannerKill(@Nullable Entity offender, @NotNull IFactionEntity victim) {
        if (offender instanceof Player) {
            Holder<MobEffect> badOmen;
            IPlayableFaction<?> playerFaction;
            Player player = (Player)offender;
            IFaction<?> faction = victim.getFaction();
            if (faction.getVillageData().isBanner(victim.asEntity().getItemBySlot(EquipmentSlot.HEAD), (HolderLookup.Provider)offender.registryAccess()) && (playerFaction = VampirismPlayerAttributes.get((Player)player).faction) != null && playerFaction != faction && (badOmen = faction.getVillageData().badOmenEffect()) != null) {
                int i;
                MobEffectInstance inst = player.getEffect(badOmen);
                int n = i = inst != null ? Math.min(inst.getAmplifier() + 1, 4) : 0;
                if (inst != null) {
                    player.removeEffectNoUpdate(badOmen);
                }
                player.addEffect(new MobEffectInstance(badOmen, 120000, i, false, false, true));
            }
        }
    }

    public BadOmenEffect() {
        super(MobEffectCategory.NEUTRAL, 745784);
    }

    public abstract IFaction<?> getFaction();

    public boolean applyEffectTick(@NotNull LivingEntity entityLivingBaseIn, int amplifier) {
        if (entityLivingBaseIn instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)entityLivingBaseIn;
            if (!entityLivingBaseIn.isSpectator()) {
                ServerLevel serverWorld = playerEntity.serverLevel();
                if (serverWorld.getDifficulty() == Difficulty.PEACEFUL) {
                    return true;
                }
                return TotemHelper.getTotemNearPos(serverWorld, entityLivingBaseIn.blockPosition(), true).filter(s -> s.getControllingFaction() != this.getFaction()).map(totem -> totem.initiateCaptureOrIncreaseBadOmenLevel(this.getFaction(), null, Math.min(amplifier, 4) + 1, 0.0f)).orElse(false) == false;
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int p_295329_, int p_295167_) {
        return true;
    }
}

