/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import de.teamlapen.vampirism.util.DamageHandler;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DarkBloodProjectileEntity
extends AbstractHurtingProjectile {
    protected float directDamage = 4.0f;
    protected float indirectDamage = 2.0f;
    private boolean initialNoClip = false;
    private float motionFactor = 0.97f;
    private boolean excludeShooter = false;
    private boolean gothrough;
    private int maxTicks = 40;

    public DarkBloodProjectileEntity(@NotNull EntityType<? extends DarkBloodProjectileEntity> type, @NotNull Level worldIn) {
        super(type, worldIn);
    }

    public DarkBloodProjectileEntity(@NotNull Level worldIn, @NotNull LivingEntity shooter, Vec3 accel) {
        super((EntityType)ModEntities.DARK_BLOOD_PROJECTILE.get(), shooter, accel, worldIn);
    }

    public DarkBloodProjectileEntity(@NotNull Level worldIn, double x, double y, double z, Vec3 accel) {
        super((EntityType)ModEntities.DARK_BLOOD_PROJECTILE.get(), x, y, z, accel, worldIn);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("direct_damage", this.directDamage);
        compound.putFloat("indirect_damage", this.indirectDamage);
        compound.putBoolean("gothrough", this.gothrough);
        compound.putInt("max_ticks", this.maxTicks);
        compound.putFloat("motion_factor", this.motionFactor);
    }

    public void explode(int distanceSq, @Nullable Entity excludeEntity) {
        @Nullable Entity shootingEntity = this.getOwner();
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)distanceSq / 2.0), EntitySelector.ENTITY_STILL_ALIVE.and(EntitySelector.NO_SPECTATORS).and(s -> !(s instanceof Ignore)));
        for (Entity e : list) {
            if (this.excludeShooter && e == shootingEntity || e == excludeEntity || !(e instanceof LivingEntity)) continue;
            LivingEntity entity = (LivingEntity)e;
            if (!(e.distanceToSqr((Entity)this) < (double)distanceSq)) continue;
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 1));
            DamageHandler.hurtVanilla((Entity)entity, damageSources -> damageSources.indirectMagic((Entity)this, this.getOwner()), this.indirectDamage);
        }
        if (!this.level().isClientSide) {
            ModParticles.spawnParticlesServer(this.level(), new GenericParticleOptions(VResourceLocation.mc("spell_1"), 7, 0xA01010, 0.2f), this.getX(), this.getY(), this.getZ(), 40, 1.0, 1.0, 1.0, 0.0);
            ModParticles.spawnParticlesServer(this.level(), new GenericParticleOptions(VResourceLocation.mc("spell_6"), 10, 0x700505), this.getX(), this.getY(), this.getZ(), 15, 1.0, 1.0, 1.0, 0.0);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSounds.BLOOD_PROJECTILE_HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.discard();
    }

    public void excludeShooter() {
        this.excludeShooter = true;
    }

    public float getPickRadius() {
        return 0.5f;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        return false;
    }

    public void setDamage(float direct, float indirect) {
        this.directDamage = direct;
        this.indirectDamage = indirect;
    }

    public void setGothrough(boolean gothrough) {
        this.gothrough = gothrough;
    }

    public void setInitialNoClip() {
        this.initialNoClip = true;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.directDamage = compound.getFloat("direct_damage");
        this.indirectDamage = compound.getFloat("indirect_damage");
        this.gothrough = compound.getBoolean("gothrough");
        this.maxTicks = compound.getInt("max_ticks");
        this.motionFactor = compound.getFloat("motion_factor");
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            Vec3 center = this.position();
            ModParticles.spawnParticlesClient(this.level(), new GenericParticleOptions(VResourceLocation.mc("spell_4"), 4, 0xA01010, 0.0f), center.x, center.y, center.z, 5, this.getPickRadius(), this.random);
            if (this.tickCount % 3 == 0) {
                ModParticles.spawnParticleClient(this.level(), new GenericParticleOptions(VResourceLocation.mc("effect_4"), 12, 0xC01010, 0.4f), center.x, center.y, center.z);
            }
        }
        if (this.tickCount > this.maxTicks) {
            if (!this.level().isClientSide()) {
                this.explode(4, null);
            } else {
                this.discard();
            }
        }
    }

    protected float getInertia() {
        return this.motionFactor;
    }

    public void setMotionFactor(float factor) {
        this.motionFactor = factor;
    }

    @NotNull
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.UNDERWATER;
    }

    protected void onHit(@NotNull HitResult result) {
        if (!this.level().isClientSide) {
            if (this.initialNoClip && this.tickCount > 20 && result.getType() == HitResult.Type.BLOCK) {
                return;
            }
            Entity entity = null;
            if (result.getType() == HitResult.Type.ENTITY) {
                entity = ((EntityHitResult)result).getEntity();
                if (entity instanceof DarkBloodProjectileEntity) {
                    return;
                }
                this.hitEntity(entity);
            }
            if (!this.gothrough) {
                this.explode(4, entity);
            }
        }
    }

    protected boolean shouldBurn() {
        return false;
    }

    private void hitEntity(@NotNull Entity entity) {
        DamageHandler.hurtVanilla(entity, damageSources -> damageSources.indirectMagic((Entity)this, this.getOwner()), this.directDamage);
        if (entity instanceof LivingEntity && this.random.nextInt(3) == 0) {
            ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100));
            ((LivingEntity)entity).knockback(1.0, -this.getDeltaMovement().x, -this.getDeltaMovement().z);
            ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 1));
        }
    }

    public static interface Ignore {
    }
}

