/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class VampirismVillagerEntity
extends Villager {
    protected boolean peaceful = false;
    private int randomTickDivider;

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        return Villager.createAttributes().add(Attributes.ATTACK_DAMAGE);
    }

    public VampirismVillagerEntity(@NotNull EntityType<? extends VampirismVillagerEntity> type, @NotNull Level worldIn) {
        super(type, worldIn);
    }

    public VampirismVillagerEntity(@NotNull EntityType<? extends VampirismVillagerEntity> type, @NotNull Level worldIn, @NotNull VillagerType villagerType) {
        super(type, worldIn, villagerType);
    }

    public void aiStep() {
        this.updateSwingTime();
        super.aiStep();
    }

    public boolean checkSpawnRules(@NotNull LevelAccessor worldIn, @NotNull MobSpawnType spawnReasonIn) {
        return (this.peaceful || worldIn.getDifficulty() != Difficulty.PEACEFUL) && super.checkSpawnRules(worldIn, spawnReasonIn);
    }

    public boolean hurt(@NotNull DamageSource src, float amount) {
        if (this.isInvulnerableTo(src)) {
            return false;
        }
        if (super.hurt(src, amount)) {
            Entity entity = src.getEntity();
            if (entity instanceof LivingEntity) {
                this.setTarget((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && !this.peaceful && this.level().getDifficulty() == Difficulty.PEACEFUL) {
            this.discard();
        }
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (--this.randomTickDivider <= 0) {
            this.randomTickDivider = 200;
        }
    }
}

