/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.sensing;

import com.google.common.collect.Maps;
import de.teamlapen.vampirism.mixin.accessor.VillagerHostilesSensorAccessor;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.sensing.VillagerHostilesSensor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampireVillagerHostilesSensor
extends VillagerHostilesSensor {
    @NotNull
    public static final Map<EntityType<?>, Float> hostiles = Maps.newHashMap(VillagerHostilesSensorAccessor.getACCEPTABLE_DISTANCE_FROM_HOSTILES());

    public boolean isClose(@NotNull LivingEntity villager, @NotNull LivingEntity hostile) {
        @Nullable Float f = hostiles.get(hostile.getType());
        if (f == null) {
            return false;
        }
        return hostile.distanceToSqr((Entity)villager) <= (double)(f.floatValue() * f.floatValue());
    }

    public boolean isHostile(@NotNull LivingEntity hostile) {
        return hostiles.containsKey(hostile.getType());
    }

    static {
        hostiles.remove(EntityType.ZOMBIE);
        hostiles.remove(EntityType.ZOMBIE_VILLAGER);
        hostiles.remove(EntityType.DROWNED);
        hostiles.remove(EntityType.HUSK);
    }
}

