/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.storage.IAttachment;
import de.teamlapen.lib.lib.util.LogUtil;
import de.teamlapen.vampirism.advancements.critereon.FactionCriterionTrigger;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.event.PlayerFactionEvent;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModAttachments;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.entity.player.IVampirismPlayer;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.misc.VampirismLogger;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import de.teamlapen.vampirism.util.VampirismEventFactory;
import de.teamlapen.vampirism.world.MinionWorldData;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FactionPlayerHandler
implements IAttachment,
IFactionPlayerHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String NBT_KEY = "faction_player_handler";
    public static final ResourceLocation SERIALIZER_ID = VResourceLocation.mod("faction_player_handler");
    private final Player player;
    @NotNull
    private final Int2ObjectMap<IAction<?>> boundActions = new Int2ObjectArrayMap();
    @Nullable
    private IPlayableFaction<?> currentFaction = null;
    private int currentLevel = 0;
    private int currentLordLevel = 0;
    @NotNull
    private IPlayableFaction.TitleGender titleGender = IPlayableFaction.TitleGender.UNKNOWN;

    @NotNull
    public static FactionPlayerHandler get(@NotNull Player player) {
        return (FactionPlayerHandler)player.getData((AttachmentType)ModAttachments.FACTION_PLAYER_HANDLER.get());
    }

    @Deprecated
    @NotNull
    public static Optional<FactionPlayerHandler> getOpt(@NotNull Player player) {
        return Optional.of((FactionPlayerHandler)player.getData((AttachmentType)ModAttachments.FACTION_PLAYER_HANDLER.get()));
    }

    @NotNull
    public static Optional<? extends IFactionPlayer<?>> getCurrentFactionPlayer(@NotNull Player player) {
        return FactionPlayerHandler.get(player).getCurrentFactionPlayer();
    }

    public FactionPlayerHandler(Player player) {
        this.player = player;
    }

    @Override
    @NotNull
    public Player asEntity() {
        return this.player;
    }

    @Override
    public boolean canJoin(IPlayableFaction<?> faction) {
        PlayerFactionEvent.CanJoinFaction.Behavior behavior = VampirismEventFactory.fireCanJoinFactionEvent(this, this.currentFaction, faction);
        if (behavior == PlayerFactionEvent.CanJoinFaction.Behavior.ONLY_WHEN_NO_FACTION) {
            return this.currentFaction == null;
        }
        return behavior == PlayerFactionEvent.CanJoinFaction.Behavior.ALLOW;
    }

    @Override
    public boolean canLeaveFaction() {
        return this.currentFaction == null || this.currentFaction.getPlayerCapability(this.player).map(IFactionPlayer::canLeaveFaction).orElse(false) != false;
    }

    @Nullable
    public IAction<?> getBoundAction(int id) {
        return (IAction)this.boundActions.get(id);
    }

    @Override
    @NotNull
    public ResourceLocation getAttachedKey() {
        return SERIALIZER_ID;
    }

    @Override
    @Nullable
    public IPlayableFaction<?> getCurrentFaction() {
        return this.currentFaction;
    }

    @Override
    @NotNull
    public Optional<? extends IFactionPlayer<?>> getCurrentFactionPlayer() {
        return this.currentFaction == null ? Optional.empty() : this.currentFaction.getPlayerCapability(this.player);
    }

    @Override
    public int getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    public int getCurrentLevel(IPlayableFaction<?> f) {
        return this.isInFaction(f) ? this.currentLevel : 0;
    }

    @Override
    public float getCurrentLevelRelative() {
        return this.currentFaction == null ? 0.0f : (float)this.currentLevel / (float)this.currentFaction.getHighestReachableLevel();
    }

    @Override
    @Nullable
    public IPlayableFaction<?> getLordFaction() {
        return this.currentLordLevel > 0 ? this.currentFaction : null;
    }

    @Override
    public int getLordLevel() {
        return this.currentLordLevel;
    }

    @Override
    @Nullable
    public Component getLordTitle() {
        return this.currentLordLevel == 0 || this.currentFaction == null ? null : this.currentFaction.getLordTitle(this.currentLordLevel, this.titleGender);
    }

    public int getMaxMinions() {
        return this.currentLordLevel * (Integer)VampirismConfig.BALANCE.miMinionPerLordLevel.get();
    }

    @Override
    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public IPlayableFaction.TitleGender titleGender() {
        return this.titleGender;
    }

    @Override
    public boolean isInFaction(@Nullable IFaction<?> f) {
        return Objects.equals(this.currentFaction, f);
    }

    @Override
    public void joinFaction(@NotNull IPlayableFaction<?> faction) {
        if (this.canJoin(faction)) {
            this.setFactionAndLevel(faction, 1);
        }
    }

    @Override
    public void deserializeUpdateNBT(HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        IPlayableFaction<?> old = this.currentFaction;
        int oldLevel = this.currentLevel;
        if (nbt.contains("faction", 8)) {
            String f = nbt.getString("faction");
            if ("null".equals(f)) {
                this.currentFaction = null;
                this.currentLevel = 0;
                this.currentLordLevel = 0;
            } else {
                this.currentFaction = this.getFactionFromKey(ResourceLocation.parse((String)f));
                if (this.currentFaction == null) {
                    LOGGER.error("Cannot find faction {} on client. You have to register factions on both sides!", (Object)f);
                    this.currentLevel = 0;
                } else {
                    this.currentLevel = nbt.getInt("level");
                    this.currentLordLevel = nbt.getInt("lord_level");
                }
            }
            if (old != this.currentFaction || oldLevel != this.currentLevel) {
                VampirismEventFactory.fireFactionLevelChangedEvent(this, old, oldLevel, this.currentFaction, this.currentLevel);
            }
        }
        if (nbt.contains("title_gender", 8)) {
            this.titleGender = IPlayableFaction.TitleGender.valueOf(nbt.getString("title_gender"));
        }
        this.loadBoundActions(nbt);
        this.updateCache();
        this.notifyFaction(old, oldLevel);
    }

    @Override
    public boolean onEntityAttacked(DamageSource src, float amt) {
        if (((Boolean)VampirismConfig.SERVER.pvpOnlyBetweenFactions.get()).booleanValue() && src.getEntity() instanceof Player) {
            IPlayableFaction<?> otherFaction = FactionPlayerHandler.get((Player)src.getEntity()).getCurrentFaction();
            if (this.currentFaction == null || otherFaction == null) {
                return (Boolean)VampirismConfig.SERVER.pvpOnlyBetweenFactionsIncludeHumans.get();
            }
            return !this.currentFaction.equals(otherFaction);
        }
        return true;
    }

    public void resetLordTasks(int minLevel) {
        this.getCurrentFactionPlayer().map(IFactionPlayer::getTaskManager).ifPresent(manager -> this.player.level().registryAccess().registryOrThrow(VampirismRegistries.Keys.TASK).getTagOrEmpty(ModTags.Tasks.AWARDS_LORD_LEVEL).forEach(holder -> holder.unwrapKey().ifPresent(manager::resetUniqueTask)));
    }

    public void setBoundAction(int id, @Nullable IAction<?> boundAction, boolean sync, boolean notify) {
        if (boundAction == null) {
            this.boundActions.remove(id);
        } else {
            this.boundActions.put(id, boundAction);
        }
        if (notify) {
            this.player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.actions.bind_action", (Object[])new Object[]{boundAction != null ? boundAction.getName() : "none", id}), true);
        }
        if (sync) {
            this.sync(false);
        }
    }

    @Override
    public boolean setFactionAndLevel(@Nullable IPlayableFaction<?> faction, int level) {
        IPlayableFaction<?> old = this.currentFaction;
        int oldLevel = this.currentLevel;
        int newLordLevel = this.currentLordLevel;
        if (!(this.currentFaction == null || this.currentFaction.equals(faction) && level != 0 || this.currentFaction.getPlayerCapability(this.player).map(IFactionPlayer::canLeaveFaction).orElse(false).booleanValue())) {
            LOGGER.info("You cannot leave faction {}, it is prevented by respective mod", (Object)this.currentFaction.getID());
            return false;
        }
        if (faction != null && (level < 0 || level > faction.getHighestReachableLevel())) {
            LOGGER.warn("Level {} in faction {} cannot be reached", (Object)level, (Object)faction.getID());
            return false;
        }
        if (VampirismEventFactory.fireChangeLevelOrFactionEvent(this, old, oldLevel, faction, faction == null ? 0 : level)) {
            LOGGER.debug("Faction or Level change event canceled");
            return false;
        }
        if (this.currentFaction != null && faction != this.currentFaction) {
            this.currentFaction.getPlayerCapability(this.player).ifPresent(factionPlayer -> factionPlayer.getTaskManager().reset());
        }
        if (faction == null) {
            this.currentFaction = null;
            this.currentLevel = 0;
            newLordLevel = 0;
        } else {
            this.currentFaction = faction;
            this.currentLevel = level;
            if (this.currentLevel != this.currentFaction.getHighestReachableLevel() || this.currentFaction != old) {
                newLordLevel = 0;
            }
        }
        if (this.currentLevel == 0) {
            this.currentFaction = null;
            newLordLevel = 0;
        }
        if (this.currentLordLevel != newLordLevel) {
            this.setLordLevel(newLordLevel, false);
        }
        this.checkSkillTreeLocks();
        this.updateCache();
        this.notifyFaction(old, oldLevel);
        if (this.player instanceof ServerPlayer && (this.currentFaction != old || oldLevel != this.currentLevel)) {
            if (old == this.currentFaction) {
                VampirismLogger.info(VampirismLogger.LEVEL, "{} has new faction level {} {}, was {}", this.player.getName().getString(), this.currentFaction.getID(), this.currentLevel, oldLevel);
            } else if (this.currentFaction != null) {
                VampirismLogger.info(VampirismLogger.LEVEL, "{} is now in faction {} {}", this.player.getName().getString(), this.currentFaction.getID(), this.currentLevel);
            } else {
                VampirismLogger.info(VampirismLogger.LEVEL, "{} has now no level", this.player.getName().getString());
            }
        }
        if (old != this.currentFaction || oldLevel != this.currentLevel) {
            VampirismEventFactory.fireFactionLevelChangedEvent(this, old, oldLevel, this.currentFaction, this.currentLevel);
        }
        this.sync(!Objects.equals(old, this.currentFaction));
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (old != faction) {
                ((FactionCriterionTrigger)((Object)ModAdvancements.TRIGGER_FACTION.get())).revokeAll(serverPlayer);
                ModAdvancements.revoke((PlayerTrigger)ModAdvancements.TRIGGER_MOTHER_WIN.get(), serverPlayer);
            } else if (oldLevel > level) {
                ((FactionCriterionTrigger)((Object)ModAdvancements.TRIGGER_FACTION.get())).revokeLevel(serverPlayer, faction, FactionCriterionTrigger.Type.LEVEL, level);
            }
            ((FactionCriterionTrigger)((Object)ModAdvancements.TRIGGER_FACTION.get())).trigger(serverPlayer, this.currentFaction, this.currentLevel, this.currentLordLevel);
        }
        return true;
    }

    @Override
    public boolean setFactionLevel(@NotNull IPlayableFaction<?> faction, int level) {
        return faction.equals(this.currentFaction) && this.setFactionAndLevel(faction, level);
    }

    @Override
    public boolean setLordLevel(int level) {
        return this.setLordLevel(level, true);
    }

    public boolean setTitleGender(boolean female) {
        this.titleGender = female ? IPlayableFaction.TitleGender.FEMALE : IPlayableFaction.TitleGender.MALE;
        this.player.refreshDisplayName();
        if (!this.player.level().isClientSide()) {
            this.sync(true);
        }
        return true;
    }

    @Override
    @NotNull
    public CompoundTag serializeUpdateNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("faction", this.currentFaction == null ? "null" : this.currentFaction.getID().toString());
        nbt.putInt("level", this.currentLevel);
        nbt.putInt("lord_level", this.currentLordLevel);
        nbt.putString("title_gender", this.titleGender.name());
        this.writeBoundActions(nbt);
        return nbt;
    }

    @Override
    public void leaveFaction(boolean die) {
        IPlayableFaction<?> oldFaction = this.currentFaction;
        if (oldFaction == null) {
            return;
        }
        this.setFactionAndLevel(null, 0);
        this.player.displayClientMessage((Component)Component.translatable((String)"command.vampirism.base.level.successful", (Object[])new Object[]{this.player.getName(), oldFaction.getName(), 0}), true);
        if (die) {
            DamageHandler.kill((Entity)this.player, 10000);
        }
    }

    @Nullable
    private IPlayableFaction<?> getFactionFromKey(ResourceLocation key) {
        for (IPlayableFaction<?> p : VampirismAPI.factionRegistry().getPlayableFactions()) {
            if (!p.getID().equals((Object)key)) continue;
            return p;
        }
        return null;
    }

    private void loadBoundActions(@NotNull CompoundTag nbt) {
        CompoundTag bounds = nbt.getCompound("bound_actions");
        for (String s : bounds.getAllKeys()) {
            int id = Integer.parseInt(s);
            IAction<?> action = RegUtil.getAction(ResourceLocation.parse((String)bounds.getString(s)));
            if (action == null) {
                LOGGER.warn("Cannot find bound action {}", (Object)bounds.getString(s));
                continue;
            }
            this.boundActions.put(id, action);
        }
    }

    @Override
    public void checkSkillTreeLocks() {
        Level level = this.player.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Registry registryAccess = this.player.level().registryAccess().registryOrThrow(VampirismRegistries.Keys.SKILL_TREE);
            this.getCurrentFactionPlayer().ifPresent(factionPlayer -> factionPlayer.getSkillHandler().updateUnlockedSkillTrees(registryAccess.holders().filter(s -> ((ISkillTree)s.value()).unlockPredicate().matches(level2, null, (Entity)this.player)).collect(Collectors.toList())));
        }
    }

    private void notifyFaction(@Nullable IPlayableFaction<?> oldFaction, int oldLevel) {
        if (oldFaction != null && !oldFaction.equals(this.currentFaction)) {
            LOGGER.debug(LogUtil.FACTION, "{} is leaving faction {}", (Object)this.player.getName().getString(), (Object)oldFaction.getID());
            VampirismLogger.info(VampirismLogger.LEVEL, "{} is leaving faction {}", this.player.getName().getString(), oldFaction.getID());
            oldFaction.getPlayerCapability(this.player).ifPresent(c -> c.onLevelChanged(0, oldLevel));
        }
        if (this.currentFaction != null) {
            LOGGER.debug(LogUtil.FACTION, "{} has new faction level {} {}", (Object)this.player.getName().getString(), (Object)this.currentFaction.getID(), (Object)this.currentLevel);
            this.currentFaction.getPlayerCapability(this.player).ifPresent(c -> c.onLevelChanged(this.currentLevel, Objects.equals(oldFaction, this.currentFaction) ? oldLevel : 0));
        }
        ScoreboardUtil.updateScoreboard(this.player, ScoreboardUtil.FACTION_CRITERIA, this.currentFaction == null ? 0 : this.currentFaction.getID().hashCode());
    }

    private boolean setLordLevel(int level, boolean sync) {
        int oldLevel = this.currentLordLevel;
        if (level > 0 && (this.currentFaction == null || this.currentLevel != this.currentFaction.getHighestReachableLevel() || level > this.currentFaction.getHighestLordLevel())) {
            return false;
        }
        if (level < this.currentLordLevel) {
            this.resetLordTasks(level);
        }
        this.currentLordLevel = level;
        this.checkSkillTreeLocks();
        this.updateCache();
        MinionWorldData.getData(this.player.level()).ifPresent(data -> {
            PlayerMinionController c = data.getController(this.player.getUUID());
            if (c != null) {
                c.setMaxMinions(this.currentFaction, this.getMaxMinions());
            }
        });
        if (level == 0) {
            LOGGER.debug(LogUtil.FACTION, "Resetting lord level for {}", (Object)this.player.getName().getString());
            VampirismLogger.info(VampirismLogger.LORD_LEVEL, "Resetting lord level for {}", this.player.getName().getString());
        } else {
            LOGGER.debug(LogUtil.FACTION, "{} has now lord level {}", (Object)this.player.getName().getString(), (Object)level);
            VampirismLogger.info(VampirismLogger.LORD_LEVEL, "{} has now lord level {}", this.player.getName().getString(), level);
        }
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.currentLordLevel < oldLevel) {
                ((FactionCriterionTrigger)((Object)ModAdvancements.TRIGGER_FACTION.get())).revokeLevel(serverPlayer, this.currentFaction, FactionCriterionTrigger.Type.LORD, this.currentLordLevel);
            }
            ((FactionCriterionTrigger)((Object)ModAdvancements.TRIGGER_FACTION.get())).trigger(serverPlayer, this.currentFaction, this.currentLevel, this.currentLordLevel);
        }
        if (sync) {
            this.sync(false);
        }
        return true;
    }

    private void sync(boolean all) {
        HelperLib.sync(this, (Entity)this.player, all);
    }

    private void updateCache() {
        this.player.refreshDisplayName();
        VampirismPlayerAttributes atts = ((IVampirismPlayer)this.player).getVampAtts();
        atts.hunterLevel = this.currentFaction == VReference.HUNTER_FACTION ? this.currentLevel : 0;
        atts.vampireLevel = this.currentFaction == VReference.VAMPIRE_FACTION ? this.currentLevel : 0;
        atts.lordLevel = this.currentLordLevel;
        atts.faction = this.currentFaction;
    }

    private void writeBoundActions(@NotNull CompoundTag nbt) {
        CompoundTag bounds = new CompoundTag();
        for (Int2ObjectMap.Entry entry : this.boundActions.int2ObjectEntrySet()) {
            bounds.putString(String.valueOf(entry.getIntKey()), RegUtil.id((IAction)entry.getValue()).toString());
        }
        nbt.put("bound_actions", (Tag)bounds);
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        if (this.currentFaction != null) {
            nbt.putString("faction", this.currentFaction.getID().toString());
            nbt.putInt("level", this.currentLevel);
            nbt.putInt("lord_level", this.currentLordLevel);
        }
        nbt.putString("title_gender", this.titleGender.name());
        this.writeBoundActions(nbt);
        return nbt;
    }

    @Override
    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        if (nbt.contains("faction")) {
            this.currentFaction = this.getFactionFromKey(ResourceLocation.parse((String)nbt.getString("faction")));
            if (this.currentFaction == null) {
                LOGGER.warn("Could not find faction {}. Did mods change?", (Object)nbt.getString("faction"));
            } else {
                this.currentLevel = Math.min(nbt.getInt("level"), this.currentFaction.getHighestReachableLevel());
                this.currentLordLevel = Math.min(nbt.getInt("lord_level"), this.currentFaction.getHighestLordLevel());
                this.notifyFaction(null, 0);
            }
        }
        if (nbt.contains("title_gender")) {
            this.titleGender = IPlayableFaction.TitleGender.valueOf(nbt.getString("title_gender"));
        }
        this.loadBoundActions(nbt);
        this.updateCache();
    }

    @Override
    public String nbtKey() {
        return NBT_KEY;
    }

    public static class Factory
    implements Function<IAttachmentHolder, FactionPlayerHandler> {
        @Override
        public FactionPlayerHandler apply(IAttachmentHolder holder) {
            if (holder instanceof Player) {
                Player player = (Player)holder;
                return new FactionPlayerHandler(player);
            }
            throw new IllegalArgumentException("Cannot create faction player handler attachment for holder " + String.valueOf(holder.getClass()) + ". Expected Player");
        }
    }

    public static class Serializer
    implements IAttachmentSerializer<CompoundTag, FactionPlayerHandler> {
        @NotNull
        public FactionPlayerHandler read(@NotNull IAttachmentHolder holder, @NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            if (holder instanceof Player) {
                Player player = (Player)holder;
                FactionPlayerHandler handler = new FactionPlayerHandler(player);
                handler.deserializeNBT(provider, tag);
                return handler;
            }
            throw new IllegalStateException("Cannot deserialize FactionPlayerHandler for non player entity");
        }

        public CompoundTag write(FactionPlayerHandler attachment, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            return attachment.serializeNBT(provider);
        }
    }
}

