/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionBuilder;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IFactionRegistry;
import de.teamlapen.vampirism.api.entity.factions.IFactionVillageBuilder;
import de.teamlapen.vampirism.api.entity.factions.ILordPlayerBuilder;
import de.teamlapen.vampirism.api.entity.factions.IMinionBuilder;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFactionBuilder;
import de.teamlapen.vampirism.api.entity.minion.IMinionData;
import de.teamlapen.vampirism.api.entity.minion.IMinionEntity;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.entity.factions.Faction;
import de.teamlapen.vampirism.entity.factions.FactionPredicate;
import de.teamlapen.vampirism.entity.factions.FactionVillageBuilder;
import de.teamlapen.vampirism.entity.factions.PlayableFaction;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FactionRegistry
implements IFactionRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Integer, Predicate<LivingEntity>> predicateMap = new HashMap<Integer, Predicate<LivingEntity>>();
    @Nullable
    private List<Faction<?>> temp = new CopyOnWriteArrayList();
    @Nullable
    private List<Pair<ResourceLocation, MinionEntry<?, ?>>> tempMinions = Collections.synchronizedList(new ArrayList());
    private Faction<?>[] allFactions;
    private PlayableFaction<?>[] playableFactions;
    private final Map<ResourceLocation, IFactionRegistry.IMinionEntry<?, ?>> minions = new HashMap();

    public void finish() {
        this.allFactions = this.temp.toArray(new Faction[0]);
        this.temp = null;
        ArrayList<PlayableFaction> temp2 = new ArrayList<PlayableFaction>();
        for (Faction<?> allFaction : this.allFactions) {
            if (!(allFaction instanceof PlayableFaction)) continue;
            temp2.add((PlayableFaction)allFaction);
        }
        this.playableFactions = temp2.toArray(new PlayableFaction[0]);
        this.tempMinions.forEach(p -> {
            if (this.minions.containsKey(p.getLeft())) {
                throw new IllegalStateException("Duplicate minion id " + String.valueOf(p.getLeft()));
            }
            this.minions.put((ResourceLocation)p.getLeft(), (IFactionRegistry.IMinionEntry)p.getRight());
        });
        this.tempMinions = null;
    }

    @Override
    @Nullable
    public IFaction<?> getFaction(Entity entity) {
        if (entity instanceof IFactionEntity) {
            return ((IFactionEntity)entity).getFaction();
        }
        if (entity instanceof Player) {
            return VampirismPlayerAttributes.get((Player)((Player)entity)).faction;
        }
        return null;
    }

    @Override
    @Nullable
    public IFaction<?> getFactionByID(ResourceLocation id) {
        if (this.allFactions == null) {
            return null;
        }
        for (Faction<?> f : this.allFactions) {
            if (!f.getID().equals((Object)id)) continue;
            return f;
        }
        return null;
    }

    public Faction<?>[] getFactions() {
        return this.allFactions;
    }

    public PlayableFaction<?>[] getPlayableFactions() {
        return this.playableFactions;
    }

    @Override
    public Predicate<LivingEntity> getPredicate(@NotNull IFaction<?> thisFaction, boolean ignoreDisguise) {
        return this.getPredicate(thisFaction, true, true, true, ignoreDisguise, null);
    }

    @Override
    public Predicate<LivingEntity> getPredicate(@NotNull IFaction<?> thisFaction, boolean player, boolean mob, boolean neutralPlayer, boolean ignoreDisguise, @Nullable IFaction<?> otherFaction) {
        Object predicate;
        int id;
        int key = 0;
        if (otherFaction != null) {
            id = otherFaction.hashCode();
            if (id > 63) {
                LOGGER.warn("Faction id over 64, predicates won't work");
            }
            key |= (id & 0x3F) << 10;
        }
        if (player) {
            key |= 0x200;
        }
        if (mob) {
            key |= 0x100;
        }
        if (neutralPlayer) {
            key |= 0x80;
        }
        if (ignoreDisguise) {
            key |= 0x40;
        }
        if ((id = thisFaction.hashCode()) > 64) {
            LOGGER.warn("Faction id over 64, predicates won't work");
        }
        if (this.predicateMap.containsKey(key |= id & 0x3F)) {
            predicate = this.predicateMap.get(key);
        } else {
            predicate = new FactionPredicate(thisFaction, player, mob, neutralPlayer, ignoreDisguise, otherFaction);
            this.predicateMap.put(key, (Predicate<LivingEntity>)predicate);
        }
        return predicate;
    }

    private void addFaction(@NotNull Faction<?> faction) {
        if (this.temp == null) {
            throw new IllegalStateException(String.format("[Vampirism]You have to register factions during InterModEnqueueEvent. (%s)", faction.getID()));
        }
        this.temp.add(faction);
    }

    @Override
    @NotNull
    public <T extends IFactionEntity> IFactionBuilder<T> createFaction(ResourceLocation id, Class<T> entityInterface) {
        if (!UtilLib.isNonNull(id, entityInterface)) {
            throw new IllegalArgumentException("[Vampirism] Parameter for faction cannot be null");
        }
        return new FactionBuilder<T>(id, entityInterface);
    }

    @Override
    @NotNull
    public <T extends IFactionPlayer<T>> IPlayableFactionBuilder<T> createPlayableFaction(ResourceLocation id, Class<T> entityInterface, Supplier<AttachmentType<T>> playerCapabilitySupplier) {
        if (!UtilLib.isNonNull(id, entityInterface, playerCapabilitySupplier)) {
            throw new IllegalArgumentException("[Vampirism] Parameters for faction cannot be null");
        }
        return new PlayableFactionBuilder<T>(id, entityInterface, playerCapabilitySupplier);
    }

    private void addMinion(ResourceLocation minionId, MinionEntry<?, ?> data) {
        Objects.requireNonNull(this.tempMinions, () -> String.format("[Vampirism]You have to register minions %s during InterModEnqueueEvent", minionId));
        this.tempMinions.add(Pair.of((Object)minionId, data));
    }

    @Override
    @Nullable
    public IFactionRegistry.IMinionEntry<?, ?> getMinion(ResourceLocation minionId) {
        return this.minions.get(minionId);
    }

    @Override
    @NotNull
    public Collection<IFactionRegistry.IMinionEntry<?, ?>> getMinions() {
        return Collections.unmodifiableCollection(this.minions.values());
    }

    public class FactionBuilder<T extends IFactionEntity>
    implements IFactionBuilder<T> {
        protected final ResourceLocation id;
        protected final Class<T> entityInterface;
        protected int color = Color.WHITE.getRGB();
        protected boolean hostileTowardsNeutral;
        protected final FactionVillageBuilder villageFactionData = new FactionVillageBuilder();
        @Nullable
        protected TextColor chatColor;
        protected String name;
        protected String namePlural;
        protected Map<ResourceKey<? extends Registry<?>>, TagKey<?>> factionTags = new HashMap();

        FactionBuilder(ResourceLocation id, Class<T> entityInterface) {
            this.id = id;
            this.entityInterface = entityInterface;
        }

        @Override
        public IFactionBuilder<T> color(int color) {
            this.color = color;
            return this;
        }

        @Override
        public IFactionBuilder<T> chatColor(TextColor color) {
            this.chatColor = color;
            return this;
        }

        @Override
        public IFactionBuilder<T> chatColor(@NotNull ChatFormatting color) {
            if (!color.isColor()) {
                throw new IllegalArgumentException("Parameter must be a color");
            }
            this.chatColor = TextColor.fromLegacyFormat((ChatFormatting)color);
            return this;
        }

        @Override
        public IFactionBuilder<T> hostileTowardsNeutral() {
            this.hostileTowardsNeutral = true;
            return this;
        }

        @Override
        public IFactionBuilder<T> village(@NotNull Consumer<IFactionVillageBuilder> villageBuilder) {
            villageBuilder.accept(this.villageFactionData);
            return this;
        }

        @Override
        public IFactionBuilder<T> name(@NotNull String nameKey) {
            this.name = nameKey;
            return this;
        }

        @Override
        public IFactionBuilder<T> namePlural(@NotNull String namePluralKey) {
            this.namePlural = namePluralKey;
            return this;
        }

        @Override
        @NotNull
        public IFaction<T> register() {
            Faction faction = new Faction(this);
            FactionRegistry.this.addFaction(faction);
            return faction;
        }

        @Override
        public <Z> IFactionBuilder<T> addTag(ResourceKey<? extends Registry<Z>> registryKey, TagKey<Z> tag) {
            this.factionTags.put(registryKey, tag);
            return this;
        }
    }

    public class PlayableFactionBuilder<T extends IFactionPlayer<T>>
    extends FactionBuilder<T>
    implements IPlayableFactionBuilder<T> {
        protected final Supplier<AttachmentType<T>> playerCapabilitySupplier;
        protected int highestLevel;
        protected Function<IRefinementItem.AccessorySlotType, IRefinementItem> refinementItemBySlot;
        protected LordPlayerBuilder<T> lord;

        public PlayableFactionBuilder(ResourceLocation id, Class<T> entityInterface, Supplier<AttachmentType<T>> playerCapabilitySupplier) {
            super(id, entityInterface);
            this.highestLevel = 1;
            this.lord = new LordPlayerBuilder(this);
            this.playerCapabilitySupplier = playerCapabilitySupplier;
        }

        @Override
        public IPlayableFactionBuilder<T> color(int color) {
            return (IPlayableFactionBuilder)super.color(color);
        }

        @Override
        public IPlayableFactionBuilder<T> hostileTowardsNeutral() {
            return (IPlayableFactionBuilder)super.hostileTowardsNeutral();
        }

        @Override
        @NotNull
        public IPlayableFactionBuilder<T> highestLevel(int highestLevel) {
            this.highestLevel = highestLevel;
            return this;
        }

        @Override
        public IPlayableFactionBuilder<T> village(@NotNull Consumer<IFactionVillageBuilder> villageBuilder) {
            return (IPlayableFactionBuilder)super.village(villageBuilder);
        }

        @Override
        @NotNull
        public IPlayableFactionBuilder<T> refinementItems(@NotNull Function<IRefinementItem.AccessorySlotType, IRefinementItem> refinementItemBySlot) {
            this.refinementItemBySlot = refinementItemBySlot;
            return this;
        }

        @Override
        public IPlayableFactionBuilder<T> chatColor(@NotNull TextColor color) {
            return (IPlayableFactionBuilder)super.chatColor(color);
        }

        @Override
        public IPlayableFactionBuilder<T> chatColor(@NotNull ChatFormatting color) {
            return (IPlayableFactionBuilder)super.chatColor(color);
        }

        @Override
        public IPlayableFactionBuilder<T> name(@NotNull String nameKey) {
            return (IPlayableFactionBuilder)super.name(nameKey);
        }

        @Override
        public IPlayableFactionBuilder<T> namePlural(@NotNull String namePluralKey) {
            return (IPlayableFactionBuilder)super.namePlural(namePluralKey);
        }

        @Override
        @NotNull
        public ILordPlayerBuilder<T> lord() {
            return this.lord;
        }

        @Override
        public <Z> IPlayableFactionBuilder<T> addTag(ResourceKey<? extends Registry<Z>> registryKey, TagKey<Z> tag) {
            return (IPlayableFactionBuilder)super.addTag(registryKey, tag);
        }

        @Override
        @NotNull
        public IPlayableFaction<T> register() {
            PlayableFaction faction = new PlayableFaction(this);
            FactionRegistry.this.addFaction(faction);
            this.lord.minions.forEach(builder -> FactionRegistry.this.addMinion(builder.minionId, new MinionEntry(faction, builder)));
            return faction;
        }
    }

    public static class LordPlayerBuilder<T extends IFactionPlayer<T>>
    implements ILordPlayerBuilder<T> {
        protected final PlayableFactionBuilder<T> factionBuilder;
        protected int maxLevel = 0;
        protected BiFunction<Integer, IPlayableFaction.TitleGender, Component> lordTitleFunction = (a, b) -> Component.literal((String)("Lord " + a));
        protected boolean lordSkillsEnabled;
        protected List<MinionBuilder<T, ?>> minions = new ArrayList();

        public LordPlayerBuilder(PlayableFactionBuilder<T> factionBuilder) {
            this.factionBuilder = factionBuilder;
        }

        @Override
        @NotNull
        public LordPlayerBuilder<T> lordLevel(int level) {
            this.maxLevel = level;
            return this;
        }

        @Override
        @NotNull
        public LordPlayerBuilder<T> lordTitle(@NotNull BiFunction<Integer, IPlayableFaction.TitleGender, Component> lordTitleFunction) {
            this.lordTitleFunction = lordTitleFunction;
            return this;
        }

        @Override
        @NotNull
        public ILordPlayerBuilder<T> enableLordSkills() {
            this.lordSkillsEnabled = true;
            return this;
        }

        public ILordPlayerBuilder<T> registerMinion(@NotNull MinionBuilder<T, ?> builder) {
            this.minions.add(builder);
            return this;
        }

        @Override
        public <Z extends IMinionData> IMinionBuilder<T, Z> minion(ResourceLocation minionId, Supplier<Z> data) {
            return new MinionBuilder(this, minionId, data);
        }

        @Override
        public IPlayableFactionBuilder<T> build() {
            return this.factionBuilder;
        }

        public static class MinionBuilder<T extends IFactionPlayer<T>, Z extends IMinionData>
        implements IMinionBuilder<T, Z> {
            protected final LordPlayerBuilder<T> builder;
            protected final ResourceLocation minionId;
            protected final Supplier<Z> data;
            protected MinionCommandBuilder<T, Z> commandBuilder;

            public MinionBuilder(LordPlayerBuilder<T> builder, ResourceLocation minionId, @NotNull Supplier<Z> data) {
                this.builder = builder;
                this.minionId = minionId;
                this.data = data;
            }

            @Override
            public MinionCommandBuilder<T, Z> commandBuilder(@NotNull Supplier<EntityType<? extends IMinionEntity>> type) {
                return new MinionCommandBuilder(this, type);
            }

            @Override
            public ILordPlayerBuilder<T> build() {
                return this.builder.registerMinion(this);
            }

            private IMinionBuilder<T, Z> registerCommand(MinionCommandBuilder<T, Z> commandBuilder) {
                this.commandBuilder = commandBuilder;
                return this;
            }

            public static class MinionCommandBuilder<T extends IFactionPlayer<T>, Z extends IMinionData>
            implements IMinionBuilder.IMinionCommandBuilder<T, Z> {
                protected final MinionBuilder<T, Z> minionBuilder;
                protected final Supplier<EntityType<? extends IMinionEntity>> type;
                protected final List<IMinionBuilder.IMinionCommandBuilder.ICommandEntry<Z, ?>> commandArguments = new ArrayList();

                public MinionCommandBuilder(MinionBuilder<T, Z> minionBuilder, @NotNull Supplier<EntityType<? extends IMinionEntity>> type) {
                    this.minionBuilder = minionBuilder;
                    this.type = type;
                }

                @Override
                public <L> IMinionBuilder.IMinionCommandBuilder<T, Z> with(@NotNull String name, L defaultValue, @NotNull ArgumentType<L> type, BiConsumer<Z, L> setter, BiFunction<CommandContext<CommandSourceStack>, String, L> getter) {
                    this.commandArguments.add(new CommandEntry<Z, L>(name, defaultValue, type, setter, getter));
                    return this;
                }

                @Override
                public IMinionBuilder<T, Z> build() {
                    return this.minionBuilder.registerCommand(this);
                }

                public record CommandEntry<Z extends IMinionData, T>(String name, T defaultValue, ArgumentType<T> type, BiConsumer<Z, T> setter, BiFunction<CommandContext<CommandSourceStack>, String, T> getter) implements IMinionBuilder.IMinionCommandBuilder.ICommandEntry<Z, T>
                {
                }
            }
        }
    }

    public static final class MinionEntry<T extends IFactionPlayer<T>, Z extends IMinionData>
    extends Record
    implements IFactionRegistry.IMinionEntry<T, Z> {
        private final PlayableFaction<T> faction;
        private final ResourceLocation id;
        private final Supplier<Z> data;
        private final Supplier<EntityType<? extends IMinionEntity>> type;
        private final List<IMinionBuilder.IMinionCommandBuilder.ICommandEntry<Z, ?>> commandArguments;

        public MinionEntry(PlayableFaction<T> faction, LordPlayerBuilder.MinionBuilder<T, Z> builder) {
            this(faction, builder.minionId, builder.data, builder.commandBuilder.type, builder.commandBuilder.commandArguments);
        }

        public MinionEntry(PlayableFaction<T> faction, ResourceLocation id, Supplier<Z> data, Supplier<EntityType<? extends IMinionEntity>> type, List<IMinionBuilder.IMinionCommandBuilder.ICommandEntry<Z, ?>> commandArguments) {
            this.faction = faction;
            this.id = id;
            this.data = data;
            this.type = type;
            this.commandArguments = commandArguments;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{MinionEntry.class, "faction;id;data;type;commandArguments", "faction", "id", "data", "type", "commandArguments"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MinionEntry.class, "faction;id;data;type;commandArguments", "faction", "id", "data", "type", "commandArguments"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MinionEntry.class, "faction;id;data;type;commandArguments", "faction", "id", "data", "type", "commandArguments"}, this, o);
        }

        @Override
        public PlayableFaction<T> faction() {
            return this.faction;
        }

        @Override
        public ResourceLocation id() {
            return this.id;
        }

        @Override
        public Supplier<Z> data() {
            return this.data;
        }

        @Override
        public Supplier<EntityType<? extends IMinionEntity>> type() {
            return this.type;
        }

        @Override
        public List<IMinionBuilder.IMinionCommandBuilder.ICommandEntry<Z, ?>> commandArguments() {
            return this.commandArguments;
        }
    }
}

