/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.IDefaultTaskMasterEntity;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.ai.goals.ForceLookEntityGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.inventory.TaskBoardMenu;
import de.teamlapen.vampirism.items.HunterHatItem;
import de.teamlapen.vampirism.util.Helper;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunterTaskMasterEntity
extends HunterBaseEntity
implements IDefaultTaskMasterEntity {
    private static final EntityDataAccessor<String> BIOME_TYPE = SynchedEntityData.defineId(HunterTaskMasterEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    @Nullable
    private Player interactor;

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampirismEntity.getAttributeBuilder().add(Attributes.MAX_HEALTH, (double)BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder.add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MOVEMENT_SPEED, BalanceMobProps.mobProps.VAMPIRE_HUNTER_SPEED);
    }

    public HunterTaskMasterEntity(EntityType<? extends HunterBaseEntity> type, Level world) {
        super(type, world, false);
        this.peaceful = true;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!(this.interactor == null || this.interactor.isAlive() && this.interactor.containerMenu instanceof TaskBoardMenu)) {
            this.interactor = null;
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData data = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        this.setBiomeType(VillagerType.byBiome((Holder)worldIn.getBiome(this.blockPosition())));
        this.setItemSlot(EquipmentSlot.HEAD, ((HunterHatItem)ModItems.HUNTER_HAT_HEAD_0.get()).getDefaultInstance());
        return data;
    }

    @Override
    @NotNull
    public VillagerType getBiomeType() {
        String key = (String)this.entityData.get(BIOME_TYPE);
        ResourceLocation id = ResourceLocation.parse((String)key);
        return (VillagerType)BuiltInRegistries.VILLAGER_TYPE.get(id);
    }

    protected void setBiomeType(@NotNull VillagerType type) {
        this.entityData.set(BIOME_TYPE, (Object)BuiltInRegistries.VILLAGER_TYPE.getKey((Object)type).toString());
    }

    @Override
    @NotNull
    public Optional<Player> getForceLookTarget() {
        return Optional.ofNullable(this.interactor);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BIOME_TYPE, (Object)BuiltInRegistries.VILLAGER_TYPE.getDefaultKey().toString());
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player playerEntity, @NotNull InteractionHand hand) {
        if (this.level().isClientSide) {
            return Helper.isHunter(playerEntity) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (Helper.isHunter(playerEntity) && this.interactor == null && this.processInteraction(playerEntity, (Entity)this)) {
            this.getNavigation().stop();
            this.interactor = playerEntity;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(2, new ForceLookEntityGoal<HunterTaskMasterEntity>(this));
        this.goalSelector.addGoal(5, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, (double)0.7f, false, 300, () -> false));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 13.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, VampireBaseEntity.class, 17.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }
}

