/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion;

import com.mojang.authlib.GameProfile;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.storage.ISyncable;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.minion.IMinionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionInventory;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.ILordPlayer;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.ai.goals.ForceLookEntityGoal;
import de.teamlapen.vampirism.entity.ai.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.goals.DefendAreaGoal;
import de.teamlapen.vampirism.entity.minion.goals.DefendLordGoal;
import de.teamlapen.vampirism.entity.minion.goals.FollowLordGoal;
import de.teamlapen.vampirism.entity.minion.goals.MoveToTaskCenterGoal;
import de.teamlapen.vampirism.entity.minion.management.MinionDamageSource;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.inventory.MinionContainer;
import de.teamlapen.vampirism.util.IPlayerOverlay;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.util.PlayerModelType;
import de.teamlapen.vampirism.world.LevelDamage;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MinionEntity<T extends MinionData>
extends VampirismEntity
implements IPlayerOverlay,
ISyncable,
ForceLookEntityGoal.TaskOwner,
IMinionEntity,
IEntityWithComplexSpawn {
    private static final String NBT_KEY = "minion_data";
    protected static final EntityDataAccessor<Optional<UUID>> LORD_ID = SynchedEntityData.defineId(MinionEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final Logger LOGGER = LogManager.getLogger();
    private static final NonNullList<ItemStack> EMPTY_LIST = NonNullList.create();
    private static final int CONVERT_DURATION = 20;
    @NotNull
    private final Predicate<LivingEntity> hardAttackPredicate;
    @NotNull
    private final Predicate<LivingEntity> softAttackPredicate;
    @Nullable
    protected PlayerMinionController playerMinionController;
    @Nullable
    protected T minionData;
    @Nullable
    private Pair<ResourceLocation, PlayerModelType> skinDetails;
    @Nullable
    private Optional<GameProfile> skinProfile;
    private int minionId;
    private int token;
    private int convertCounter;
    @Nullable
    private Player interactingPlayer;

    protected MinionEntity(EntityType<? extends VampirismEntity> type, Level world, @NotNull Predicate<LivingEntity> attackPredicate) {
        super(type, world);
        this.softAttackPredicate = attackPredicate;
        this.hardAttackPredicate = this::lambda$new$4;
        this.setDontDropEquipment();
        this.peaceful = true;
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        this.getLordID().ifPresent(id -> nbt.putUUID("lord", id));
        nbt.putInt("minion_id", this.minionId);
        nbt.putInt("minion_token", this.token);
    }

    @Override
    public String nbtKey() {
        return NBT_KEY;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.isAlive()) {
            if (this.random.nextInt(900) == 0 && this.deathTime == 0) {
                this.heal(1.0f);
            }
            if (this.tickCount % 20 == 0) {
                this.consumeOffhand();
            }
        }
        if (this.convertCounter > 0) {
            --this.convertCounter;
        }
        if (!this.level().isClientSide && !this.isValid() && this.isAlive()) {
            LOGGER.warn("Minion without lord.");
            this.discard();
        }
    }

    public void changeMinionName(String name) {
        if (this.minionData != null) {
            ((MinionData)this.minionData).setName(name);
            super.setCustomName((Component)((MinionData)this.minionData).getFormattedName());
        }
    }

    public void claimMinionSlot(int id, @NotNull PlayerMinionController controller) {
        assert (this.minionId == 0);
        controller.claimMinionSlot(id).ifPresent(token -> {
            this.playerMinionController = controller;
            this.minionId = id;
            this.token = token;
            this.getEntityData().set(LORD_ID, Optional.of(this.playerMinionController.getUUID()));
        });
    }

    public void die(@NotNull DamageSource cause) {
        super.die(cause);
        if (this.playerMinionController != null) {
            this.getLordOpt().map(ILordPlayer::getPlayer).ifPresent(p -> p.displayClientMessage((Component)Component.translatable((String)"text.vampirism.minion.died", (Object[])new Object[]{this.getDisplayName()}), true));
            this.playerMinionController.markDeadAndReleaseMinionSlot(this.minionId, this.token);
            this.playerMinionController = null;
        }
    }

    public boolean doHurtTarget(Entity pEntity) {
        boolean flag;
        float f = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        MinionDamageSource damagesource = LevelDamage.get(this.level()).minion(this);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            f = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)pEntity, (DamageSource)damagesource, (float)f);
        }
        if (flag = pEntity.hurt((DamageSource)damagesource, f)) {
            Level level2;
            float f1 = this.getKnockback(pEntity, damagesource);
            if (f1 > 0.0f && pEntity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)pEntity;
                livingentity.knockback((double)(f1 * 0.5f), (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if ((level2 = this.level()) instanceof ServerLevel) {
                ServerLevel serverlevel1 = (ServerLevel)level2;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel1, (Entity)pEntity, (DamageSource)damagesource);
            }
            this.setLastHurtMob(pEntity);
            this.playAttackSound();
        }
        return flag;
    }

    @NotNull
    public ItemStack eat(@NotNull Level world, @NotNull ItemStack stack, @NotNull FoodProperties properties) {
        float healAmount = (float)properties.nutrition() / 2.0f;
        this.heal(healAmount);
        return super.eat(world, stack, properties);
    }

    public Predicate<LivingEntity> getAttackPredicate(boolean onlyShould) {
        return onlyShould ? this.hardAttackPredicate.and(this.softAttackPredicate) : this.hardAttackPredicate;
    }

    public abstract List<IMinionTask<?, ?>> getAvailableTasks();

    @Override
    @NotNull
    public Optional<IMinionTask.IMinionTaskDesc<?>> getCurrentTask() {
        return this.minionData != null ? Optional.of(((MinionData)this.minionData).getCurrentTaskDesc()) : Optional.empty();
    }

    @Override
    @NotNull
    public Optional<Player> getForceLookTarget() {
        return Optional.ofNullable(this.interactingPlayer);
    }

    @Override
    @NotNull
    public Optional<IMinionInventory> getInventory() {
        if (this.minionData != null) {
            return Optional.of(((MinionData)this.minionData).getInventory());
        }
        return Optional.empty();
    }

    @NotNull
    public Iterable<ItemStack> getArmorSlots() {
        return (Iterable)this.getInventory().map(IMinionInventory::getInventoryArmor).orElse(EMPTY_LIST);
    }

    @Override
    @NotNull
    public Optional<ILordPlayer> getLordOpt() {
        return Optional.ofNullable(this.getLord());
    }

    @NotNull
    public Optional<T> getMinionData() {
        return Optional.ofNullable(this.minionData);
    }

    @Override
    @NotNull
    public Optional<Integer> getMinionId() {
        return this.minionData == null ? Optional.empty() : Optional.of(this.minionId);
    }

    @Override
    @NotNull
    public Optional<Pair<ResourceLocation, PlayerModelType>> getOverlayPlayerProperties() {
        if (this.skinDetails == null) {
            this.getLordID().ifPresent(id -> VampirismMod.proxy.obtainPlayerSkins(new GameProfile(id, "Dummy"), p -> {
                this.skinDetails = p;
            }));
            this.skinDetails = PENDING_PROP;
        }
        return Optional.of(this.skinDetails);
    }

    @Override
    @NotNull
    public Optional<GameProfile> getPlayerOverlay() {
        if (this.skinProfile == null) {
            this.skinProfile = Optional.empty();
            this.getLordID().ifPresent(id -> SkullBlockEntity.fetchGameProfile((String)"cheaterpaul").thenAccept(p -> {
                this.skinProfile = p;
            }));
        }
        return this.skinProfile;
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    public float getScale() {
        return 0.8f + (float)this.convertCounter / 20.0f * 0.2f;
    }

    @NotNull
    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(this.getScale());
    }

    public boolean isTaskLocked() {
        return this.minionData != null && ((MinionData)this.minionData).isTaskLocked();
    }

    @NotNull
    public Iterable<ItemStack> getHandSlots() {
        return (Iterable)this.getInventory().map(IMinionInventory::getInventoryHands).orElse(EMPTY_LIST);
    }

    @Override
    public void deserializeUpdateNBT(HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        block5: {
            if (nbt.contains("data_type", 8)) {
                try {
                    @Nullable T data = MinionData.fromNBT(provider, nbt);
                    if (data == null) {
                        LOGGER.warn("Failed to find correct minion data");
                        break block5;
                    }
                    Object cast = data;
                    this.minionData = cast;
                    this.onMinionDataReceived(provider, cast);
                    this.minionId = nbt.getInt("minion_id");
                    super.setCustomName((Component)((MinionData)data).getFormattedName());
                }
                catch (ClassCastException e) {
                    LOGGER.error("Failed to cast minion data. Maybe the correct data was not registered", (Throwable)e);
                }
            } else {
                LOGGER.warn("Received empty minion data");
            }
        }
    }

    public void markAsConverted() {
        this.convertCounter = 20;
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        this.checkoutMinionData((HolderLookup.Provider)this.level().registryAccess());
    }

    public void onRemovedFromLevel() {
        if (this.playerMinionController != null) {
            this.playerMinionController.checkInMinion(this.minionId, this.token);
            ((MinionData)this.minionData).updateEntityCaps(this.serializeMinionCaps((HolderLookup.Provider)this.level().registryAccess()));
            this.minionData = null;
            this.playerMinionController = null;
        }
        super.onRemovedFromLevel();
    }

    @NotNull
    public ItemStack getItemBySlot(@NotNull EquipmentSlot slotIn) {
        return switch (slotIn.getType()) {
            case EquipmentSlot.Type.HAND -> this.getInventory().map(IMinionInventory::getInventoryHands).map(i -> (ItemStack)i.get(slotIn.getIndex())).orElse(ItemStack.EMPTY);
            case EquipmentSlot.Type.HUMANOID_ARMOR -> this.getInventory().map(IMinionInventory::getInventoryArmor).map(i -> (ItemStack)i.get(slotIn.getIndex())).orElse(ItemStack.EMPTY);
            default -> ItemStack.EMPTY;
        };
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        UUID id;
        super.readAdditionalSaveData(nbt);
        UUID uUID = id = nbt.hasUUID("lord") ? nbt.getUUID("lord") : null;
        if (id != null && this.level() instanceof ServerLevel) {
            this.playerMinionController = MinionWorldData.getData((ServerLevel)this.level()).getController(id);
            if (this.playerMinionController == null) {
                LOGGER.warn("Cannot get PlayerMinionController for {}", (Object)id);
            } else {
                this.minionId = nbt.getInt("minion_id");
                this.token = nbt.getInt("minion_token");
                this.getEntityData().set(LORD_ID, Optional.of(id));
            }
        }
    }

    public void onTaskChanged() {
        HelperLib.sync(this);
    }

    public void openAppearanceScreen() {
    }

    public void openStatsScreen() {
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    @Deprecated
    public void recallMinion() {
        this.discard();
    }

    public void setItemSlot(@NotNull EquipmentSlot slotIn, @NotNull ItemStack stack) {
        if (this.minionData == null) {
            return;
        }
        switch (slotIn.getType()) {
            case HAND: {
                this.getInventory().map(IMinionInventory::getInventoryHands).ifPresent(i -> i.set(slotIn.getIndex(), (Object)stack));
                break;
            }
            case HUMANOID_ARMOR: {
                this.getInventory().map(IMinionInventory::getInventoryArmor).ifPresent(i -> i.set(slotIn.getIndex(), (Object)stack));
            }
        }
    }

    @NotNull
    public Predicate<ItemStack> getEquipmentPredicate(EquipmentSlot slotType) {
        return itemStack -> !(itemStack.getItem() instanceof IFactionExclusiveItem) || this.getFaction().equals(((IFactionExclusiveItem)itemStack.getItem()).getExclusiveFaction((ItemStack)itemStack));
    }

    public void setCustomName(@Nullable Component name) {
    }

    public void setHealth(float health) {
        super.setHealth(health);
        if (this.minionData != null) {
            ((MinionData)this.minionData).setHealth(health);
        }
    }

    public void setInteractingPlayer(@Nullable Player player) {
        this.interactingPlayer = player;
    }

    public void setTarget(@Nullable LivingEntity entitylivingbaseIn) {
        if (entitylivingbaseIn == null || this.hardAttackPredicate.test(entitylivingbaseIn)) {
            super.setTarget(entitylivingbaseIn);
        }
    }

    public abstract boolean shouldRenderLordSkin();

    public boolean shouldShowName() {
        return true;
    }

    @Override
    @NotNull
    public CompoundTag serializeUpdateNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (this.minionData == null && this.level().getEntity(this.getId()) != null) {
            this.checkoutMinionData(provider);
        }
        if (this.minionData != null) {
            ((MinionData)this.minionData).serializeNBT(tag, provider);
            tag.putInt("minion_id", this.minionId);
        }
        return tag;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeVarInt(this.convertCounter);
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.convertCounter = additionalData.readVarInt();
    }

    protected boolean canConsume(@NotNull ItemStack stack) {
        if (stack.getUseAnimation() != UseAnim.DRINK && stack.getUseAnimation() != UseAnim.EAT) {
            return false;
        }
        return !stack.isEmpty();
    }

    protected void consumeOffhand() {
        if (this.isUsingItem()) {
            return;
        }
        if (this.targetSelector.getAvailableGoals().stream().anyMatch(WrappedGoal::isRunning)) {
            return;
        }
        ItemStack stack = this.getInventory().map(i -> i.getItem(1)).orElse(ItemStack.EMPTY);
        if (!this.canConsume(stack)) {
            return;
        }
        this.startUsingItem(InteractionHand.OFF_HAND);
        this.setYRot(this.getYHeadRot());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LORD_ID, Optional.empty());
    }

    @Nullable
    protected ILordPlayer getLord() {
        return this.getLordID().map(arg_0 -> ((Level)this.level()).getPlayerByUUID(arg_0)).filter(LivingEntity::isAlive).map(FactionPlayerHandler::get).orElse(null);
    }

    @NotNull
    protected Optional<UUID> getLordID() {
        return (Optional)this.getEntityData().get(LORD_ID);
    }

    protected void hurtArmor(@NotNull DamageSource damageSource, float damage) {
        this.doHurtEquipment(damageSource, damage, new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD});
    }

    protected boolean isLord(@NotNull Player p) {
        return this.getLordID().map(id -> id.equals(p.getUUID())).orElse(false);
    }

    protected boolean isValid() {
        return this.playerMinionController != null;
    }

    protected void onMinionDataReceived(HolderLookup.Provider provider, @NotNull T data) {
        this.deserializeAttachments(provider, ((MinionData)data).getEntityCaps());
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.isLord(player)) {
            if (player instanceof ServerPlayer) {
                player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerIn) -> MinionContainer.create(id, playerInventory, this, this.getLord()), (Component)Component.translatable((String)"text.vampirism.name").append((Component)this.getMinionData().map(MinionData::getFormattedName).orElse(Component.literal((String)"Minion")))), buf -> buf.writeVarInt(this.getId()));
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, new ForceLookEntityGoal<MinionEntity>(this));
        this.goalSelector.addGoal(2, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(4, (Goal)new FollowLordGoal(this, 1.1));
        this.goalSelector.addGoal(9, (Goal)new MoveToTaskCenterGoal(this));
        this.goalSelector.addGoal(10, (Goal)new LookAtClosestVisibleGoal((Mob)this, Player.class, 20.0f, 0.6f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                return super.canUse() && MinionEntity.this.getCurrentTask().filter(t -> t.getTask() == MinionTasks.STAY.get()).isEmpty();
            }
        });
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new DefendAreaGoal(this));
        this.targetSelector.addGoal(2, (Goal)new DefendLordGoal(this));
    }

    private void checkoutMinionData(HolderLookup.Provider provider) {
        if (this.playerMinionController != null && this.minionData == null) {
            this.minionData = this.playerMinionController.checkoutMinion(this.minionId, this.token, this);
            if (this.minionData == null) {
                this.playerMinionController = null;
            } else {
                this.handleLoadedMinionData(provider, this.minionData);
            }
        }
    }

    public final void handleLoadedMinionData(HolderLookup.Provider provider, @NotNull T data) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)((MinionData)data).getMaxHealth());
        super.setHealth(((MinionData)data).getHealth());
        super.setCustomName((Component)((MinionData)data).getFormattedName());
        try {
            this.onMinionDataReceived(provider, data);
        }
        catch (ClassCastException e) {
            LOGGER.error("Failed to cast minion data. Maybe the correct data was not registered", (Throwable)e);
            this.discard();
        }
    }

    protected CompoundTag serializeMinionCaps(HolderLookup.Provider provider) {
        Collection<String> allowedCapTags = this.getAllowedCapTags();
        CompoundTag tag = this.serializeAttachments(provider);
        if (tag != null) {
            tag.getAllKeys().removeIf(s -> !allowedCapTags.contains(s));
            return tag;
        }
        return new CompoundTag();
    }

    protected Collection<String> getAllowedCapTags() {
        return Collections.singleton(VResourceLocation.loc("armourers_workshop", "entity-skin-provider").toString());
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ boolean lambda$new$4(LivingEntity livingEntity) {
        flag1 = this.getLordOpt().map((Function<ILordPlayer, Player>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPlayer(), (Lde/teamlapen/vampirism/api/entity/player/ILordPlayer;)Lnet/minecraft/world/entity/player/Player;)()).filter((Predicate<Player>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$0(net.minecraft.world.entity.LivingEntity net.minecraft.world.entity.player.Player ), (Lnet/minecraft/world/entity/player/Player;)Z)((LivingEntity)livingEntity)).isPresent();
        v0 = flag2 = livingEntity instanceof MinionEntity != false && ((MinionEntity)livingEntity).getLordID().filter((Predicate<UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$2(java.util.UUID ), (Ljava/util/UUID;)Z)((MinionEntity)this)).isPresent() != false;
        if (!(livingEntity instanceof Player)) ** GOTO lbl-1000
        otherPlayer = (Player)livingEntity;
        if (this.getLordOpt().map((Function<ILordPlayer, Player>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPlayer(), (Lde/teamlapen/vampirism/api/entity/player/ILordPlayer;)Lnet/minecraft/world/entity/player/Player;)()).map((Function<Player, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$3(net.minecraft.world.entity.player.Player net.minecraft.world.entity.player.Player ), (Lnet/minecraft/world/entity/player/Player;)Ljava/lang/Boolean;)((Player)otherPlayer)).orElse(Permissions.isPvpEnabled(otherPlayer) == false).booleanValue()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        flag3 = v1;
        return flag1 == false && flag2 == false && flag3 == false;
    }

    private static /* synthetic */ Boolean lambda$new$3(Player otherPlayer, Player player) {
        return !player.canHarmPlayer(otherPlayer);
    }

    private /* synthetic */ boolean lambda$new$2(UUID id) {
        return this.getLordID().map(id2 -> id == id2).orElse(false);
    }

    private static /* synthetic */ boolean lambda$new$0(LivingEntity livingEntity, Player entity) {
        return entity == livingEntity;
    }
}

