/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.goals;

import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.DefendAreaTask;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class DefendAreaGoal
extends TargetGoal {
    @NotNull
    private final MinionEntity<?> entity;
    @NotNull
    private final TargetingConditions predicate;
    private AABB bb;
    private BlockPos center;

    public DefendAreaGoal(@NotNull MinionEntity<?> entity) {
        super(entity, false);
        this.entity = entity;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        this.predicate = TargetingConditions.forCombat().selector(e -> entity.getAttackPredicate(true).test((LivingEntity)e)).ignoreInvisibilityTesting().range(60.0);
    }

    public boolean canContinueToUse() {
        return this.entity.getCurrentTask().filter(task -> task.getTask() == MinionTasks.DEFEND_AREA.get()).isPresent() && super.canContinueToUse();
    }

    public boolean canUse() {
        return this.entity.getCurrentTask().filter(task -> task.getTask() == MinionTasks.DEFEND_AREA.get() && ((DefendAreaTask.Desc)task).center != null).map(task -> {
            BlockPos newCenter = ((DefendAreaTask.Desc)task).center;
            if (this.bb == null || this.center == null || !this.center.equals((Object)newCenter)) {
                this.bb = new AABB(newCenter).inflate((double)((DefendAreaTask.Desc)task).distance);
                this.center = newCenter;
            }
            this.targetMob = this.entity.level().getNearestEntity(LivingEntity.class, this.predicate, this.entity, this.entity.getX(), this.entity.getY(), this.entity.getZ(), this.bb);
            return this.targetMob != null;
        }).orElse(false);
    }

    public void start() {
        super.start();
        this.entity.setTarget(this.targetMob);
    }
}

