/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.goals;

import de.teamlapen.vampirism.entity.ai.goals.MoveToPositionGoal;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.DefendAreaTask;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.minion.management.StayTask;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveToTaskCenterGoal
extends MoveToPositionGoal<MinionEntity<?>> {
    @Nullable
    private BlockPos target;

    public MoveToTaskCenterGoal(@NotNull MinionEntity<?> entity) {
        super(entity, 1.0, 1.0f, 10.0f, true, false);
    }

    @NotNull
    public Optional<BlockPos> getTargetPos() {
        return ((MinionEntity)this.entity).getCurrentTask().map(desc -> {
            if (desc.getTask() == MinionTasks.DEFEND_AREA.get()) {
                return ((DefendAreaTask.Desc)desc).center;
            }
            if (desc.getTask() == MinionTasks.STAY.get()) {
                return ((StayTask.Desc)desc).position;
            }
            return null;
        });
    }

    @Override
    public boolean canUse() {
        return this.getTargetPos().map(t -> {
            this.target = t;
            return true;
        }).orElse(false) != false && super.canUse();
    }

    @Override
    public void stop() {
        super.stop();
        this.target = null;
    }

    @Override
    @NotNull
    protected Vec3 getLookPosition() {
        return Vec3.ZERO;
    }

    @Override
    protected Vec3i getTargetPosition() {
        return this.target;
    }
}

