/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.skills;

import de.teamlapen.lib.lib.storage.ISyncableSaveData;
import de.teamlapen.vampirism.advancements.critereon.SkillUnlockedCriterionTrigger;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.factions.ISkillNode;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillPointProvider;
import de.teamlapen.vampirism.api.entity.player.skills.SkillPointProviders;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.data.ISkillTreeData;
import de.teamlapen.vampirism.entity.player.skills.SkillTreeConfiguration;
import de.teamlapen.vampirism.mixin.accessor.AttributeInstanceAccessor;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.StatType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkillHandler<T extends IFactionPlayer<T>>
implements ISkillHandler<T>,
ISyncableSaveData {
    private static final String NBT_KEY = "skill_handler";
    private static final Logger LOGGER = LogManager.getLogger(SkillHandler.class);
    private final ArrayList<ISkill<T>> enabledSkills = new ArrayList();
    private final T player;
    private final IPlayableFaction<T> faction;
    private final NonNullList<ItemStack> refinementItems = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    private final Set<IRefinement> activeRefinements = new HashSet<IRefinement>();
    private final Map<ResourceLocation, AttributeModifier> refinementModifier = new HashMap<ResourceLocation, AttributeModifier>();
    private final ISkillPointProvider skillPoints = new SkillPoints();
    public LinkedHashSet<Holder<ISkillTree>> unlockedTrees = new LinkedHashSet();
    private boolean dirty = false;
    private final ISkillTreeData treeData;

    public SkillHandler(T player, IPlayableFaction<T> faction) {
        this.player = player;
        this.faction = faction;
        this.treeData = ISkillTreeData.getData(player.asEntity().level());
    }

    @NotNull
    public Optional<ISkillNode> anyLastNode() {
        return this.unlockedTrees.stream().flatMap(s -> this.treeData.getAnyLastNode((Holder<ISkillTree>)s, this::isNodeEnabled).stream()).findAny();
    }

    public ISkillTreeData getTreeData() {
        return this.treeData;
    }

    @Override
    @NotNull
    public ISkillHandler.Result canSkillBeEnabled(@NotNull ISkill<T> skill) {
        if (this.player.asEntity().getEffect(ModEffects.OBLIVION) != null) {
            return ISkillHandler.Result.LOCKED_BY_PLAYER_STATE;
        }
        if (this.isSkillEnabled(skill)) {
            return ISkillHandler.Result.ALREADY_ENABLED;
        }
        Optional node = this.unlockedTrees.stream().flatMap(x -> this.treeData.getNodeForSkill(this.unlockedTrees, skill).stream()).findFirst();
        if (node.isPresent()) {
            if (this.isSkillNodeLocked((ISkillNode)((SkillTreeConfiguration.SkillTreeNodeConfiguration)node.get()).node().value())) {
                return ISkillHandler.Result.LOCKED_BY_OTHER_NODE;
            }
            if (this.treeData.isRoot(this.unlockedTrees, (SkillTreeConfiguration.SkillTreeNodeConfiguration)node.get()) || this.treeData.getParent((SkillTreeConfiguration.SkillTreeNodeConfiguration)node.get()).stream().anyMatch(x -> this.isNodeEnabled((ISkillNode)x.value()))) {
                if (this.getLeftSkillPoints() >= skill.getSkillPointCost()) {
                    return this.isNodeEnabled((ISkillNode)((SkillTreeConfiguration.SkillTreeNodeConfiguration)node.get()).node().value()) ? ISkillHandler.Result.OTHER_NODE_SKILL : ISkillHandler.Result.OK;
                }
                return ISkillHandler.Result.NO_POINTS;
            }
            return ISkillHandler.Result.PARENT_NOT_ENABLED;
        }
        LOGGER.warn("Node for skill {} could not be found", skill);
        return ISkillHandler.Result.NOT_FOUND;
    }

    @Override
    public ItemStack @NotNull [] createRefinementItems() {
        return (ItemStack[])this.refinementItems.toArray(ItemStack[]::new);
    }

    @Override
    public NonNullList<ItemStack> getRefinementItems() {
        return this.refinementItems;
    }

    @Override
    public void damageRefinements() {
        Registry enchantments = this.player.asEntity().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Holder.Reference unbreaking = enchantments.getHolderOrThrow(Enchantments.UNBREAKING);
        this.refinementItems.stream().filter(s -> !s.isEmpty()).forEach(stack -> {
            IRefinementSet set = ((IRefinementItem)stack.getItem()).getRefinementSet((ItemStack)stack);
            int damage = 40 + (set.getRarity().weight - 1) * 10 + this.getPlayer().asEntity().getRandom().nextInt(60);
            int unbreakingLevel = stack.getEnchantmentLevel((Holder)unbreaking);
            if (unbreakingLevel > 0) {
                damage = (int)((float)damage / (1.0f / (1.6f / ((float)unbreakingLevel + 1.0f))));
            }
            stack.setDamageValue(stack.getDamageValue() + damage);
            if (stack.getDamageValue() >= stack.getMaxDamage()) {
                stack.setCount(0);
            }
        });
    }

    public void disableAllSkills() {
        for (ISkill<T> skill : this.enabledSkills) {
            skill.onDisable(this.player);
        }
        this.enabledSkills.clear();
        this.dirty = true;
    }

    @Override
    public void disableSkill(@NotNull ISkill<T> skill) {
        if (this.enabledSkills.remove(skill)) {
            skill.onDisable(this.player);
            this.dirty = true;
        }
    }

    @Override
    public void enableSkill(@NotNull ISkill<T> skill, boolean fromLoading) {
        if (!this.enabledSkills.contains(skill)) {
            skill.onEnable(this.player);
            this.enabledSkills.add(skill);
            if (!fromLoading) {
                this.player.asEntity().awardStat(((StatType)ModStats.SKILL_UNLOCKED.get()).get(skill));
            }
            this.dirty = true;
            Player player = this.player.asEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (serverPlayer.connection != null) {
                    ((SkillUnlockedCriterionTrigger)((Object)ModAdvancements.TRIGGER_SKILL_UNLOCKED.get())).trigger(serverPlayer, skill);
                }
            }
        }
    }

    @Override
    public boolean equipRefinementItem(@NotNull ItemStack stack) {
        IRefinementItem refinementItem;
        Item item = stack.getItem();
        if (item instanceof IRefinementItem && this.faction.equals((refinementItem = (IRefinementItem)item).getExclusiveFaction(stack))) {
            @Nullable IRefinementSet newSet = refinementItem.getRefinementSet(stack);
            IRefinementItem.AccessorySlotType setSlot = refinementItem.getSlotType();
            this.removeRefinementItem(setSlot);
            this.dirty = true;
            this.applyRefinementItem(stack, setSlot.getSlot());
            return true;
        }
        return false;
    }

    @Override
    public void removeRefinementItem(@NotNull IRefinementItem.AccessorySlotType slot) {
        this.removeRefinementItem(slot.getSlot());
        this.dirty = true;
    }

    @Override
    public void updateUnlockedSkillTrees(Collection<Holder<ISkillTree>> skillTrees) {
        List<Holder> removedTrees = this.unlockedTrees.stream().filter(x -> !skillTrees.contains(x)).toList();
        removedTrees.forEach(this::lockSkillTree);
        skillTrees.stream().filter(x -> !this.unlockedTrees.contains(x)).forEach(this::unlockSkillTree);
        this.dirty = true;
    }

    private void unlockSkillTree(Holder<ISkillTree> tree) {
        this.unlockedTrees.add(tree);
        SkillTreeConfiguration.SkillTreeNodeConfiguration root = this.treeData.root(tree);
        root.elements().forEach(x -> this.enableSkill((ISkill)x.value(), true));
        this.dirty = true;
    }

    private void lockSkillTree(Holder<ISkillTree> tree) {
        ArrayList<ISkill<T>> enabledSkills = new ArrayList<ISkill<T>>(this.enabledSkills);
        for (ISkill<T> enabledSkill : enabledSkills) {
            if (!((Boolean)enabledSkill.allowedSkillTrees().map(arg_0 -> tree.is(arg_0), arg_0 -> tree.is(arg_0))).booleanValue()) continue;
            this.disableSkill(enabledSkill);
        }
        this.unlockedTrees.remove(tree);
        this.dirty = true;
    }

    @Override
    @NotNull
    public Collection<Holder<ISkillTree>> unlockedSkillTrees() {
        return Collections.unmodifiableCollection(this.unlockedTrees);
    }

    @Override
    public int getLeftSkillPoints() {
        if (this.skillPoints.ignoreSkillPointLimit((IFactionPlayer<?>)this.player)) {
            return Integer.MAX_VALUE;
        }
        return Math.max(0, this.skillPoints.getSkillPoints((IFactionPlayer<?>)this.player) - this.enabledSkills.stream().mapToInt(ISkill::getSkillPointCost).sum());
    }

    @Override
    public void reset() {
        this.disableAllSkills();
        this.resetRefinements();
        this.unlockedTrees.clear();
        this.dirty = true;
    }

    @Override
    public ISkill<T> @Nullable [] getParentSkills(@NotNull ISkill<T> skill) {
        Optional<SkillTreeConfiguration.SkillTreeNodeConfiguration> nodeForSkill = this.treeData.getNodeForSkill(this.unlockedTrees, skill);
        return (ISkill[])nodeForSkill.flatMap(this.treeData::getParent).stream().flatMap(x -> ((ISkillNode)x.value()).skills().stream()).map(Holder::value).toArray(ISkill[]::new);
    }

    public T getPlayer() {
        return this.player;
    }

    public boolean noSkillEnabled() {
        List list = this.unlockedTrees.stream().map(this.treeData::root).flatMap(x -> x.elements().stream()).map(Holder::value).collect(Collectors.toList());
        return this.enabledSkills.isEmpty() || new HashSet(list).containsAll(this.enabledSkills);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isNodeEnabled(@NotNull ISkillNode node) {
        for (ISkill<T> s : this.enabledSkills) {
            if (!node.containsSkill(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRefinementEquipped(IRefinement refinement) {
        return this.activeRefinements.contains(refinement);
    }

    @Override
    public boolean isSkillEnabled(ISkill<?> skill) {
        return this.enabledSkills.contains(skill);
    }

    @Override
    public boolean areSkillsEnabled(Collection<ISkill<?>> skill) {
        return this.enabledSkills.containsAll(skill);
    }

    @Override
    public boolean isSkillEnabled(Holder<ISkill<?>> skill) {
        return this.enabledSkills.contains(skill.value());
    }

    public boolean isSkillNodeLocked(@NotNull ISkillNode nodeIn) {
        Registry nodes = this.player.asEntity().level().registryAccess().registryOrThrow(VampirismRegistries.Keys.SKILL_NODE);
        return nodeIn.lockingNodes().stream().flatMap(s -> nodes.getOptional(s).stream()).flatMap(s -> s.skills().stream()).map(Holder::value).anyMatch(this::isSkillEnabled);
    }

    @Override
    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        if (nbt.contains("skills")) {
            for (Object id : nbt.getCompound("skills").getAllKeys()) {
                ISkill<?> skill = RegUtil.getSkill(ResourceLocation.parse((String)id));
                if (skill == null) {
                    LOGGER.warn("Skill {} does not exist anymore", id);
                    continue;
                }
                this.enableSkill(skill, true);
            }
        }
        if (nbt.contains("refinement_set")) {
            CompoundTag setsNBT = nbt.getCompound("refinement_set");
            for (String id : setsNBT.getAllKeys()) {
                int i = Integer.parseInt(id);
                CompoundTag setNBT = setsNBT.getCompound(id);
                String setName = setNBT.getString("id");
                int damage = setNBT.getInt("damage");
                if ("none".equals(setName)) continue;
                ResourceLocation setId = ResourceLocation.parse((String)setName);
                IRefinementSet set = RegUtil.getRefinementSet(setId);
                Object refinementItem = this.faction.getRefinementItem(IRefinementItem.AccessorySlotType.values()[i]);
                ItemStack itemStack = new ItemStack(refinementItem);
                itemStack.setDamageValue(damage);
                ((IRefinementItem)refinementItem).applyRefinementSet(itemStack, set);
                this.applyRefinementItem(itemStack, i);
            }
        }
        if (nbt.contains("refinement_items")) {
            ListTag refinements = nbt.getList("refinement_items", 10);
            for (int i = 0; i < refinements.size(); ++i) {
                IRefinementItem refinementItem;
                IFaction<?> exclusiveFaction;
                CompoundTag stackNbt = refinements.getCompound(i);
                int slot = stackNbt.getInt("slot");
                ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)stackNbt.getCompound("stack"));
                Item damage = stack.getItem();
                if (!(damage instanceof IRefinementItem) || (exclusiveFaction = (refinementItem = (IRefinementItem)damage).getExclusiveFaction(stack)) != null && !this.faction.equals(exclusiveFaction)) continue;
                this.applyRefinementItem(stack, slot);
            }
        }
        if (nbt.contains("unlocked_trees")) {
            ListTag unlockedTrees = nbt.getList("unlocked_trees", 8);
            this.unlockedTrees.clear();
            unlockedTrees.stream().map(StringTag.class::cast).forEach(tag -> this.unlockedTrees.add(RegUtil.getSkillTree(this.getPlayer().asEntity().level(), tag.getAsString())));
        }
    }

    @Override
    public void deserializeUpdateNBT(HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        if (nbt.contains("skills", 10)) {
            List old = (List)this.enabledSkills.clone();
            for (String id : nbt.getCompound("skills").getAllKeys()) {
                ISkill<?> skill = RegUtil.getSkill(ResourceLocation.parse((String)id));
                if (skill == null) {
                    LOGGER.error("Skill {} does not exist on client!!!", (Object)id);
                    continue;
                }
                if (old.contains(skill)) {
                    old.remove(skill);
                    continue;
                }
                this.enableSkill(skill, true);
            }
            for (ISkill skill : old) {
                this.disableSkill(skill);
            }
        }
        if (nbt.contains("refinement_items", 9)) {
            ListTag refinements = nbt.getList("refinement_items", 10);
            for (int i = 0; i < refinements.size(); ++i) {
                IRefinementItem refinementItem;
                IFaction<?> exclusiveFaction;
                CompoundTag stackNbt = refinements.getCompound(i);
                int slot = stackNbt.getInt("slot");
                ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)stackNbt.getCompound("stack"));
                Item item = stack.getItem();
                if (!(item instanceof IRefinementItem) || (exclusiveFaction = (refinementItem = (IRefinementItem)item).getExclusiveFaction(stack)) != null && !this.faction.equals(exclusiveFaction)) continue;
                this.applyRefinementItem(stack, slot);
            }
        }
        if (nbt.contains("unlocked_trees", 9)) {
            ListTag unlockedTrees = nbt.getList("unlocked_trees", 8);
            this.unlockedTrees.clear();
            unlockedTrees.stream().map(StringTag.class::cast).forEach(tag -> this.unlockedTrees.add(RegUtil.getSkillTree(this.getPlayer().asEntity().level(), tag.getAsString())));
        }
    }

    @Override
    public void resetRefinements() {
        for (int i = 0; i < this.refinementItems.size(); ++i) {
            this.removeRefinementItem(i);
        }
        this.refinementItems.clear();
        this.dirty = true;
    }

    @Override
    public void resetSkills() {
        this.disableAllSkills();
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        CompoundTag skills = new CompoundTag();
        for (ISkill<T> skill : this.enabledSkills) {
            skills.putBoolean(RegUtil.id(skill).toString(), true);
        }
        nbt.put("skills", (Tag)skills);
        ListTag refinements = new ListTag();
        for (int i = 0; i < this.refinementItems.size(); ++i) {
            ItemStack stack = (ItemStack)this.refinementItems.get(i);
            if (stack.isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putInt("slot", i);
            Tag tag = stack.save(provider);
            compoundTag.put("stack", tag);
            refinements.add((Object)compoundTag);
        }
        nbt.put("refinement_items", (Tag)refinements);
        ListTag unlockedTrees = new ListTag();
        for (Holder holder : this.unlockedTrees) {
            unlockedTrees.add((Object)StringTag.valueOf((String)RegUtil.id(this.getPlayer().asEntity().level(), (ISkillTree)holder.value()).toString()));
        }
        nbt.put("unlocked_trees", (Tag)unlockedTrees);
        return nbt;
    }

    @Override
    @NotNull
    public CompoundTag serializeUpdateNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        CompoundTag skills = new CompoundTag();
        for (ISkill<T> skill : this.enabledSkills) {
            skills.putBoolean(RegUtil.id(skill).toString(), true);
        }
        nbt.put("skills", (Tag)skills);
        ListTag refinementItems = new ListTag();
        for (int i = 0; i < this.refinementItems.size(); ++i) {
            ItemStack stack = (ItemStack)this.refinementItems.get(i);
            if (stack.isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putInt("slot", i);
            Tag tag = stack.save(provider);
            compoundTag.put("stack", tag);
            refinementItems.add((Object)compoundTag);
        }
        nbt.put("refinement_items", (Tag)refinementItems);
        ListTag unlockedTrees = new ListTag();
        for (Holder holder : this.unlockedTrees) {
            unlockedTrees.add((Object)StringTag.valueOf((String)RegUtil.id(this.getPlayer().asEntity().level(), (ISkillTree)holder.value()).toString()));
        }
        nbt.put("unlocked_trees", (Tag)unlockedTrees);
        this.dirty = false;
        return nbt;
    }

    private void applyRefinementItem(@NotNull ItemStack stack, int slot) {
        IRefinementItem refinementItem;
        IRefinementSet set;
        this.refinementItems.set(slot, (Object)stack);
        Item item = stack.getItem();
        if (item instanceof IRefinementItem && (set = (refinementItem = (IRefinementItem)item).getRefinementSet(stack)) != null) {
            set.getRefinements().stream().map(Supplier::get).forEach(x -> {
                this.activeRefinements.add((IRefinement)x);
                if (!this.player.isRemote() && x.getAttribute() != null) {
                    ResourceLocation key = ModRegistries.REFINEMENTS.getKey(x);
                    AttributeInstance attributeInstance = this.player.asEntity().getAttribute(x.getAttribute());
                    double value = x.getModifierValue();
                    AttributeModifier t = attributeInstance.getModifier(key);
                    if (t != null) {
                        attributeInstance.removeModifier(key);
                        value += t.amount();
                    }
                    t = x.createAttributeModifier(value);
                    this.refinementModifier.put(key, t);
                    attributeInstance.addTransientModifier(t);
                }
            });
        }
    }

    private void removeRefinementItem(int slot) {
        ItemStack stack = (ItemStack)this.refinementItems.get(slot);
        if (!stack.isEmpty()) {
            IRefinementItem refinementItem;
            IRefinementSet set;
            this.refinementItems.set(slot, (Object)ItemStack.EMPTY);
            Item item = stack.getItem();
            if (item instanceof IRefinementItem && (set = (refinementItem = (IRefinementItem)item).getRefinementSet(stack)) != null) {
                set.getRefinements().stream().map(Supplier::get).forEach(x -> {
                    this.activeRefinements.remove(x);
                    if (!this.player.isRemote() && x.getAttribute() != null) {
                        ResourceLocation key = ModRegistries.REFINEMENTS.getKey(x);
                        AttributeInstance attributeInstance = this.player.asEntity().getAttribute(x.getAttribute());
                        AttributeModifier t = this.refinementModifier.remove(key);
                        attributeInstance.removeModifier(key);
                        ((AttributeInstanceAccessor)attributeInstance).invoke_removeModifier(t);
                        double value = t.amount() - x.getModifierValue();
                        if (value != 0.0) {
                            t = x.createAttributeModifier(value);
                            attributeInstance.addTransientModifier(t);
                            this.refinementModifier.put(key, t);
                            this.activeRefinements.add((IRefinement)x);
                        }
                    }
                });
            }
        }
    }

    @Override
    public String nbtKey() {
        return NBT_KEY;
    }

    public static class SkillPoints
    implements ISkillPointProvider {
        private final Map<ResourceLocation, ISkillPointProvider> provider = SkillPointProviders.MODIFIERS_VIEW;

        @Override
        public int getSkillPoints(IFactionPlayer<?> factionPlayer) {
            return this.provider.values().stream().mapToInt(x -> Math.max(0, x.getSkillPoints(factionPlayer))).sum();
        }

        @Override
        public boolean ignoreSkillPointLimit(IFactionPlayer<?> factionPlayer) {
            return this.provider.values().stream().anyMatch(l -> l.ignoreSkillPointLimit(factionPlayer));
        }
    }
}

