/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VampirismContainerMenu
extends AbstractContainerMenu {
    private final int size;

    protected VampirismContainerMenu(@Nullable MenuType<?> pMenuType, int pContainerId, int size) {
        super(pMenuType, pContainerId);
        this.size = size;
    }

    protected void addPlayerSlots(@NotNull Container playerInventory, int baseX, int baseY) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot(playerInventory, j + i * 9 + 9, baseX + j * 18, baseY + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot(playerInventory, i, baseX + i * 18, baseY + 58));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player pPlayer, int index) {
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            result = slotStack.copy();
            if (index < this.size) {
                if (!this.moveItemStackTo(slotStack, this.size, 36 + this.size, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (index >= this.size && index < 27 + this.size) {
                if (!this.moveItemStackTo(slotStack, 0, this.size, false) && slotStack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(slotStack, 27 + this.size, 36 + this.size, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (index >= 27 + this.size && index < 36 + this.size && !this.moveItemStackTo(slotStack, 0, 27 + this.size, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == result.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, slotStack);
        }
        return result;
    }
}

