/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModDataComponents;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.fluids.BloodFluid;
import de.teamlapen.vampirism.items.component.BottleBlood;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BloodBottleFluidHandler
implements IFluidHandlerItem {
    public static final int MULTIPLIER = 100;
    private final int capacity;
    @NotNull
    protected ItemStack container;

    public static int getAdjustedAmount(int amt) {
        return amt - amt % 100;
    }

    public BloodBottleFluidHandler(@NotNull ItemStack container, int capacity) {
        this.container = container;
        this.capacity = capacity;
    }

    @NotNull
    public FluidStack drain(@Nullable FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || resource == null || resource.getAmount() <= 0 || ModFluids.BLOOD.get() != resource.getFluid()) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
        int currentAmt = this.getBlood(this.container);
        if (currentAmt == 0) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = new FluidStack((Fluid)ModFluids.BLOOD.get(), Math.min(currentAmt, BloodBottleFluidHandler.getAdjustedAmount(maxDrain)));
        if (action.execute()) {
            this.setBlood(this.container, currentAmt - stack.getAmount());
            if (this.getBlood(this.container) == 0 && ((Boolean)VampirismConfig.COMMON.autoConvertGlassBottles.get()).booleanValue()) {
                this.container = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            }
        }
        return stack;
    }

    public int fill(@Nullable FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        if (resource == null) {
            return 0;
        }
        if (!resource.getFluid().equals(ModFluids.BLOOD.get())) {
            return 0;
        }
        if (action.simulate()) {
            return Math.min(this.capacity - this.getBlood(this.container), BloodBottleFluidHandler.getAdjustedAmount(resource.getAmount()));
        }
        int itemamt = this.getBlood(this.container);
        int toFill = Math.min(this.capacity - itemamt, BloodBottleFluidHandler.getAdjustedAmount(resource.getAmount()));
        this.setBlood(this.container, itemamt + toFill);
        return toFill;
    }

    public int getBlood(@NotNull ItemStack stack) {
        return stack.getItem() == ModItems.BLOOD_BOTTLE.get() ? ((BottleBlood)stack.getOrDefault(ModDataComponents.BOTTLE_BLOOD, (Object)BottleBlood.EMPTY)).blood() * 100 : 0;
    }

    @NotNull
    public ItemStack getContainer() {
        return this.container;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return new FluidStack((Fluid)ModFluids.BLOOD.get(), this.getBlood(this.container));
    }

    public int getTankCapacity(int tank) {
        return 900;
    }

    public int getTanks() {
        return 1;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return ((BloodFluid)((Object)ModFluids.BLOOD.get())).isSame(stack.getFluid());
    }

    public void setBlood(@NotNull ItemStack stack, int amt) {
        stack.set(ModDataComponents.BOTTLE_BLOOD, (Object)new BottleBlood(amt / 100));
    }
}

