/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinionUpgradeItem
extends Item {
    private final int minLevel;
    private final int maxLevel;
    private final IFaction<?> faction;

    public MinionUpgradeItem(int minLevel, int maxLevel, IFaction<?> faction) {
        super(new Item.Properties());
        this.faction = faction;
        this.maxLevel = maxLevel;
        this.minLevel = minLevel;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.vampirism.minion_upgrade_item.desc").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"text.vampirism.for_to_levels", (Object[])new Object[]{this.minLevel + 1, this.maxLevel + 1}).withStyle(ChatFormatting.GRAY));
    }

    public IFaction<?> getFaction() {
        return this.faction;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getMinLevel() {
        return this.minLevel;
    }
}

