/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.ModDisplayItemGenerator;
import de.teamlapen.vampirism.api.items.IOilItem;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.core.ModDataComponents;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.items.component.OilContent;
import de.teamlapen.vampirism.util.ItemDataUtils;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class OilBottleItem
extends Item
implements IOilItem,
ModDisplayItemGenerator.CreativeTabItemProvider {
    public OilBottleItem(@NotNull Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemStack getDefaultInstance() {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        itemStack.set(ModDataComponents.OIL, (Object)OilContent.EMPTY);
        return itemStack;
    }

    @Override
    @NotNull
    public ItemStack withOil(@NotNull Holder<IOil> oil) {
        return ItemDataUtils.createOil(this, oil);
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        OilContent oilContents = (OilContent)stack.getOrDefault(ModDataComponents.OIL, (Object)OilContent.EMPTY);
        return (Component)oilContents.oil().unwrapKey().map(s -> Component.translatable((String)("oil." + s.location().getNamespace() + "." + s.location().getPath())).append(" ")).orElse(Component.empty());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltips, TooltipFlag flag) {
        ((IOil)OilContent.getOil(stack).value()).getDescription(stack, context, tooltips);
    }

    @Override
    public void generateCreativeTab(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        ModRegistries.OILS.holders().map(l -> ItemDataUtils.createOil(this, (Holder<IOil>)l)).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
    }

    @Override
    @NotNull
    public Holder<IOil> getOil(@NotNull ItemStack stack) {
        return ((OilContent)stack.getOrDefault(ModDataComponents.OIL, (Object)OilContent.EMPTY)).oil();
    }
}

