/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.advancements.critereon.HunterActionCriterionTrigger;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.hunter.IAdvancedHunter;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.api.items.IVampireFinisher;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.items.VampirismSwordItem;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StakeItem
extends VampirismSwordItem
implements IVampireFinisher {
    public static boolean canKillInstant(@NotNull LivingEntity target, LivingEntity attacker) {
        boolean instaKillFromBehind = false;
        boolean instaKillLowHealth = false;
        if (attacker instanceof Player && attacker.isAlive()) {
            @Nullable IFactionPlayer factionPlayer = FactionPlayerHandler.getCurrentFactionPlayer((Player)attacker).orElse(null);
            if (factionPlayer != null && factionPlayer.getFaction().equals(VReference.HUNTER_FACTION)) {
                ISkillHandler skillHandler = factionPlayer.getSkillHandler();
                if (skillHandler.isSkillEnabled((ISkill)HunterSkills.STAKE2.get())) {
                    instaKillFromBehind = true;
                }
                if (skillHandler.isSkillEnabled((ISkill)HunterSkills.STAKE1.get())) {
                    instaKillLowHealth = true;
                }
            }
        } else if (attacker instanceof IAdvancedHunter) {
            instaKillLowHealth = true;
        }
        if (instaKillFromBehind && !UtilLib.canReallySee(target, attacker, true)) {
            return ((Boolean)VampirismConfig.BALANCE.hsInstantKill2OnlyNPC.get() == false || !(target instanceof Player)) && target.getMaxHealth() < (float)((Integer)VampirismConfig.BALANCE.hsInstantKill2MaxHealth.get()).intValue();
        }
        if (instaKillLowHealth && (double)target.getHealth() <= (Double)VampirismConfig.BALANCE.hsInstantKill1MaxHealth.get() * (double)target.getMaxHealth()) {
            return (Boolean)VampirismConfig.BALANCE.hsInstantKill1FromBehind.get() == false || !UtilLib.canReallySee(target, attacker, true);
        }
        return false;
    }

    public StakeItem() {
        super((Tier)Tiers.WOOD, 1, -1.0f, new Item.Properties());
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        if (!attacker.getCommandSenderWorld().isClientSide && (target instanceof IVampireMob || target instanceof Player && Helper.isVampire((Player)target)) && StakeItem.canKillInstant(target, attacker)) {
            DamageHandler.hurtModded((Entity)target, sources -> sources.stake(attacker), 10000.0f);
            if (attacker instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)attacker;
                player.awardStat((ResourceLocation)ModStats.KILLED_WITH_STAKE.get());
                ((HunterActionCriterionTrigger)((Object)ModAdvancements.TRIGGER_HUNTER_ACTION.get())).trigger(player, HunterActionCriterionTrigger.Action.STAKE);
            }
            target.getCommandSenderWorld().playSound(null, target.getX(), target.getY() + 0.5 * (double)target.getEyeHeight(), target.getZ(), (SoundEvent)ModSounds.STAKE.get(), SoundSource.PLAYERS, 1.5f, 0.7f);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public boolean isEnchantable(ItemStack pStack) {
        return false;
    }
}

