/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class VampireFangItem
extends Item {
    public VampireFangItem() {
        super(new Item.Properties());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (!worldIn.isClientSide) {
            if (((Boolean)VampirismConfig.SERVER.disableFangInfection.get()).booleanValue()) {
                playerIn.displayClientMessage((Component)Component.translatable((String)"text.vampirism.deactivated_by_serveradmin"), true);
            } else {
                if (Helper.canBecomeVampire(playerIn)) {
                    SanguinareEffect.addRandom((LivingEntity)playerIn, true);
                    playerIn.addEffect(new MobEffectInstance(MobEffects.POISON, 60));
                } else if (Helper.isVampire(playerIn)) {
                    playerIn.displayClientMessage((Component)Component.translatable((String)"text.vampirism.already_vampire"), true);
                } else {
                    playerIn.displayClientMessage((Component)Component.translatable((String)"text.vampirism.immune_to").append((Component)Component.translatable((String)((MobEffect)ModEffects.SANGUINARE.get()).getDescriptionId())), true);
                }
                stack.shrink(1);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

