/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import de.teamlapen.vampirism.api.items.ExtendedPotionMix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import org.jetbrains.annotations.NotNull;

public class JEIPotionMix {
    private final ItemStack potionInput;
    private final ItemStack potionOutput;
    private final List<ItemStack> mix1;
    private final List<ItemStack> mix2;
    private final ExtendedPotionMix original;

    @NotNull
    public static Collection<JEIPotionMix> createFromMix(@NotNull ExtendedPotionMix mix) {
        List<ItemStack> in1 = Arrays.stream(mix.reagent1.get().getItems()).map(ItemStack::copy).peek(s -> s.setCount(mix.reagent1Count)).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        List<ItemStack> in2 = Arrays.stream(mix.reagent2.get().getItems()).map(ItemStack::copy).peek(s -> s.setCount(mix.reagent2Count)).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        ArrayList<JEIPotionMix> recipes = new ArrayList<JEIPotionMix>(3);
        recipes.add(JEIPotionMix.build(mix, Items.POTION, mix.input, mix.output, in1, in2));
        if (((Potion)mix.output.value()).getEffects().stream().noneMatch(s -> ((MobEffect)s.getEffect().value()).getCategory() != MobEffectCategory.HARMFUL)) {
            recipes.add(JEIPotionMix.build(mix, Items.LINGERING_POTION, mix.input, mix.output, in1, in2));
            recipes.add(JEIPotionMix.build(mix, Items.SPLASH_POTION, mix.input, mix.output, in1, in2));
        }
        return recipes;
    }

    @NotNull
    private static JEIPotionMix build(ExtendedPotionMix mix, Item base, @NotNull Holder<Potion> in, @NotNull Holder<Potion> out, List<ItemStack> in1, List<ItemStack> in2) {
        ItemStack potionIn = PotionContents.createItemStack((Item)base, in);
        ItemStack potionOut = PotionContents.createItemStack((Item)base, out);
        return new JEIPotionMix(mix, potionIn, in1, in2, potionOut);
    }

    private JEIPotionMix(ExtendedPotionMix original, ItemStack potionInput, List<ItemStack> mix1, List<ItemStack> mix2, ItemStack potionOutput) {
        this.original = original;
        this.potionInput = potionInput;
        this.mix1 = mix1;
        this.mix2 = mix2;
        this.potionOutput = potionOutput;
    }

    public ExtendedPotionMix getOriginal() {
        return this.original;
    }

    public ItemStack getPotionInput() {
        return this.potionInput;
    }

    public List<ItemStack> getMix1() {
        return this.mix1;
    }

    public List<ItemStack> getMix2() {
        return this.mix2;
    }

    public ItemStack getPotionOutput() {
        return this.potionOutput;
    }
}

