/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.client.gui.screens.WeaponTableScreen;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.modcompat.jei.RecipeUtil;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import de.teamlapen.vampirism.recipes.ShapedWeaponTableRecipe;
import de.teamlapen.vampirism.recipes.ShapelessWeaponTableRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class WeaponTableRecipeCategory
implements IRecipeCategory<RecipeHolder<IWeaponTableRecipe>> {
    private static final ItemStack lavaStack = new ItemStack((ItemLike)Items.LAVA_BUCKET);
    @NotNull
    private final Component localizedName = Component.translatable((String)((WeaponTableBlock)((Object)ModBlocks.WEAPON_TABLE.get())).getDescriptionId());
    @NotNull
    private final IDrawable background;
    @NotNull
    private final IDrawable icon;
    @NotNull
    private final IDrawable bucket;

    WeaponTableRecipeCategory(@NotNull IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(WeaponTableScreen.BACKGROUND, 32, 14, 134, 77).addPadding(0, 33, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.WEAPON_TABLE.get()));
        this.bucket = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.LAVA_BUCKET));
    }

    public void draw(@NotNull RecipeHolder<IWeaponTableRecipe> holder, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics graphics, double mouseX, double mouseY) {
        List<ISkill<IHunterPlayer>> requiredSkills;
        IWeaponTableRecipe recipe = (IWeaponTableRecipe)holder.value();
        int x = 2;
        int y = 80;
        Minecraft minecraft = Minecraft.getInstance();
        if (recipe.getRequiredLavaUnits() > 0) {
            this.bucket.draw(graphics, 83, 13);
            PoseStack pose = graphics.pose();
            pose.pushPose();
            RenderSystem.backupProjectionMatrix();
            RenderSystem.setProjectionMatrix((Matrix4f)pose.last().pose(), (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
            graphics.renderItem(lavaStack, 83, 13);
            RenderSystem.restoreProjectionMatrix();
            pose.popPose();
        }
        if (recipe.getRequiredLevel() > 1) {
            MutableComponent level = Component.translatable((String)"gui.vampirism.hunter_weapon_table.level", (Object[])new Object[]{recipe.getRequiredLevel()});
            graphics.drawString(minecraft.font, (Component)level, x, y, Color.GRAY.getRGB(), false);
            Objects.requireNonNull(minecraft.font);
            y += 9 + 2;
        }
        if (!(requiredSkills = recipe.getRequiredSkills()).isEmpty()) {
            MutableComponent skillText = Component.translatable((String)"gui.vampirism.skill_required", (Object[])new Object[]{" "});
            for (ISkill<IHunterPlayer> skill : recipe.getRequiredSkills()) {
                skillText.append((Component)skill.getName()).append(" ");
            }
            y += UtilLib.renderMultiLine(minecraft.font, graphics, (Component)skillText, 132, x, y, Color.GRAY.getRGB());
        }
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public RecipeType<RecipeHolder<IWeaponTableRecipe>> getRecipeType() {
        return VampirismJEIPlugin.WEAPON_TABLE;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<IWeaponTableRecipe> holder, IFocusGroup focuses) {
        int n;
        int height;
        IWeaponTableRecipe recipe = (IWeaponTableRecipe)holder.value();
        if (recipe instanceof ShapelessWeaponTableRecipe) {
            builder.setShapeless();
        }
        List<List> inputs = recipe.getIngredients().stream().map(ingredient -> List.of(ingredient.getItems())).toList();
        List<List> list = recipe.getIngredients().stream().map(s -> List.of(s.getItems())).toList();
        IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 112, 32);
        output.addItemStack(RecipeUtil.getResultItem(recipe));
        ArrayList<IRecipeSlotBuilder> inputSlots = new ArrayList<IRecipeSlotBuilder>();
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, 2 + x * 19, 2 + y * 19);
                inputSlots.add(slot);
            }
        }
        if (recipe instanceof ShapedWeaponTableRecipe) {
            ShapedWeaponTableRecipe shaped = (ShapedWeaponTableRecipe)recipe;
            v0 = shaped.getHeight();
        } else {
            v0 = height = 4;
        }
        if (recipe instanceof ShapedWeaponTableRecipe) {
            ShapedWeaponTableRecipe shaped = (ShapedWeaponTableRecipe)recipe;
            n = shaped.getWidth();
        } else {
            n = 4;
        }
        int width = n;
        for (int i = 0; i < inputs.size(); ++i) {
            int index = WeaponTableRecipeCategory.getCraftingIndex(i, width, height);
            IRecipeSlotBuilder slot = (IRecipeSlotBuilder)inputSlots.get(index);
            List itemStacks = inputs.get(i);
            if (itemStacks == null) continue;
            slot.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, itemStacks);
        }
    }

    private static int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 4 ? i * 4 + 1 : (height == 3 ? i * 4 + 1 : (height == 2 ? i * 4 + 1 : 5));
        } else if (height == 1) {
            index = i + 4;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                index += 2;
                if (i > 3) {
                    index += 2;
                    if (i > 5) {
                        index += 2;
                    }
                }
            }
        } else if (height == 2) {
            index = i;
            if (width == 3 && i > 2) {
                ++index;
            }
        } else if (width == 3) {
            index = i;
            if (i > 2) {
                ++index;
                if (i > 5) {
                    ++index;
                    if (i > 8) {
                        ++index;
                    }
                }
            }
        } else {
            index = i;
        }
        return index;
    }
}

