/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.recipes;

import de.teamlapen.vampirism.recipes.BrewingRecipeInput;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBrewingRecipe
implements Recipe<BrewingRecipeInput> {
    protected final RecipeType<?> type;
    protected final String group;
    protected final Ingredient ingredient;
    protected final Ingredient input;
    protected final ItemStack result;

    public AbstractBrewingRecipe(RecipeType<?> type, String group, Ingredient ingredient, Ingredient input, ItemStack result) {
        this.type = type;
        this.group = group;
        this.ingredient = ingredient;
        this.input = input;
        this.result = result;
    }

    public boolean matches(@NotNull BrewingRecipeInput inventory, @NotNull Level level) {
        return this.ingredient.test(inventory.input());
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public Ingredient getInput() {
        return this.input;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.ingredient});
    }

    @NotNull
    public ItemStack assemble(@NotNull BrewingRecipeInput inventory, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int xSize, int ySize) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        return this.result;
    }

    @NotNull
    public RecipeType<?> getType() {
        return this.type;
    }
}

