/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.recipes.AlchemicalCauldronRecipeInput;
import de.teamlapen.vampirism.util.StreamCodecExtension;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;

public class AlchemicalCauldronRecipe
implements Recipe<AlchemicalCauldronRecipeInput> {
    protected final RecipeType<?> type = (RecipeType)ModRecipes.ALCHEMICAL_CAULDRON_TYPE.get();
    protected final String group;
    private final Either<Ingredient, FluidStack> fluid;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    @NotNull
    private final List<ISkill<?>> skills;
    private final int reqLevel;
    protected final float experience;
    protected final int cookingTime;

    public AlchemicalCauldronRecipe(@NotNull String groupIn, @NotNull Ingredient ingredientIn, Either<Ingredient, FluidStack> fluidIn, @NotNull ItemStack resultIn, @NotNull List<ISkill<?>> skillsIn, int reqLevelIn, int cookTimeIn, float exp) {
        this.group = groupIn;
        this.ingredient = ingredientIn;
        this.result = resultIn;
        this.experience = exp;
        this.cookingTime = cookTimeIn;
        this.fluid = fluidIn;
        this.skills = skillsIn;
        this.reqLevel = reqLevelIn;
    }

    public boolean canBeCooked(int level, @NotNull ISkillHandler<IHunterPlayer> skillHandler) {
        if (level < this.reqLevel) {
            return false;
        }
        for (ISkill<?> s : this.skills) {
            if (skillHandler.isSkillEnabled(s)) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(AlchemicalCauldronRecipeInput p_345149_, HolderLookup.Provider p_346030_) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonnulllist = NonNullList.create();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public float getExperience() {
        return this.experience;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.result;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public RecipeType<?> getType() {
        return this.type;
    }

    public Either<Ingredient, FluidStack> getFluid() {
        return this.fluid;
    }

    @NotNull
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getRequiredLevel() {
        return this.reqLevel;
    }

    @NotNull
    public List<ISkill<?>> getRequiredSkills() {
        return this.skills;
    }

    public ItemStack result() {
        return this.result;
    }

    public String group() {
        return this.group;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.ALCHEMICAL_CAULDRON.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(@NotNull AlchemicalCauldronRecipeInput inv, @NotNull Level worldIn) {
        boolean match = this.ingredient.test(inv.ingredient());
        Boolean fluidMatch = (Boolean)this.fluid.map(ingredient1 -> ingredient1.test(inv.fluid()), fluid1 -> FluidUtil.getFluidContained((ItemStack)inv.fluid()).map(s -> FluidStack.isSameFluidSameComponents((FluidStack)fluid1, (FluidStack)s) && fluid1.getAmount() < s.getAmount()).orElse(false));
        switch (inv.testType()) {
            default: {
                throw new MatchException(null, null);
            }
            case INPUT_1: {
                if (!match) return false;
                break;
            }
            case INPUT_2: {
                if (fluidMatch == false) return false;
                break;
            }
            case BOTH: {
                if (!match) return false;
                if (fluidMatch == false) return false;
            }
        }
        if (inv.skills().map(s -> s.areSkillsEnabled(this.skills)).orElse(true) == false) return false;
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<AlchemicalCauldronRecipe> {
        public static final MapCodec<AlchemicalCauldronRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_300832_ -> p_300832_.group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(p_300833_ -> p_300833_.ingredient), (App)Codec.either((Codec)Ingredient.CODEC_NONEMPTY, (Codec)FluidStack.CODEC).fieldOf("fluid").forGetter(s -> s.fluid), (App)ItemStack.CODEC.fieldOf("result").forGetter(p_300827_ -> p_300827_.result), (App)ModRegistries.SKILLS.byNameCodec().listOf().optionalFieldOf("skill", Collections.emptyList()).forGetter(p -> p.skills), (App)Codec.INT.optionalFieldOf("level", (Object)1).forGetter(p -> p.reqLevel), (App)Codec.INT.optionalFieldOf("cookTime", (Object)200).forGetter(p -> p.cookingTime), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.2f)).forGetter(p -> Float.valueOf(p.experience))).apply((Applicative)inst, AlchemicalCauldronRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AlchemicalCauldronRecipe> STREAM_CODEC = StreamCodecExtension.composite(ByteBufCodecs.STRING_UTF8, AlchemicalCauldronRecipe::group, Ingredient.CONTENTS_STREAM_CODEC, AlchemicalCauldronRecipe::getIngredient, ByteBufCodecs.either((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, (StreamCodec)FluidStack.STREAM_CODEC), AlchemicalCauldronRecipe::getFluid, ItemStack.STREAM_CODEC, AlchemicalCauldronRecipe::result, ByteBufCodecs.registry(VampirismRegistries.Keys.SKILL).apply(ByteBufCodecs.list()), AlchemicalCauldronRecipe::getRequiredSkills, ByteBufCodecs.INT, AlchemicalCauldronRecipe::getRequiredLevel, ByteBufCodecs.INT, AlchemicalCauldronRecipe::getCookingTime, ByteBufCodecs.FLOAT, AlchemicalCauldronRecipe::getExperience, AlchemicalCauldronRecipe::new);

        @NotNull
        public MapCodec<AlchemicalCauldronRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, AlchemicalCauldronRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

