/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.entity.CaptureEntityEntry;
import de.teamlapen.vampirism.api.entity.factions.IFactionVillageBuilder;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModVillage;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import org.jetbrains.annotations.NotNull;

public class HunterVillage {
    @NotNull
    public static ItemStack createBanner(HolderLookup.Provider provider) {
        HolderLookup.RegistryLookup bannerPattern = provider.lookupOrThrow(Registries.BANNER_PATTERN);
        ItemStack itemStack = new ItemStack((ItemLike)Items.BLUE_BANNER);
        itemStack.set(DataComponents.HIDE_ADDITIONAL_TOOLTIP, (Object)Unit.INSTANCE);
        itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"block.minecraft.ominous_banner").withStyle(ChatFormatting.GOLD));
        BannerPatternLayers.Builder builder = new BannerPatternLayers.Builder();
        builder.add((Holder)bannerPattern.getOrThrow(BannerPatterns.STRIPE_SMALL), DyeColor.BLACK).add((Holder)bannerPattern.getOrThrow(BannerPatterns.STRIPE_CENTER), DyeColor.BLACK).add((Holder)bannerPattern.getOrThrow(BannerPatterns.BORDER), DyeColor.WHITE).add((Holder)bannerPattern.getOrThrow(BannerPatterns.STRIPE_MIDDLE), DyeColor.BLACK).add((Holder)bannerPattern.getOrThrow(BannerPatterns.CURLY_BORDER), DyeColor.BLACK).add((Holder)bannerPattern.getOrThrow(BannerPatterns.STRAIGHT_CROSS), DyeColor.WHITE);
        itemStack.set(DataComponents.BANNER_PATTERNS, (Object)builder.build());
        return itemStack;
    }

    public static void hunterVillage(@NotNull IFactionVillageBuilder builder) {
        builder.badOmenEffect((Holder<MobEffect>)ModEffects.BAD_OMEN_HUNTER).captureEntities(Lists.newArrayList((Object[])new CaptureEntityEntry[]{new CaptureEntityEntry(ModEntities.HUNTER, 10)})).factionVillagerProfession((Supplier<VillagerProfession>)ModVillage.HUNTER_EXPERT).guardSuperClass(HunterBaseEntity.class).taskMaster(ModEntities.TASK_MASTER_HUNTER).banner(HunterVillage::createBanner).totem((Supplier<? extends Block>)ModBlocks.TOTEM_TOP_VAMPIRISM_HUNTER, (Supplier<? extends Block>)ModBlocks.TOTEM_TOP_VAMPIRISM_HUNTER_CRAFTED);
    }
}

