/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import org.jetbrains.annotations.NotNull;

public class MixinHooks {
    private static final List<String> onlyOneStructure = Lists.newArrayList();
    public static boolean enforcingGlowing_bloodVision = false;
    public static float armorLayerPartialTicks;

    public static void addSingleInstanceStructure(@NotNull List<ResourceLocation> structures) {
        onlyOneStructure.addAll(structures.stream().map(MixinHooks::singleJigsawString).toList());
    }

    public static void replaceSingleInstanceStructure(@NotNull List<ResourceLocation> structures) {
        onlyOneStructure.clear();
        onlyOneStructure.addAll(structures.stream().map(MixinHooks::singleJigsawString).toList());
    }

    public static boolean checkStructures(@NotNull List<? super PoolElementStructurePiece> pieces, @NotNull StructurePoolElement jigsawPiece) {
        if (!onlyOneStructure.contains(jigsawPiece.toString())) {
            return false;
        }
        return pieces.stream().anyMatch(structurePiece -> {
            PoolElementStructurePiece elem;
            return structurePiece instanceof PoolElementStructurePiece && MixinHooks.equals((elem = (PoolElementStructurePiece)structurePiece).getElement(), jigsawPiece);
        });
    }

    private static boolean equals(StructurePoolElement first, StructurePoolElement second) {
        if (first == second) {
            return true;
        }
        if (first.getClass() != second.getClass()) {
            return false;
        }
        return first.toString().equals(second.toString());
    }

    @NotNull
    private static String singleJigsawString(@NotNull ResourceLocation resourceLocation) {
        return "Single[Left[" + String.valueOf(resourceLocation) + "]]";
    }
}

