/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.settings.Supporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Stream;
import net.minecraft.util.RandomSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SupporterManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Supporter[] vampire = new Supporter[0];
    private static Supporter[] hunter = new Supporter[0];

    public static Supporter getRandomHunter(@NotNull RandomSource rnd) {
        if (hunter.length > 0) {
            return hunter[rnd.nextInt(hunter.length)];
        }
        return new Supporter(VReference.HUNTER_FACTION_ID, "none", "none", null, new HashMap<String, String>());
    }

    public static Supporter getRandomVampire(@NotNull RandomSource rnd) {
        if (vampire.length > 0) {
            return vampire[rnd.nextInt(vampire.length)];
        }
        return new Supporter(VReference.VAMPIRE_FACTION_ID, "none", "none", null, new HashMap<String, String>());
    }

    public static void init() {
        VampirismAPI.settings().getSupportersAsync().thenApply(optional -> {
            if (optional.isPresent()) {
                vampire = (Supporter[])((Collection)optional.get()).stream().filter(s -> s.faction().equals((Object)VReference.VAMPIRE_FACTION_ID)).toArray(Supporter[]::new);
                hunter = (Supporter[])((Collection)optional.get()).stream().filter(s -> s.faction().equals((Object)VReference.HUNTER_FACTION_ID)).toArray(Supporter[]::new);
                LOGGER.debug("Loaded {} vampire and {} hunter supporter", (Object)vampire.length, (Object)hunter.length);
                return (Collection)optional.get();
            }
            LOGGER.warn("Failed to retrieve supporters");
            return new ArrayList();
        });
    }

    public static Stream<Supporter> getSupporter() {
        return Stream.concat(Stream.of(hunter), Stream.of(vampire));
    }
}

