/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world;

import com.google.common.collect.Lists;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.network.ClientboundUpdateMultiBossEventPacket;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.BossEvent;
import org.jetbrains.annotations.NotNull;

public class MultiBossEvent {
    private final UUID uniqueId;
    protected Component name;
    protected BossEvent.BossBarOverlay overlay;
    protected List<Color> colors;
    protected Map<Color, Float> entries;

    public MultiBossEvent(UUID uniqueIdIn, Component nameIn, BossEvent.BossBarOverlay overlayIn, Color ... entries) {
        this.uniqueId = uniqueIdIn;
        this.name = nameIn;
        this.overlay = overlayIn;
        this.colors = Lists.newArrayList((Object[])entries);
        this.entries = new HashMap<Color, Float>();
    }

    public MultiBossEvent(@NotNull ClientboundUpdateMultiBossEventPacket.AddOperation operation) {
        this.uniqueId = operation.uniqueId();
        this.name = operation.name();
        this.colors = operation.colors();
        this.entries = operation.entries();
        this.overlay = operation.overlay();
    }

    public void clear() {
        this.entries.clear();
    }

    public List<Color> getColors() {
        return this.colors;
    }

    public void setColors(Color ... entries) {
        this.colors = Lists.newArrayList((Object[])entries);
    }

    public Map<Color, Float> getEntries() {
        return this.entries;
    }

    public Component getName() {
        return this.name;
    }

    public void setName(Component name) {
        this.name = name;
    }

    public BossEvent.BossBarOverlay getOverlay() {
        return this.overlay;
    }

    public void setOverlay(BossEvent.BossBarOverlay overlay) {
        this.overlay = overlay;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public void setPercentage(Color color, float perc) {
        if (!this.colors.contains(color)) {
            this.colors.add(color);
        }
        this.entries.put(color, Float.valueOf(perc));
    }

    public void setPercentage(float ... perc) {
        for (int i = 0; i < perc.length; ++i) {
            if (this.colors.size() < i + 1) continue;
            this.entries.put(this.colors.get(i), Float.valueOf(perc[i]));
        }
    }

    public void updateFromPackage(ClientboundUpdateMultiBossEventPacket.Operation packet) {
        ClientboundUpdateMultiBossEventPacket.Operation operation = packet;
        Objects.requireNonNull(operation);
        ClientboundUpdateMultiBossEventPacket.Operation operation2 = operation;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClientboundUpdateMultiBossEventPacket.UpdateNameOperation.class, ClientboundUpdateMultiBossEventPacket.UpdateProgressOperation.class, ClientboundUpdateMultiBossEventPacket.UpdateStyle.class}, (Object)operation2, n)) {
            case 0: {
                ClientboundUpdateMultiBossEventPacket.UpdateNameOperation operation3 = (ClientboundUpdateMultiBossEventPacket.UpdateNameOperation)operation2;
                this.name = operation3.name();
                break;
            }
            case 1: {
                ClientboundUpdateMultiBossEventPacket.UpdateProgressOperation operation4 = (ClientboundUpdateMultiBossEventPacket.UpdateProgressOperation)operation2;
                this.entries = operation4.entries();
                break;
            }
            case 2: {
                ClientboundUpdateMultiBossEventPacket.UpdateStyle operation5 = (ClientboundUpdateMultiBossEventPacket.UpdateStyle)operation2;
                this.overlay = operation5.overlay();
                break;
            }
        }
    }
}

