/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.api.VEnums;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.blocks.CursedEarthBlock;
import de.teamlapen.vampirism.blocks.DarkSpruceLeavesBlock;
import de.teamlapen.vampirism.blocks.DarkStoneBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModFeatures;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.mixin.accessor.OrePlacementAccessor;
import de.teamlapen.vampirism.world.gen.feature.VampireDungeonFeature;
import de.teamlapen.vampirism.world.gen.feature.treedecorators.TrunkCursedVineDecorator;
import de.teamlapen.vampirism.world.gen.modifier.ExtendedAddSpawnsBiomeModifier;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.ThreeLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.SpruceFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class VampirismFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> VAMPIRE_FLOWER = VampirismFeatures.createConfiguredKey("vampire_flower");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CURSED_ROOT = VampirismFeatures.createConfiguredKey("cursed_root");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DARK_SPRUCE_TREE = VampirismFeatures.createConfiguredKey("dark_spruce_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CURSED_SPRUCE_TREE = VampirismFeatures.createConfiguredKey("cursed_tree_red");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VAMPIRE_DUNGEON = VampirismFeatures.createConfiguredKey("vampire_dungeon");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VAMPIRE_TREES = VampirismFeatures.createConfiguredKey("vampire_trees_placed");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_DARK_STONE = VampirismFeatures.createConfiguredKey("ore_dark_stone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_CURSED_DIRT = VampirismFeatures.createConfiguredKey("ore_cursed_dirt");
    public static final ResourceKey<PlacedFeature> VAMPIRE_FLOWER_PLACED = VampirismFeatures.createPlacedKey("vampire_flower");
    public static final ResourceKey<PlacedFeature> CURSED_ROOT_PLACED = VampirismFeatures.createPlacedKey("cursed_root");
    public static final ResourceKey<PlacedFeature> DARK_SPRUCE_TREE_PLACED = VampirismFeatures.createPlacedKey("dark_spruce_tree");
    public static final ResourceKey<PlacedFeature> CURSED_SPRUCE_TREE_PLACED = VampirismFeatures.createPlacedKey("cursed_spruce_tree_placed");
    public static final ResourceKey<PlacedFeature> VAMPIRE_DUNGEON_PLACED = VampirismFeatures.createPlacedKey("vampire_dungeon");
    public static final ResourceKey<PlacedFeature> VAMPIRE_TREES_PLACED = VampirismFeatures.createPlacedKey("vampire_trees");
    public static final ResourceKey<PlacedFeature> FOREST_GRASS_PLACED = VampirismFeatures.createPlacedKey("forest_grass");
    public static final ResourceKey<PlacedFeature> ORE_DARK_STONE_PLACED = VampirismFeatures.createPlacedKey("ore_dark_stone_lower");
    public static final ResourceKey<PlacedFeature> ORE_CURSED_DIRT_PLACED = VampirismFeatures.createPlacedKey("ore_cursed_dirt");
    public static final ResourceKey<BiomeModifier> VAMPIRE_SPAWN = VampirismFeatures.createModifierKey("spawn/vampire_spawns");
    public static final ResourceKey<BiomeModifier> HUNTER_SPAWN = VampirismFeatures.createModifierKey("spawn/hunter_spawns");
    public static final ResourceKey<BiomeModifier> ADVANCED_VAMPIRE_SPAWN = VampirismFeatures.createModifierKey("spawn/advanced_vampire_spawns");
    public static final ResourceKey<BiomeModifier> ADVANCED_HUNTER_SPAWN = VampirismFeatures.createModifierKey("spawn/advanced_hunter_spawns");
    public static final ResourceKey<BiomeModifier> VAMPIRE_DUNGEON_MODIFIER = VampirismFeatures.createModifierKey("feature/vampire_dungeon");

    private static ResourceKey<ConfiguredFeature<?, ?>> createConfiguredKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)VResourceLocation.mod(name));
    }

    private static ResourceKey<PlacedFeature> createPlacedKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)VResourceLocation.mod(name));
    }

    private static ResourceKey<BiomeModifier> createModifierKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)VResourceLocation.mod(name));
    }

    public static void createConfiguredFeatures(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        context.register(VAMPIRE_FLOWER, (Object)new ConfiguredFeature(Feature.FLOWER, (FeatureConfiguration)FeatureUtils.simpleRandomPatchConfiguration((int)32, (Holder)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.VAMPIRE_ORCHID.get())))))));
        context.register(CURSED_ROOT, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simpleRandomPatchConfiguration((int)16, (Holder)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.CURSED_ROOTS.get())))))));
        context.register(DARK_SPRUCE_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.DARK_SPRUCE_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(11, 2, 2), (BlockStateProvider)BlockStateProvider.simple((BlockState)((DarkSpruceLeavesBlock)((Object)ModBlocks.DARK_SPRUCE_LEAVES.get())).defaultBlockState()), (FoliagePlacer)new SpruceFoliagePlacer((IntProvider)UniformInt.of((int)2, (int)3), (IntProvider)UniformInt.of((int)0, (int)2), (IntProvider)UniformInt.of((int)3, (int)7)), (FeatureSize)new ThreeLayersFeatureSize(5, 8, 0, 3, 3, OptionalInt.of(5))).ignoreVines().build()));
        context.register(CURSED_SPRUCE_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.CURSED_SPRUCE_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(11, 2, 2), (BlockStateProvider)BlockStateProvider.simple((BlockState)((DarkSpruceLeavesBlock)((Object)ModBlocks.DARK_SPRUCE_LEAVES.get())).defaultBlockState()), (FoliagePlacer)new SpruceFoliagePlacer((IntProvider)UniformInt.of((int)2, (int)3), (IntProvider)UniformInt.of((int)0, (int)2), (IntProvider)UniformInt.of((int)3, (int)7)), (FeatureSize)new ThreeLayersFeatureSize(5, 8, 0, 3, 3, OptionalInt.of(5))).decorators((List)ImmutableList.of((Object)((Object)TrunkCursedVineDecorator.INSTANCE))).ignoreVines().build()));
        context.register(VAMPIRE_DUNGEON, (Object)new ConfiguredFeature((Feature)((VampireDungeonFeature)((Object)ModFeatures.VAMPIRE_DUNGEON.get())), (FeatureConfiguration)FeatureConfiguration.NONE));
        context.register(VAMPIRE_TREES, (Object)new ConfiguredFeature(Feature.RANDOM_SELECTOR, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(CURSED_SPRUCE_TREE_PLACED), 0.3f)), (Holder)placedFeatures.getOrThrow(DARK_SPRUCE_TREE_PLACED))));
        context.register(ORE_DARK_STONE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.BASE_STONE_OVERWORLD), ((DarkStoneBlock)((Object)ModBlocks.DARK_STONE.get())).defaultBlockState(), 64)));
        context.register(ORE_CURSED_DIRT, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.BASE_STONE_OVERWORLD), ((CursedEarthBlock)ModBlocks.CURSED_EARTH.get()).defaultBlockState(), 33)));
    }

    public static void createPlacedFeatures(BootstrapContext<PlacedFeature> context) {
        HolderGetter placedFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        context.register(VAMPIRE_FLOWER_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(VAMPIRE_FLOWER), List.of(RarityFilter.onAverageOnceEvery((int)4), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, InSquarePlacement.spread(), BiomeFilter.biome())));
        context.register(CURSED_ROOT_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(CURSED_ROOT), List.of(RarityFilter.onAverageOnceEvery((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome())));
        context.register(DARK_SPRUCE_TREE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(DARK_SPRUCE_TREE), List.of(PlacementUtils.filteredByBlockSurvival((Block)((Block)ModBlocks.DARK_SPRUCE_SAPLING.get())))));
        context.register(CURSED_SPRUCE_TREE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(CURSED_SPRUCE_TREE), List.of(PlacementUtils.filteredByBlockSurvival((Block)((Block)ModBlocks.CURSED_SPRUCE_SAPLING.get())))));
        context.register(VAMPIRE_DUNGEON_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(VAMPIRE_DUNGEON), List.of(CountPlacement.of((int)3), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.top()), BiomeFilter.biome())));
        context.register(VAMPIRE_TREES_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(VAMPIRE_TREES), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)10, (float)0.1f, (int)1))));
        context.register(FOREST_GRASS_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(VegetationFeatures.PATCH_GRASS), VegetationPlacements.worldSurfaceSquaredWithCount((int)2)));
        context.register(ORE_DARK_STONE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(ORE_DARK_STONE), OrePlacementAccessor.commonOrePlacement(30, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.top()))));
        context.register(ORE_CURSED_DIRT_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(ORE_CURSED_DIRT), OrePlacementAccessor.commonOrePlacement(7, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)160)))));
    }

    public static void createBiomeModifier(BootstrapContext<BiomeModifier> context) {
        HolderGetter biomeLookup = context.lookup(Registries.BIOME);
        HolderGetter placedFeatureLookup = context.lookup(Registries.PLACED_FEATURE);
        context.register(VAMPIRE_SPAWN, (Object)ExtendedAddSpawnsBiomeModifier.singleSpawn((HolderSet<Biome>)biomeLookup.getOrThrow(ModTags.Biomes.HasSpawn.VAMPIRE), (HolderSet<Biome>)biomeLookup.getOrThrow(ModTags.Biomes.NoSpawn.VAMPIRE), new ExtendedAddSpawnsBiomeModifier.ExtendedSpawnData((EntityType)ModEntities.VAMPIRE.get(), 80, 1, 3, (MobCategory)VEnums.VAMPIRE_CATEGORY.getValue())));
        context.register(ADVANCED_VAMPIRE_SPAWN, (Object)ExtendedAddSpawnsBiomeModifier.singleSpawn((HolderSet<Biome>)biomeLookup.getOrThrow(ModTags.Biomes.HasSpawn.ADVANCED_VAMPIRE), (HolderSet<Biome>)biomeLookup.getOrThrow(ModTags.Biomes.NoSpawn.ADVANCED_VAMPIRE), new ExtendedAddSpawnsBiomeModifier.ExtendedSpawnData((EntityType)ModEntities.ADVANCED_VAMPIRE.get(), 30, 1, 3, (MobCategory)VEnums.VAMPIRE_CATEGORY.getValue())));
        context.register(VAMPIRE_DUNGEON_MODIFIER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeLookup.getOrThrow(ModTags.Biomes.HasStructure.VAMPIRE_DUNGEON), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatureLookup.getOrThrow(VAMPIRE_DUNGEON_PLACED)}), GenerationStep.Decoration.UNDERGROUND_STRUCTURES));
    }
}

