/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.structure.hunteroutpost;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.core.ModStructures;
import de.teamlapen.vampirism.world.gen.structure.PoolExtensions;
import de.teamlapen.vampirism.world.gen.structure.hunteroutpost.BadlandsHunterOutpostPools;
import de.teamlapen.vampirism.world.gen.structure.hunteroutpost.DesertHunterOutpostPools;
import de.teamlapen.vampirism.world.gen.structure.hunteroutpost.PlainsHunterOutpostPools;
import de.teamlapen.vampirism.world.gen.structure.hunteroutpost.VampireForestHunterOutpostPools;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class HunterOutpostPools {
    public static final ResourceKey<StructureTemplatePool> HORSES = ModStructures.createTemplatePool("hunter_outpost/horses");
    public static final ResourceKey<StructureTemplatePool> TRAINER = ModStructures.createTemplatePool("hunter_outpost/trainer");
    public static final ResourceKey<StructureTemplatePool> TENTS = ModStructures.createTemplatePool("hunter_outpost/tents");
    public static final ResourceKey<StructureTemplatePool> TRAINING_DUMMIES = ModStructures.createTemplatePool("hunter_outpost/training_dummies");
    public static final ResourceKey<StructureTemplatePool> STABLES = ModStructures.createTemplatePool("hunter_outpost/stables");
    public static final ResourceKey<StructureTemplatePool> TOOL_SMITH = ModStructures.createTemplatePool("hunter_outpost/tool_smith");
    public static final ResourceKey<StructureTemplatePool> TOWER = ModStructures.createTemplatePool("hunter_outpost/tower");
    public static final ResourceKey<StructureTemplatePool> ALCHEMY = ModStructures.createTemplatePool("hunter_outpost/alchemy");
    public static final ResourceKey<StructureTemplatePool> FLAG = ModStructures.createTemplatePool("hunter_outpost/flag");

    public static void bootstrap(BootstrapContext<StructureTemplatePool> context) {
        PlainsHunterOutpostPools.bootstrap(context);
        DesertHunterOutpostPools.bootstrap(context);
        VampireForestHunterOutpostPools.bootstrap(context);
        BadlandsHunterOutpostPools.bootstrap(context);
        HolderGetter templatePools = context.lookup(Registries.TEMPLATE_POOL);
        Holder.Reference empty = templatePools.getOrThrow(Pools.EMPTY);
        context.register(HORSES, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"village/common/animals/horses_1"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"village/common/animals/horses_2"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"village/common/animals/horses_3"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(TRAINER, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(PoolExtensions.single("village/entities/hunter_trainer"), (Object)1), (Object)Pair.of((Object)EmptyPoolElement.empty(), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(TENTS, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(PoolExtensions.single("hunter_outpost/common/tent_1"), (Object)1), (Object)Pair.of(PoolExtensions.single("hunter_outpost/common/tent_2"), (Object)1), (Object)Pair.of(PoolExtensions.single("hunter_outpost/common/tent_3"), (Object)1), (Object)Pair.of(PoolExtensions.single("hunter_outpost/common/tent_4"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(TRAINING_DUMMIES, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(PoolExtensions.single("hunter_outpost/common/training_dummies"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(STABLES, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(PoolExtensions.single("hunter_outpost/common/stables"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(TOOL_SMITH, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(PoolExtensions.single("hunter_outpost/common/tool_smith"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(TOWER, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(PoolExtensions.single("hunter_outpost/common/tower"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(ALCHEMY, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(PoolExtensions.single("hunter_outpost/common/alchemy"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(FLAG, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(PoolExtensions.single("hunter_outpost/common/flag"), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }
}

