/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.core.ModLoot;
import java.util.Optional;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public class FactionCondition
implements LootItemCondition {
    public static final MapCodec<FactionCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)StringRepresentable.fromEnum(Type::values).fieldOf("type").forGetter(s -> s.type), (App)IFaction.CODEC.optionalFieldOf("faction").forGetter(a -> a.faction), (App)Codec.INT.optionalFieldOf("min_level").forGetter(a -> a.minLevel), (App)Codec.INT.optionalFieldOf("max_level").forGetter(a -> a.maxLevel)).apply((Applicative)inst, FactionCondition::new));
    @NotNull
    private final Type type;
    private final Optional<IFaction<?>> faction;
    private final Optional<Integer> minLevel;
    private final Optional<Integer> maxLevel;

    private FactionCondition(@NotNull Type type, Optional<IFaction<?>> faction, Optional<Integer> minLevel, Optional<Integer> maxLevel) {
        this.type = type;
        this.faction = faction;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    public FactionCondition(@NotNull IFaction<?> faction, int minLevel, int maxLevel) {
        this.type = Type.FACTION;
        this.faction = Optional.of(faction);
        this.minLevel = Optional.of(minLevel);
        this.maxLevel = Optional.of(maxLevel);
    }

    public FactionCondition(@NotNull IFaction<?> faction) {
        this.type = Type.FACTION;
        this.faction = Optional.of(faction);
        this.minLevel = Optional.empty();
        this.maxLevel = Optional.empty();
    }

    public FactionCondition(int minLevel, int maxLevel) {
        this.type = Type.ANY_FACTION;
        this.faction = Optional.empty();
        this.minLevel = Optional.of(minLevel);
        this.maxLevel = Optional.of(maxLevel);
    }

    public FactionCondition(int minLevel) {
        this.type = Type.ANY_FACTION;
        this.faction = Optional.empty();
        this.minLevel = Optional.of(minLevel);
        this.maxLevel = Optional.empty();
    }

    public FactionCondition() {
        this.type = Type.NO_FACTION;
        this.faction = Optional.empty();
        this.minLevel = Optional.empty();
        this.maxLevel = Optional.empty();
    }

    @NotNull
    public LootItemConditionType getType() {
        return (LootItemConditionType)ModLoot.FACTION.get();
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            IFactionPlayerHandler handler = VampirismAPI.factionPlayerHandler(player);
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> handler.getCurrentFactionPlayer().isEmpty();
                case 1 -> {
                    if (!this.minLevel.map(minLevel -> handler.getCurrentLevel() < minLevel).orElse(false).booleanValue() && !this.maxLevel.map(maxLevel -> handler.getCurrentLevel() > maxLevel).orElse(false).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> handler.isInFaction(this.faction.orElseThrow()) && this.minLevel.map(minLevel -> handler.getCurrentLevel() < minLevel).orElse(false) == false && this.maxLevel.map(maxLevel -> handler.getCurrentLevel() > maxLevel).orElse(false) == false;
            };
        }
        return false;
    }

    public static enum Type implements StringRepresentable
    {
        NO_FACTION("no_faction"),
        ANY_FACTION("any_faction"),
        FACTION("faction");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

