/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.converation;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.api.DecimalRangeSupplier;
import team.creative.creativecore.common.config.api.IntRangeSupplier;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiSlider;
import team.creative.creativecore.common.gui.control.simple.GuiStateButton;
import team.creative.creativecore.common.gui.control.simple.GuiSteppedSlider;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.util.text.TextMapBuilder;

public class ConfigTypeNumber {
    private static final NumberFormat NUMBER_FORMAT = ConfigTypeNumber.createFormat();
    private static final HashMap<Class, IntRangeSupplier> INT_SUPPLIERS = new HashMap();
    private static final HashMap<Class, DecimalRangeSupplier> DECIMAL_SUPPLIERS = new HashMap();

    public static IntRangeSupplier getIntRangeSupplier(Class clazz) {
        IntRangeSupplier s = INT_SUPPLIERS.get(clazz);
        if (s == null) {
            try {
                s = (IntRangeSupplier)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                INT_SUPPLIERS.put(clazz, s);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Error when creating " + String.valueOf(clazz) + " int range supplier");
            }
        }
        return s;
    }

    public static DecimalRangeSupplier getDecimalRangeSupplier(Class clazz) {
        DecimalRangeSupplier s = DECIMAL_SUPPLIERS.get(clazz);
        if (s == null) {
            try {
                s = (DecimalRangeSupplier)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                DECIMAL_SUPPLIERS.put(clazz, s);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Error when creating " + String.valueOf(clazz) + " decimal range supplier");
            }
        }
        return s;
    }

    private static NumberFormat createFormat() {
        NumberFormat format = NumberFormat.getInstance(Locale.ENGLISH);
        format.setMaximumFractionDigits(Integer.MAX_VALUE);
        format.setGroupingUsed(false);
        return format;
    }

    public static void init() {
        ConfigTypeConveration.registerTypes(new ConfigTypeConveration.SimpleConfigTypeConveration<Boolean>(){

            @Override
            public Boolean readElement(ConfigKey key, Boolean defaultValue, Side side, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean()) {
                    return element.getAsBoolean();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Boolean value, ConfigKey key, Side side) {
                return new JsonPrimitive(value);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, ConfigKey key) {
                parent.add(new GuiStateButton<Boolean>("data", false, new TextMapBuilder<Boolean>().addComponent(false, (Component)Component.translatable((String)"gui.false").setStyle(Style.EMPTY.withColor(ChatFormatting.RED))).addComponent(true, (Component)Component.translatable((String)"gui.true").setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN)))).setExpandableX());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void loadValue(Boolean value, GuiParent parent) {
                GuiStateButton button = (GuiStateButton)parent.get("data");
                button.select(value);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            protected Boolean saveValue(GuiParent parent, ConfigKey key) {
                GuiStateButton button = (GuiStateButton)parent.get("data");
                return (Boolean)button.selected();
            }

            @Override
            public Boolean set(ConfigKey key, Boolean value) {
                return value;
            }
        }, Boolean.TYPE, Boolean.class);
        ConfigTypeConveration.registerTypeCreator(Boolean.TYPE, () -> false);
        ConfigTypeConveration.registerTypeCreator(Boolean.class, () -> Boolean.FALSE);
        ConfigTypeConveration.registerTypes(new ConfigTypeConveration.SimpleConfigTypeConveration<Number>(){

            @Override
            public Number readElement(ConfigKey key, Number defaultValue, Side side, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
                    Class clazz = key.field().getType();
                    if (clazz == Float.class || clazz == Float.TYPE) {
                        return Float.valueOf(element.getAsFloat());
                    }
                    if (clazz == Double.class || clazz == Double.TYPE) {
                        return element.getAsDouble();
                    }
                    if (clazz == Byte.class || clazz == Byte.TYPE) {
                        return element.getAsByte();
                    }
                    if (clazz == Short.class || clazz == Short.TYPE) {
                        return element.getAsShort();
                    }
                    if (clazz == Integer.class || clazz == Integer.TYPE) {
                        return element.getAsInt();
                    }
                    if (clazz == Long.class || clazz == Long.TYPE) {
                        return element.getAsLong();
                    }
                    return element.getAsNumber();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Number value, ConfigKey key, Side side) {
                return new JsonPrimitive(value);
            }

            public boolean isDecimal(Class clazz) {
                return clazz == Float.class || clazz == Float.TYPE || clazz == Double.class || clazz == Double.TYPE;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, ConfigKey key) {
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                boolean decimal = this.isDecimal(key.field().getType());
                if (key != null) {
                    if (decimal) {
                        CreativeConfig.DecimalRange decRange = key.field().getAnnotation(CreativeConfig.DecimalRange.class);
                        if (decRange != null && decRange.slider()) {
                            parent.add(new GuiSlider("data", decRange.min(), decRange.min(), decRange.max()).setExpandableX());
                            return;
                        }
                        CreativeConfig.DecimalRangeSupplier supplier = key.field().getAnnotation(CreativeConfig.DecimalRangeSupplier.class);
                        if (supplier != null && supplier.slider()) {
                            DecimalRangeSupplier s = ConfigTypeNumber.getDecimalRangeSupplier(supplier.supplier());
                            parent.add(new GuiSlider("data", s.getMin(), s.getMin(), s.getMax()).setExpandableX());
                            return;
                        }
                    } else {
                        CreativeConfig.IntRange intRange = key.field().getAnnotation(CreativeConfig.IntRange.class);
                        if (intRange != null && intRange.slider()) {
                            parent.add(new GuiSteppedSlider("data", intRange.min(), intRange.min(), intRange.max()).setExpandableX());
                            return;
                        }
                        CreativeConfig.IntRangeSupplier supplier = key.field().getAnnotation(CreativeConfig.IntRangeSupplier.class);
                        if (supplier != null && supplier.slider()) {
                            IntRangeSupplier s = ConfigTypeNumber.getIntRangeSupplier(supplier.supplier());
                            parent.add(new GuiSteppedSlider("data", s.getMin(), s.getMin(), s.getMax()).setExpandableX());
                            return;
                        }
                    }
                }
                GuiTextfield textfield = (GuiTextfield)new GuiTextfield("data").setDim(30, 8).setExpandableX();
                if (decimal) {
                    textfield.setFloatOnly();
                } else {
                    textfield.setNumbersIncludingNegativeOnly();
                }
                parent.add((GuiControl)textfield);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void loadValue(Number value, GuiParent parent) {
                Object control = parent.get("data");
                if (control instanceof GuiSteppedSlider) {
                    GuiSteppedSlider button = (GuiSteppedSlider)control;
                    button.setValue(value.intValue());
                } else if (control instanceof GuiSlider) {
                    GuiSlider button = (GuiSlider)control;
                    button.setValue(value.doubleValue());
                } else {
                    ((GuiTextfield)control).setText(NUMBER_FORMAT.format(value));
                }
            }

            public Number parseDecimal(Class clazz, double decimal) {
                if (clazz == Float.class || clazz == Float.TYPE) {
                    return Float.valueOf((float)decimal);
                }
                return decimal;
            }

            public Number parseInt(Class clazz, int number) {
                if (clazz == Byte.class || clazz == Byte.TYPE) {
                    return (byte)number;
                }
                if (clazz == Short.class || clazz == Short.TYPE) {
                    return (short)number;
                }
                if (clazz == Long.class || clazz == Long.TYPE) {
                    return (long)number;
                }
                return number;
            }

            public Number parseNumber(Class clazz, String text) {
                if (clazz == Float.class || clazz == Float.TYPE) {
                    try {
                        return Float.valueOf(Float.parseFloat(text));
                    }
                    catch (NumberFormatException e) {
                        return Float.valueOf(0.0f);
                    }
                }
                if (clazz == Double.class || clazz == Double.TYPE) {
                    try {
                        return Double.parseDouble(text);
                    }
                    catch (NumberFormatException e) {
                        return 0.0;
                    }
                }
                if (clazz == Byte.class || clazz == Byte.TYPE) {
                    try {
                        return Byte.parseByte(text);
                    }
                    catch (NumberFormatException e) {
                        return (byte)0;
                    }
                }
                if (clazz == Short.class || clazz == Short.TYPE) {
                    try {
                        return Short.parseShort(text);
                    }
                    catch (NumberFormatException e) {
                        return (short)0;
                    }
                }
                if (clazz == Integer.class || clazz == Integer.TYPE) {
                    try {
                        return Integer.parseInt(text);
                    }
                    catch (NumberFormatException e) {
                        return 0;
                    }
                }
                if (clazz == Long.class || clazz == Long.TYPE) {
                    try {
                        return Long.parseLong(text);
                    }
                    catch (NumberFormatException e) {
                        return 0L;
                    }
                }
                return 0;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            protected Number saveValue(GuiParent parent, ConfigKey key) {
                Object text;
                Object control = parent.get("data");
                if (control instanceof GuiSteppedSlider) {
                    GuiSteppedSlider button = (GuiSteppedSlider)control;
                    text = "" + button.getIntValue();
                } else if (control instanceof GuiSlider) {
                    GuiSlider button = (GuiSlider)control;
                    text = "" + button.getValue();
                } else {
                    text = ((GuiTextfield)control).getText();
                }
                return this.parseNumber(key.field().getType(), (String)text);
            }

            @Override
            public Number set(ConfigKey key, Number value) {
                if (key != null) {
                    Class clazz = key.field().getType();
                    if (this.isDecimal(clazz)) {
                        CreativeConfig.DecimalRange decRange = key.field().getAnnotation(CreativeConfig.DecimalRange.class);
                        if (decRange != null) {
                            return this.parseDecimal(clazz, Mth.clamp((double)value.doubleValue(), (double)decRange.min(), (double)decRange.max()));
                        }
                        CreativeConfig.DecimalRangeSupplier supplier = key.field().getAnnotation(CreativeConfig.DecimalRangeSupplier.class);
                        if (supplier != null) {
                            DecimalRangeSupplier s = ConfigTypeNumber.getDecimalRangeSupplier(supplier.supplier());
                            return this.parseDecimal(clazz, Mth.clamp((double)value.intValue(), (double)s.getMin(), (double)s.getMax()));
                        }
                    } else {
                        CreativeConfig.IntRange intRange = key.field().getAnnotation(CreativeConfig.IntRange.class);
                        if (intRange != null) {
                            return this.parseInt(clazz, Mth.clamp((int)value.intValue(), (int)intRange.min(), (int)intRange.max()));
                        }
                        CreativeConfig.IntRangeSupplier supplier = key.field().getAnnotation(CreativeConfig.IntRangeSupplier.class);
                        if (supplier != null) {
                            IntRangeSupplier s = ConfigTypeNumber.getIntRangeSupplier(supplier.supplier());
                            return this.parseInt(clazz, Mth.clamp((int)value.intValue(), (int)s.getMin(), (int)s.getMax()));
                        }
                    }
                }
                return value;
            }
        }, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class);
        ConfigTypeConveration.registerTypeCreator(Byte.TYPE, () -> (byte)0);
        ConfigTypeConveration.registerTypeCreator(Byte.class, () -> (byte)0);
        ConfigTypeConveration.registerTypeCreator(Short.TYPE, () -> (short)0);
        ConfigTypeConveration.registerTypeCreator(Short.class, () -> (short)0);
        ConfigTypeConveration.registerTypeCreator(Integer.TYPE, () -> 0);
        ConfigTypeConveration.registerTypeCreator(Integer.class, () -> 0);
        ConfigTypeConveration.registerTypeCreator(Long.TYPE, () -> 0L);
        ConfigTypeConveration.registerTypeCreator(Long.class, () -> 0L);
        ConfigTypeConveration.registerTypeCreator(Float.TYPE, () -> Float.valueOf(0.0f));
        ConfigTypeConveration.registerTypeCreator(Float.class, () -> Float.valueOf(0.0f));
        ConfigTypeConveration.registerTypeCreator(Double.TYPE, () -> 0.0);
        ConfigTypeConveration.registerTypeCreator(Double.class, () -> 0.0);
    }
}

