/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import xaero.map.WorldMap;
import xaero.map.graphics.shader.MapShaders;

public class CustomRenderTypes
extends RenderType {
    public static final VertexFormat POSITION_COLOR_TEX = VertexFormat.builder().add("Position", VertexFormatElement.POSITION).add("Color", VertexFormatElement.COLOR).add("UV0", VertexFormatElement.UV0).build();
    private static final RenderStateShard.OutputStateShard KEEP_TARGET = new RenderStateShard.OutputStateShard("xaero_wm_keep_target", () -> {}, () -> {});
    protected static final RenderStateShard.TransparencyStateShard TRANSLUCENT_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("xaero_wm_translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderStateShard.TransparencyStateShard DEST_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("xaero_wm_destination_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderStateShard.TransparencyStateShard PREMULTIPLIED_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("xaero_wm_premultiplied_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderType GUI_BILINEAR;
    public static final RenderType GUI_BILINEAR_PREMULTIPLIED;
    public static final RenderType GUI_NEAREST;
    public static final RenderType MAP;
    public static final RenderType MAP_COLOR_OVERLAY;
    public static final RenderType MAP_FRAME_TEXTURE_OVER_TRANSPARENT;
    public static final RenderType MAP_COLOR_FILLER;
    public static final RenderType MAP_ELEMENT_TEXT_BG;

    private CustomRenderTypes(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    static {
        ImmutableList<RenderStateShard> multiPhaseParameters = new MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(WorldMap.guiTextures, false, false)).transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MapShaders.POSITION_COLOR_TEX)).cull(NO_CULL).target(KEEP_TARGET).build();
        GUI_NEAREST = new MultiPhaseRenderType("xaero_wm_gui_nearest", POSITION_COLOR_TEX, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(WorldMap.guiTextures, true, false)).transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MapShaders.POSITION_COLOR_TEX)).cull(NO_CULL).target(KEEP_TARGET).build();
        GUI_BILINEAR = new MultiPhaseRenderType("xaero_wm_gui_bilinear", POSITION_COLOR_TEX, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(WorldMap.guiTextures, true, false)).transparency(PREMULTIPLIED_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MapShaders.POSITION_COLOR_TEX_PRE)).cull(NO_CULL).target(KEEP_TARGET).build();
        GUI_BILINEAR_PREMULTIPLIED = new MultiPhaseRenderType("xaero_wm_gui_bilinear_pre", POSITION_COLOR_TEX, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(WorldMap.guiTextures, false, false)).transparency(DEST_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MapShaders.WORLD_MAP)).cull(NO_CULL).target(KEEP_TARGET).build();
        MAP = new MultiPhaseRenderType("xaero_wm_map_with_light", DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MapShaders.POSITION_COLOR)).cull(NO_CULL).target(KEEP_TARGET).build();
        MAP_COLOR_OVERLAY = new MultiPhaseRenderType("xaero_wm_world_map_overlay", DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(WorldMap.guiTextures, true, false)).transparency(DEST_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MapShaders.POSITION_COLOR_TEX)).cull(NO_CULL).target(KEEP_TARGET).build();
        MAP_FRAME_TEXTURE_OVER_TRANSPARENT = new MultiPhaseRenderType("xaero_wm_frame_texture", POSITION_COLOR_TEX, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MapShaders.POSITION_COLOR)).target(KEEP_TARGET).build();
        MAP_COLOR_FILLER = new MultiPhaseRenderType("xaero_wm_world_map_filler", DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MapShaders.POSITION_COLOR)).target(KEEP_TARGET).build();
        MAP_ELEMENT_TEXT_BG = new MultiPhaseRenderType("xaero_wm_world_map_waypoint_name_bg", DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS, 42, false, false, multiPhaseParameters);
    }

    static class MultiPhaseBuilder
    extends RenderStateShard {
        private RenderStateShard.EmptyTextureStateShard texture = RenderStateShard.NO_TEXTURE;
        private RenderStateShard.ShaderStateShard shader = RenderStateShard.NO_SHADER;
        private RenderStateShard.TransparencyStateShard transparency = RenderStateShard.NO_TRANSPARENCY;
        private RenderStateShard.DepthTestStateShard depthTest = RenderStateShard.LEQUAL_DEPTH_TEST;
        private RenderStateShard.CullStateShard cull = RenderStateShard.CULL;
        private RenderStateShard.LightmapStateShard lightmap = RenderStateShard.NO_LIGHTMAP;
        private RenderStateShard.OverlayStateShard overlay = RenderStateShard.NO_OVERLAY;
        private RenderStateShard.LayeringStateShard layering = RenderStateShard.NO_LAYERING;
        private RenderStateShard.OutputStateShard target = RenderStateShard.MAIN_TARGET;
        private RenderStateShard.TexturingStateShard texturing = RenderStateShard.DEFAULT_TEXTURING;
        private RenderStateShard.WriteMaskStateShard writeMaskState = RenderStateShard.COLOR_DEPTH_WRITE;
        private RenderStateShard.LineStateShard lineWidth = RenderStateShard.DEFAULT_LINE;

        MultiPhaseBuilder() {
            super("weird access error workaround", null, null);
        }

        public MultiPhaseBuilder texture(RenderStateShard.EmptyTextureStateShard texture) {
            this.texture = texture;
            return this;
        }

        public MultiPhaseBuilder shader(RenderStateShard.ShaderStateShard shader) {
            this.shader = shader;
            return this;
        }

        public MultiPhaseBuilder transparency(RenderStateShard.TransparencyStateShard transparency) {
            this.transparency = transparency;
            return this;
        }

        public MultiPhaseBuilder depthTest(RenderStateShard.DepthTestStateShard depthTest) {
            this.depthTest = depthTest;
            return this;
        }

        public MultiPhaseBuilder cull(RenderStateShard.CullStateShard cull) {
            this.cull = cull;
            return this;
        }

        public MultiPhaseBuilder lightmap(RenderStateShard.LightmapStateShard lightmap) {
            this.lightmap = lightmap;
            return this;
        }

        public MultiPhaseBuilder overlay(RenderStateShard.OverlayStateShard overlay) {
            this.overlay = overlay;
            return this;
        }

        public MultiPhaseBuilder layering(RenderStateShard.LayeringStateShard layering) {
            this.layering = layering;
            return this;
        }

        public MultiPhaseBuilder target(RenderStateShard.OutputStateShard target) {
            this.target = target;
            return this;
        }

        public MultiPhaseBuilder texturing(RenderStateShard.TexturingStateShard texturing) {
            this.texturing = texturing;
            return this;
        }

        public MultiPhaseBuilder writeMaskState(RenderStateShard.WriteMaskStateShard writeMaskState) {
            this.writeMaskState = writeMaskState;
            return this;
        }

        public MultiPhaseBuilder lineWidth(RenderStateShard.LineStateShard lineWidth) {
            this.lineWidth = lineWidth;
            return this;
        }

        public ImmutableList<RenderStateShard> build() {
            return ImmutableList.of((Object)this.texture, (Object)this.shader, (Object)this.transparency, (Object)this.depthTest, (Object)this.cull, (Object)this.lightmap, (Object)this.overlay, (Object)this.layering, (Object)this.target, (Object)this.texturing, (Object)this.writeMaskState, (Object)this.lineWidth, (Object[])new RenderStateShard[0]);
        }
    }

    private static class MultiPhaseRenderType
    extends CustomRenderTypes {
        public MultiPhaseRenderType(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, ImmutableList<RenderStateShard> phases) {
            super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, () -> phases.forEach(RenderStateShard::setupRenderState), () -> phases.forEach(RenderStateShard::clearRenderState));
        }
    }
}

