/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.platform.services;

import java.nio.file.Path;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LoadingModList;
import xaero.map.controls.IKeyBindingHelper;
import xaero.map.controls.KeyBindingHelperNeoForge;
import xaero.map.misc.IObfuscatedReflection;
import xaero.map.misc.ObfuscatedReflectionNeoForge;
import xaero.map.platform.services.IPlatformHelper;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    private final ObfuscatedReflectionNeoForge obfuscatedReflectionNeoForge = new ObfuscatedReflectionNeoForge();
    private final KeyBindingHelperNeoForge keyBindingHelperNeoForge = new KeyBindingHelperNeoForge();

    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean checkModForMixin(String modId) {
        return LoadingModList.get().getModFileById(modId) != null;
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public IObfuscatedReflection getObfuscatedFieldReflection() {
        return this.obfuscatedReflectionNeoForge;
    }

    @Override
    public IKeyBindingHelper getKeyBindingHelper() {
        return this.keyBindingHelperNeoForge;
    }

    @Override
    public boolean isDedicatedServer() {
        return FMLLoader.getDist() == Dist.DEDICATED_SERVER;
    }

    @Override
    public Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }
}

