/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.eyes;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import dev.gigaherz.eyes.EyesInTheDarkness;
import dev.gigaherz.eyes.config.BiomeRules;
import dev.gigaherz.eyes.config.ConfigData;
import dev.gigaherz.eyes.config.DimensionRules;
import dev.gigaherz.eyes.entity.EyesEntity;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(value={Dist.CLIENT}, modid="eyesinthedarkness", bus=EventBusSubscriber.Bus.GAME)
public class EyesSpawningManager
implements CustomSpawner {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Stopwatch watch = Stopwatch.createUnstarted();
    private final ServerLevel parent;
    private final ServerChunkCache chunkSource;
    private int cooldown;
    private int ticks;

    @SubscribeEvent
    public static void levelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            level.customSpawners = ImmutableList.builder().addAll((Iterable)level.customSpawners).add((Object)new EyesSpawningManager(level)).build();
        }
    }

    private EyesSpawningManager(ServerLevel world) {
        this.parent = world;
        this.chunkSource = this.parent.getChunkSource();
        this.cooldown = 0;
    }

    public static int getDaysUntilNextHalloween() {
        Calendar nextHalloween;
        Calendar now = Calendar.getInstance();
        if (now.after(nextHalloween = new Calendar.Builder().setDate(now.get(1), 9, 31).setTimeOfDay(23, 59, 59, 999).build())) {
            nextHalloween.add(1, 1);
        }
        return (int)Math.min(ChronoUnit.DAYS.between(now.toInstant(), nextHalloween.toInstant()), 30L);
    }

    public static int getMinutesToMidnight() {
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        if (hour > 12) {
            hour -= 24;
        }
        return Math.abs(hour * 24 + minute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tick(ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        if (level != this.parent) {
            return 0;
        }
        if (--this.cooldown > 0) {
            return 0;
        }
        this.cooldown = 150;
        if (!(spawnEnemies && ConfigData.enableNaturalSpawn && this.parent.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING))) {
            return 0;
        }
        if (!DimensionRules.isDimensionAllowed(this.parent)) {
            return 0;
        }
        try {
            this.watch.start();
            ++this.ticks;
            int daysUntilNextHalloween = EyesSpawningManager.getDaysUntilNextHalloween();
            int minutesToMidnight = EyesSpawningManager.getMinutesToMidnight();
            this.cooldown = this.calculateSpawnCycleInterval(daysUntilNextHalloween, minutesToMidnight);
            int maxTotalEyesPerDimension = this.calculateMaxTotalEyesPerDimension(daysUntilNextHalloween, minutesToMidnight);
            int maxEyesAroundPlayer = this.calculateMaxEyesAroundPlayer(daysUntilNextHalloween, minutesToMidnight);
            int count = this.parent.getEntities((EntityTypeTest)EyesInTheDarkness.EYES.get(), e -> e.countsTowardSpawnCap()).size();
            if (count >= maxTotalEyesPerDimension) {
                int n = 0;
                return n;
            }
            float d = (float)ConfigData.maxEyesSpawnDistance * 1.5f;
            float dSqr = d * d;
            AABB size = AABB.ofSize((Vec3)Vec3.ZERO, (double)d, (double)d, (double)d);
            List players = this.parent.players();
            int wrap = 20;
            int spawned = 0;
            for (ServerPlayer player : players) {
                List entities;
                if ((player.getId() + this.ticks) % wrap != 0 || player.isSpectator() || (entities = this.parent.getEntities((EntityTypeTest)EyesInTheDarkness.EYES.get(), size.move(player.position()), e -> !e.countsTowardSpawnCap() && e.distanceToSqr((Entity)player) <= (double)dSqr)).size() >= maxEyesAroundPlayer) continue;
                spawned += this.spawnOneAround(player.position(), player, ConfigData.maxEyesSpawnDistance);
            }
            int n = spawned;
            return n;
        }
        finally {
            this.watch.stop();
            long us = this.watch.elapsed(TimeUnit.MICROSECONDS);
            if (us > ConfigData.longSpawnCycleWarning) {
                LOGGER.warn("WARNING: Unexpectedly long spawn cycle. It ran for {}ms!", (Object)((double)us / 1000.0));
            }
            this.watch.reset();
        }
    }

    private int calculateSpawnCycleInterval(int daysUntilNextHalloween, int minutesToMidnight) {
        return Math.max(1, this.calculateTimeBasedValueMin(ConfigData.spawnCycleIntervalNormal, ConfigData.spawnCycleIntervalMidnight, ConfigData.spawnCycleIntervalHalloween, daysUntilNextHalloween, minutesToMidnight));
    }

    private int calculateMaxTotalEyesPerDimension(int daysUntilNextHalloween, int minutesToMidnight) {
        return Math.max(1, this.calculateTimeBasedValueMax(ConfigData.maxTotalEyesPerDimensionNormal, ConfigData.maxTotalEyesPerDimensionMidnight, ConfigData.maxTotalEyesPerDimensionHalloween, daysUntilNextHalloween, minutesToMidnight));
    }

    private int calculateMaxEyesAroundPlayer(int daysUntilNextHalloween, int minutesToMidnight) {
        return Math.max(1, this.calculateTimeBasedValueMax(ConfigData.maxEyesAroundPlayerNormal, ConfigData.maxEyesAroundPlayerMidnight, ConfigData.maxEyesAroundPlayerHalloween, daysUntilNextHalloween, minutesToMidnight));
    }

    private int calculateTimeBasedValueMax(int normal, int midnight, int halloween, int daysUntilNextHalloween, int minutesToMidnight) {
        int valueByTime = normal + (midnight - normal) * Math.max(0, 240 - minutesToMidnight) / 240;
        int valueByDate = normal + (halloween - normal) * Math.max(0, 30 - daysUntilNextHalloween) / 30;
        return Math.max(valueByDate, valueByTime);
    }

    private int calculateTimeBasedValueMin(int normal, int midnight, int halloween, int daysUntilNextHalloween, int minutesToMidnight) {
        int valueByTime = normal + (midnight - normal) * Math.max(0, 240 - minutesToMidnight) / 240;
        int valueByDate = normal + (halloween - normal) * Math.max(0, 30 - daysUntilNextHalloween) / 30;
        return Math.min(valueByDate, valueByTime);
    }

    private int spawnOneAround(Vec3 positionVec, ServerPlayer player, float d) {
        float dSqr = d * d;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 100; ++i) {
            EyesEntity entity;
            double sX = (double)((1.0f - 2.0f * this.parent.random.nextFloat()) * d) + positionVec.x();
            double sZ = (double)((1.0f - 2.0f * this.parent.random.nextFloat()) * d) + positionVec.z();
            pos.set(sX, 0.0, sZ);
            int maxY = this.parent.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX(), pos.getZ());
            double sY = Mth.clamp((double)((double)(this.parent.random.nextFloat() * d) + positionVec.y()), (double)0.0, (double)maxY);
            pos.setY((int)sY);
            double pX = (double)pos.getX() + 0.5;
            double pY = pos.getY();
            double pZ = (double)pos.getZ() + 0.5;
            double distanceSq = player.distanceToSqr(pX, pY, pZ);
            if (!(distanceSq < (double)dSqr) || !EyesSpawningManager.isValidSpawnSpot(this.parent, (EntityType)EyesInTheDarkness.EYES.get(), (BlockPos)pos, distanceSq) || (entity = (EyesEntity)((EntityType)EyesInTheDarkness.EYES.get()).create(this.parent, null, (BlockPos)pos, MobSpawnType.NATURAL, false, false)) == null) continue;
            if (entity.checkSpawnRules((LevelAccessor)this.parent, MobSpawnType.NATURAL) && entity.checkSpawnObstruction((LevelReader)this.parent)) {
                this.parent.addFreshEntity((Entity)entity);
                return 1;
            }
            entity.discard();
        }
        return 0;
    }

    private static boolean isValidSpawnSpot(ServerLevel serverWorld, EntityType<?> entityType, BlockPos pos, double sqrDistanceToClosestPlayer) {
        int instantDespawnDistance = entityType.getCategory().getDespawnDistance();
        if (!entityType.canSpawnFarFromPlayer() && sqrDistanceToClosestPlayer > (double)(instantDespawnDistance * instantDespawnDistance)) {
            return false;
        }
        if (!BiomeRules.isBiomeAllowed(serverWorld, (Holder<Biome>)serverWorld.getBiome(pos))) {
            return false;
        }
        return SpawnPlacements.checkSpawnRules(entityType, (ServerLevelAccessor)serverWorld, (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)pos, (RandomSource)serverWorld.random) && serverWorld.noCollision(entityType.getSpawnAABB((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5));
    }
}

