/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.eyes.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.gigaherz.eyes.EyesInTheDarkness;
import dev.gigaherz.eyes.entity.EyesEntity;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import org.joml.Matrix4f;

public class EyesRenderer
extends EntityRenderer<EyesEntity> {
    private static final ResourceLocation TEXTURE = EyesInTheDarkness.location("textures/entity/eyes1.png");
    private final RenderType renderTypeBase = RenderType.entityTranslucentEmissive((ResourceLocation)TEXTURE);
    private final RenderType renderTypeGlow = RenderType.eyes((ResourceLocation)TEXTURE);
    private static final float WIDTH = 0.25f;
    private static final float HEIGHT = 0.09615385f;
    private static final float TEXWIDTH = 0.40625f;
    private static final float TEXHEIGHT = 0.15625f;

    public EyesRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(EyesEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightmapCoords) {
        float mixAlpha;
        BlockPos position = entity.getBlockPosEyes();
        float blockLight = entity.level().getBrightness(LightLayer.BLOCK, position);
        if (entity.level().dimensionType().hasSkyLight()) {
            float skyLight = (float)entity.level().getBrightness(LightLayer.SKY, position) - (1.0f - ((ClientLevel)entity.level()).getSkyDarken(partialTicks)) * 11.0f;
            blockLight = Math.max(blockLight, skyLight);
        }
        if ((mixAlpha = Mth.clamp((float)((8.0f - blockLight) / 8.0f), (float)0.0f, (float)1.0f)) <= 0.0f) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, entity.getEyeHeight(), 0.0f);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        float hoff = this.getBlinkState(entity, partialTicks, 0.15625f);
        float aggro = entity.getAggroLevel();
        float aggroColorAdjust = 1.0f - Mth.clamp((float)aggro, (float)0.0f, (float)1.0f);
        int packedOverlayCoords = OverlayTexture.NO_OVERLAY;
        EyesRenderer.renderEye(poseStack, bufferIn, this.renderTypeBase, packedLightmapCoords, packedOverlayCoords, mixAlpha, aggroColorAdjust, hoff);
        poseStack.translate(0.0f, 0.0f, -0.001f);
        EyesRenderer.renderEye(poseStack, bufferIn, this.renderTypeGlow, 0xF00000, packedOverlayCoords, mixAlpha, aggroColorAdjust, hoff);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightmapCoords);
    }

    private static void renderEye(PoseStack poseStack, MultiBufferSource bufferIn, RenderType renderType, int packedLightmapCoords, int packedOverlayCoords, float mixAlpha, float aggroColorAdjust, float hoff) {
        VertexConsumer buffer = bufferIn.getBuffer(renderType);
        Matrix4f matrix = poseStack.last().pose();
        buffer.addVertex(matrix, -0.25f, -0.09615385f, 0.0f).setColor(1.0f, aggroColorAdjust, aggroColorAdjust, mixAlpha).setUv(0.0f, hoff + 0.15625f).setOverlay(packedOverlayCoords).setLight(packedLightmapCoords).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(matrix, -0.25f, 0.09615385f, 0.0f).setColor(1.0f, aggroColorAdjust, aggroColorAdjust, mixAlpha).setUv(0.0f, hoff).setOverlay(packedOverlayCoords).setLight(packedLightmapCoords).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(matrix, 0.25f, 0.09615385f, 0.0f).setColor(1.0f, aggroColorAdjust, aggroColorAdjust, mixAlpha).setUv(0.40625f, hoff).setOverlay(packedOverlayCoords).setLight(packedLightmapCoords).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(matrix, 0.25f, -0.09615385f, 0.0f).setColor(1.0f, aggroColorAdjust, aggroColorAdjust, mixAlpha).setUv(0.40625f, hoff + 0.15625f).setOverlay(packedOverlayCoords).setLight(packedLightmapCoords).setNormal(0.0f, 0.0f, 1.0f);
    }

    private float getBlinkState(EyesEntity entity, float partialTicks, float th) {
        float hoff = 0.0f;
        if (entity.blinkingState) {
            int half_blink = 2;
            hoff = entity.blinkProgress < half_blink ? (float)Mth.floor((float)(((float)entity.blinkProgress + partialTicks) * 4.0f / (float)half_blink)) * th : (float)Math.max(0, 8 - Mth.floor((float)(((float)entity.blinkProgress + partialTicks) * 4.0f / (float)half_blink))) * th;
        }
        return hoff;
    }

    public ResourceLocation getTextureLocation(EyesEntity entity) {
        return TEXTURE;
    }
}

