/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.eyes.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.gigaherz.eyes.EyesInTheDarkness;
import dev.gigaherz.eyes.config.ConfigData;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT}, modid="eyesinthedarkness", bus=EventBusSubscriber.Bus.MOD)
public class JumpscareOverlay
implements LayeredDraw.Layer {
    private static final ResourceLocation TEXTURE_EYES = EyesInTheDarkness.location("textures/entity/eyes2.png");
    private static final ResourceLocation TEXTURE_FLASH = EyesInTheDarkness.location("textures/creepy.png");
    public static JumpscareOverlay INSTANCE = new JumpscareOverlay();
    private static final Rect2i[] FRAMES = new Rect2i[]{new Rect2i(0, 0, 13, 6), new Rect2i(0, 7, 13, 6), new Rect2i(0, 14, 13, 6), new Rect2i(0, 21, 13, 6), new Rect2i(15, 1, 15, 8), new Rect2i(15, 16, 15, 12)};
    private static final int ANIMATION_APPEAR = 10;
    private static final int ANIMATION_LINGER = 90;
    private static final int ANIMATION_BLINK = 60;
    private static final int ANIMATION_SCARE1 = 20;
    private static final int ANIMATION_FADE = 20;
    private static final int ANIMATION_BLINK_START = 100;
    private static final int ANIMATION_SCARE_START = 160;
    private static final int ANIMATION_FADE_START = 180;
    private static final int ANIMATION_TOTAL = 200;
    private final Minecraft mc = Minecraft.getInstance();
    private boolean visible = false;
    private float progress = 0.0f;

    @SubscribeEvent
    public static void register(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.CAMERA_OVERLAYS, EyesInTheDarkness.location("jumpscare"), (LayeredDraw.Layer)INSTANCE);
    }

    private JumpscareOverlay() {
        NeoForge.EVENT_BUS.addListener(this::clientTick);
    }

    public void show(double ex, double ey, double ez) {
        if (ConfigData.jumpscareClient) {
            this.visible = true;
            this.mc.level.playLocalSound(ex, ey, ez, (SoundEvent)EyesInTheDarkness.EYES_JUMPSCARE.get(), SoundSource.HOSTILE, this.getJumpscareVolume(), 1.0f, false);
        }
    }

    protected float getJumpscareVolume() {
        return (float)ConfigData.eyeIdleVolume;
    }

    public void clientTick(ClientTickEvent.Pre event) {
        if (this.visible) {
            this.progress += 1.0f;
            if (this.progress >= 200.0f) {
                this.visible = false;
                this.progress = 0.0f;
            }
        }
    }

    public void render(GuiGraphics graphics, DeltaTracker partialTicks) {
        if (!this.visible) {
            return;
        }
        int screenWidth = this.mc.getWindow().getGuiScaledWidth();
        int screenHeight = this.mc.getWindow().getGuiScaledHeight();
        float time = this.progress + partialTicks.getGameTimeDeltaPartialTick(true);
        if (time >= 200.0f) {
            this.visible = false;
            this.progress = 0.0f;
            return;
        }
        PoseStack poseStack = graphics.pose();
        RenderSystem.clear((int)256, (boolean)false);
        poseStack.pushPose();
        float darkening = Mth.clamp((float)Math.min(time / 10.0f, (200.0f - time) / 20.0f), (float)0.0f, (float)1.0f);
        boolean showCreep = false;
        int blinkstate = 0;
        if (time >= 100.0f) {
            if (time >= 160.0f) {
                blinkstate = 1;
                showCreep = time - 160.0f > 20.0f;
            } else {
                float fade = Math.max(0.0f, (time - 100.0f) / 60.0f);
                float blinkspeed = (float)(1.0 + Math.pow(fade, 3.0));
                blinkstate = Mth.floor((float)(20.0f * blinkspeed)) & 1;
                showCreep = blinkstate == 1;
            }
        }
        int alpha = Mth.floor((float)(darkening * 255.0f));
        if (showCreep) {
            int texW = 2048;
            int texH = 1024;
            float scale1 = (float)screenHeight / (float)texH;
            int drawY = 0;
            int drawH = screenHeight;
            int drawW = Mth.floor((float)((float)texW * scale1));
            int drawX = (screenWidth - drawW) / 2;
            this.drawScaledCustomTexture(TEXTURE_FLASH, poseStack, texW, texH, 0, 0, texW, texH, drawX, drawY, drawW, drawH, alpha << 24 | 0xFFFFFF);
        } else {
            graphics.fill(0, 0, screenWidth, screenHeight, alpha << 24);
        }
        if (blinkstate != 1) {
            float scale = Float.MAX_VALUE;
            for (Rect2i r : FRAMES) {
                float s = Math.min(Mth.floor((double)((double)screenWidth * 0.8 / (double)r.getWidth())), Mth.floor((double)((double)screenHeight * 0.8 / (double)r.getHeight())));
                scale = Math.min(scale, s);
            }
            scale = Math.min(1.0f, (1.0f + time) / 11.0f) * scale;
            int currentFrame = Math.min(FRAMES.length - 1, Mth.floor((float)((float)FRAMES.length * time / 10.0f)));
            Rect2i rect = FRAMES[currentFrame];
            int tx = rect.getX();
            int ty = rect.getY();
            int tw = rect.getWidth();
            int th = rect.getHeight();
            float drawW = (float)tw * scale;
            float drawH = (float)th * scale;
            float drawX = ((float)screenWidth - drawW) / 2.0f;
            float drawY = ((float)screenHeight - drawH) / 2.0f;
            float texW = 32.0f;
            float texH = 32.0f;
            this.drawScaledCustomTexture(TEXTURE_EYES, poseStack, texW, texH, tx, ty, tw, th, drawX, drawY, drawW, drawH);
        }
        poseStack.popPose();
    }

    private void drawScaledCustomTexture(ResourceLocation tex, PoseStack poseStack, float texW, float texH, int tx, int ty, int tw, int th, float targetX, float targetY, float targetW, float targetH) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex);
        Matrix4f matrix = poseStack.last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(matrix, targetX, targetY, 0.0f).setUv((float)tx / texW, (float)ty / texH);
        buffer.addVertex(matrix, targetX, targetY + targetH, 0.0f).setUv((float)tx / texW, (float)(ty + th) / texH);
        buffer.addVertex(matrix, targetX + targetW, targetY + targetH, 0.0f).setUv((float)(tx + tw) / texW, (float)(ty + th) / texH);
        buffer.addVertex(matrix, targetX + targetW, targetY, 0.0f).setUv((float)(tx + tw) / texW, (float)ty / texH);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    private void drawScaledCustomTexture(ResourceLocation tex, PoseStack poseStack, float texW, float texH, int tx, int ty, int tw, int th, float targetX, float targetY, float targetW, float targetH, int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex);
        Matrix4f matrix = poseStack.last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        buffer.addVertex(matrix, targetX, targetY, 0.0f).setUv((float)tx / texW, (float)ty / texH).setColor(r, g, b, a);
        buffer.addVertex(matrix, targetX, targetY + targetH, 0.0f).setUv((float)tx / texW, (float)(ty + th) / texH).setColor(r, g, b, a);
        buffer.addVertex(matrix, targetX + targetW, targetY + targetH, 0.0f).setUv((float)(tx + tw) / texW, (float)(ty + th) / texH).setColor(r, g, b, a);
        buffer.addVertex(matrix, targetX + targetW, targetY, 0.0f).setUv((float)(tx + tw) / texW, (float)ty / texH).setColor(r, g, b, a);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }
}

