/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.eyes.config;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import org.slf4j.Logger;

public class BiomeRules {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final AtomicReference<List<Rule>> rules = new AtomicReference(new ArrayList());

    static void parseRules(List<? extends String> dimensionRules) {
        ArrayList<Rule> list = new ArrayList<Rule>();
        dimensionRules.forEach(r -> {
            Rule parse = BiomeRules.parse(r);
            if (parse != null) {
                list.add(parse);
            }
        });
        list.add(BiomeRules.disallowVoidBiomes());
        rules.set(list);
    }

    public static boolean isBiomeAllowed(ServerLevel level, Holder<Biome> key) {
        for (Rule rule : rules.get()) {
            if (!rule.test(level, key)) continue;
            return rule.allow;
        }
        return true;
    }

    @Nullable
    private static Rule parse(String rule) {
        boolean allow = true;
        if (rule.startsWith("!")) {
            allow = false;
            rule = rule.substring(1);
        }
        if (rule.startsWith("#") || rule.startsWith("$")) {
            return new Rule(allow, null, rule.substring(1));
        }
        if (rule.equals("*")) {
            return new Rule(allow, null, null);
        }
        return new Rule(allow, rule, null);
    }

    private static Rule disallowVoidBiomes() {
        return new Rule(false, null, "forge:is_void");
    }

    private static class Rule {
        public final boolean allow;
        public final ResourceLocation registryName;
        public final TagKey<Biome> tagKey;

        private Rule(boolean allow, @Nullable String registryName, @Nullable String tagName) {
            this.allow = allow;
            this.registryName = registryName != null ? ResourceLocation.parse((String)registryName) : null;
            this.tagKey = tagName != null ? TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)tagName)) : null;
        }

        public boolean test(ServerLevel level, Holder<Biome> biome) {
            if (this.registryName != null) {
                ResourceLocation name = (ResourceLocation)biome.unwrap().map(ResourceKey::location, b -> level.registryAccess().registryOrThrow(Registries.BIOME).getKey(b));
                return this.registryName.equals((Object)name);
            }
            if (this.tagKey != null) {
                return biome.is(this.tagKey);
            }
            return true;
        }
    }
}

