/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.eyes.config;

import com.google.common.collect.Lists;
import dev.gigaherz.eyes.config.BiomeRules;
import dev.gigaherz.eyes.config.DimensionRules;
import dev.gigaherz.eyes.entity.EyesEntity;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigData {
    private static final ServerConfig SERVER;
    public static final ModConfigSpec SERVER_SPEC;
    private static final ClientConfig CLIENT;
    public static final ModConfigSpec CLIENT_SPEC;
    public static boolean jumpscare;
    public static int jumpscareHurtLevel;
    public static boolean eyesCanAttackWhileLit;
    public static boolean enableEyeAggressionEscalation;
    public static boolean eyeAggressionDependsOnLocalDifficulty;
    public static boolean eyeAggressionDependsOnLightLevel;
    public static double eyeIdleVolume;
    public static double eyeDisappearVolume;
    public static double eyeJumpscareVolume;
    public static boolean enableNaturalSpawn;
    public static int maxEyesSpawnDistance;
    public static int spawnCycleIntervalNormal;
    public static int maxEyesAroundPlayerNormal;
    public static int maxTotalEyesPerDimensionNormal;
    public static int spawnCycleIntervalMidnight;
    public static int maxEyesAroundPlayerMidnight;
    public static int maxTotalEyesPerDimensionMidnight;
    public static int spawnCycleIntervalHalloween;
    public static int maxEyesAroundPlayerHalloween;
    public static int maxTotalEyesPerDimensionHalloween;
    public static double speedNoAggro;
    public static double speedFullAggro;
    public static long longSpawnCycleWarning;
    public static boolean jumpscareClient;

    @Nonnull
    private static <T> T orDefault(@Nullable T value, @Nonnull Supplier<T> defaultSupplier) {
        if (value != null) {
            return value;
        }
        return defaultSupplier.get();
    }

    public static boolean canEyesSpawnAt(EntityType<EyesEntity> entityType, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return Monster.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ModConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ModConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
    }

    private static class ServerConfig {
        public final ModConfigSpec.BooleanValue jumpscare;
        public final ModConfigSpec.IntValue jumpscareHurtLevel;
        public final ModConfigSpec.BooleanValue eyesCanAttackWhileLit;
        public final ModConfigSpec.BooleanValue enableEyeAggressionEscalation;
        public final ModConfigSpec.BooleanValue eyeAggressionDependsOnLocalDifficulty;
        public final ModConfigSpec.BooleanValue eyeAggressionDependsOnLightLevel;
        public final ModConfigSpec.DoubleValue eyeIdleVolume;
        public final ModConfigSpec.DoubleValue eyeDisappearVolume;
        public final ModConfigSpec.DoubleValue eyeJumpscareVolume;
        public final ModConfigSpec.ConfigValue<List<? extends String>> biomeRules;
        public final ModConfigSpec.ConfigValue<List<? extends String>> dimensionRules;
        public final ModConfigSpec.BooleanValue enableNaturalSpawn;
        public final ModConfigSpec.IntValue maxEyesSpawnDistance;
        public final ModConfigSpec.IntValue spawnCycleIntervalNormal;
        public final ModConfigSpec.IntValue maxEyesAroundPlayerNormal;
        public final ModConfigSpec.IntValue maxTotalEyesPerDimensionNormal;
        public final ModConfigSpec.IntValue spawnCycleIntervalMidnight;
        public final ModConfigSpec.IntValue maxEyesAroundPlayerMidnight;
        public final ModConfigSpec.IntValue maxTotalEyesPerDimensionMidnight;
        public final ModConfigSpec.IntValue spawnCycleIntervalHalloween;
        public final ModConfigSpec.IntValue maxEyesAroundPlayerHalloween;
        public final ModConfigSpec.IntValue maxTotalEyesPerDimensionHalloween;
        public final ModConfigSpec.DoubleValue speedNoAggro;
        public final ModConfigSpec.DoubleValue speedFullAggro;
        public final ModConfigSpec.LongValue longSpawnCycleWarning;

        ServerConfig(ModConfigSpec.Builder builder) {
            builder.push("general");
            this.jumpscare = builder.comment("Set to false to disable the jumpscare system.").define("Jumpscare", true);
            this.jumpscareHurtLevel = builder.comment("Set to a number > 0 to cause the jumpscare to apply poison the player. A value of 5 will take around half of the health. ").defineInRange("JumpscareHurtLevel", 1, 0, 6);
            this.eyesCanAttackWhileLit = builder.comment("While set to true, the eyes entity will ignore the artificial light level and will jumpscare even if it's lit. Daylight will still disable it's AI.").define("EyesCanAttackWhileLit", true);
            this.speedNoAggro = builder.comment("The speed at which the eyes move, when not aggressive.").defineInRange("SpeedNoAggro", (double)0.1f, 0.0, Double.MAX_VALUE);
            this.speedFullAggro = builder.comment("The speed at which the eyes move when aggressive.").defineInRange("SpeedFullAggro", 0.5, 0.0, Double.MAX_VALUE);
            this.longSpawnCycleWarning = builder.comment("The time the spawn cycle can take before a warning is printed to the log. In Microseconds. Default = 50ms").defineInRange("LongSpawnCycleWarning", 50000L, 0L, Long.MAX_VALUE);
            builder.pop();
            builder.push("eye_aggression");
            this.enableEyeAggressionEscalation = builder.comment("While set to true, the eyes entities will progressively get more bold, and move faster, the longer they live.").define("EnableEscalation", true);
            this.eyeAggressionDependsOnLocalDifficulty = builder.comment("While set to true, the eyes entities will spawn with higher aggresion levels in higher local difficulties.").define("LocalDifficulty", true);
            this.eyeAggressionDependsOnLightLevel = builder.comment("While set to true, the eyes entities will have higher aggression values on lower light levels.").define("LightLevel", true);
            builder.pop();
            builder.push("sound_volumes");
            this.eyeIdleVolume = builder.comment("Changes the volume of the idle sounds, relative to the volume of the hostile mob category.").defineInRange("IdleNoiseVolume", 1.0, 0.0, 1.0);
            this.eyeDisappearVolume = builder.comment("Changes the volume of the death/disappear sounds, relative to the volume of the hostile mob category.").defineInRange("DisappearNoiseVolume", 1.0, 0.0, 1.0);
            this.eyeJumpscareVolume = builder.comment("Changes the volume of the jumpscare sounds, relative to the volume of the hostile mob category.").defineInRange("JumpscareVolume", 1.0, 0.0, 1.0);
            builder.pop();
            builder.push("spawning");
            this.enableNaturalSpawn = builder.comment("If false, the eyes entity will not spawn naturally during the night.").define("EnableNaturalSpawn", true);
            this.maxEyesSpawnDistance = builder.comment("Max block distance from a player at which the eyes will spawn.").defineInRange("MaxEyesSpawnDistance", 64, 1, Integer.MAX_VALUE);
            this.biomeRules = builder.comment(new String[]{"Specifies rules for accepting or rejecting biomes.", "The rules are scanned one by one until a rule matches, This means the first rule to match takes precedence over any other subsequent rule, so more specific rules should go first.", "Rules:", "  \"biome:name\"    -- ALLOWS spawning in the given biome.", "  \"!biome:name\"   -- DISALLOWS spawning in the given biome.", "  \"#biome_label\"  -- ALLOWS spawning in the given biome tag.", "  \"!#biome_label\" -- DISALLOWS spawning in the given biome tag.", "  \"!*\"            -- DISALLOWS spawning unconditionally. Place this at the end of the list to disable spawning if no other rules pass (defaults to allow otherwise).", "Examples:", "  To disable spawning in the end: [ \"!#minecraft:is_end\" ]", "  To disable spawning in the nether biome: [ \"!minecraft:nether\" ]", "  To disable spawning in forest areas, but allow them in dark fores: [ \"minecraft:dark_forest\", \"!#minecraft:is_forest\" ]"}).defineList("BiomeRules", (List)Lists.newArrayList(), o -> o instanceof String);
            this.dimensionRules = builder.comment(new String[]{"Specifies rules for accepting or rejecting dimensions.", "The rules are scanned one by one until a rule matches, This means the first rule to match takes precedence over any other subsequent rule, so more specific rules should go first.", "Rules:", "  \"dimension:name\"   -- ALLOWS spawning in the given dimension.", "  \"!dimension:name\"  -- DISALLOWS spawning in the given dimension.", "  \"#dimension:type\"  -- ALLOWS spawning in any dimension with the given dimension type.", "  \"!#dimension:type\" -- DISALLOWS spawning in any dimension with the given dimension type.", "  \"!*\"               -- DISALLOWS spawning unconditionally. Place this at the end of the list to disable spawning if no other rules pass (defaults to allow otherwise).", "Examples:", "  To disable spawning in the end dimension: [ \"!minecraft:the_end\" ]", "  To disable spawning in the nether dimension: [ \"!minecraft:nether\" ]", "  To disable spawning in all secondary overworlds, but allow the vanilla overworld: [ \"minecraft:overworld\", \"!#minecraft:overworld\" ]"}).defineList("DimensionRules", (List)Lists.newArrayList(), o -> o instanceof String);
            builder.pop();
            builder.comment("Default spawn settings").push("spawning_normal");
            this.spawnCycleIntervalNormal = builder.comment("Number of ticks between spawn cycles.").defineInRange("SpawnCycleInterval", 150, 1, Integer.MAX_VALUE);
            this.maxEyesAroundPlayerNormal = builder.comment("Max number of eyes entities that will spawn around any one player.").defineInRange("MaxEyesAroundPlayer", 2, 1, Integer.MAX_VALUE);
            this.maxTotalEyesPerDimensionNormal = builder.comment("Max number of eyes entities that will spawn in each dimension.").defineInRange("MaxTotalEyesPerDimension", 15, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Spawn settings in the minutes around midnight").push("spawning_midnight");
            this.spawnCycleIntervalMidnight = builder.comment("Number of ticks between spawn cycles.").defineInRange("SpawnCycleInterval", 50, 1, Integer.MAX_VALUE);
            this.maxEyesAroundPlayerMidnight = builder.comment("Max number of eyes entities that will spawn around any one player.").defineInRange("MaxEyesAroundPlayer", 3, 1, Integer.MAX_VALUE);
            this.maxTotalEyesPerDimensionMidnight = builder.comment("Max number of eyes entities that will spawn in each dimension.").defineInRange("MaxTotalEyesPerDimension", 15, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Spawn settings in the days leading to halloween").push("spawning_halloween");
            this.spawnCycleIntervalHalloween = builder.comment("Number of ticks between spawn cycles.").defineInRange("SpawnCycleInterval", 50, 1, Integer.MAX_VALUE);
            this.maxEyesAroundPlayerHalloween = builder.comment("Max number of eyes entities that will spawn around any one player.").defineInRange("MaxEyesAroundPlayer", 5, 1, Integer.MAX_VALUE);
            this.maxTotalEyesPerDimensionHalloween = builder.comment("Max number of eyes entities that will spawn in each dimension.").defineInRange("MaxTotalEyesPerDimension", 25, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    private static class ClientConfig {
        public final ModConfigSpec.BooleanValue jumpscare;

        ClientConfig(ModConfigSpec.Builder builder) {
            builder.push("general");
            this.jumpscare = builder.comment("Set to false to prevent jumpscares from displaying client-side.\nNOTE: Jumpscare effects such as poison still apply, this only prevents the visual and sound.").define("jumpscare", true);
            builder.pop();
        }
    }

    @EventBusSubscriber(modid="eyesinthedarkness", bus=EventBusSubscriber.Bus.MOD)
    private static class ModEventHandler {
        private ModEventHandler() {
        }

        @SubscribeEvent
        public static void configLoading(ModConfigEvent.Loading event) {
            ModEventHandler.refreshConfig((ModConfigEvent)event);
        }

        @SubscribeEvent
        public static void configReloading(ModConfigEvent.Reloading event) {
            ModEventHandler.refreshConfig((ModConfigEvent)event);
        }

        private static void refreshConfig(ModConfigEvent event) {
            ModConfig config = event.getConfig();
            if (config.getSpec() == SERVER_SPEC) {
                jumpscare = (Boolean)ConfigData.SERVER.jumpscare.get();
                jumpscareHurtLevel = (Integer)ConfigData.SERVER.jumpscareHurtLevel.get();
                eyesCanAttackWhileLit = (Boolean)ConfigData.SERVER.eyesCanAttackWhileLit.get();
                enableEyeAggressionEscalation = (Boolean)ConfigData.SERVER.enableEyeAggressionEscalation.get();
                eyeAggressionDependsOnLocalDifficulty = (Boolean)ConfigData.SERVER.eyeAggressionDependsOnLocalDifficulty.get();
                eyeAggressionDependsOnLightLevel = (Boolean)ConfigData.SERVER.eyeAggressionDependsOnLightLevel.get();
                eyeIdleVolume = (Double)ConfigData.SERVER.eyeIdleVolume.get();
                eyeDisappearVolume = (Double)ConfigData.SERVER.eyeDisappearVolume.get();
                eyeJumpscareVolume = (Double)ConfigData.SERVER.eyeJumpscareVolume.get();
                enableNaturalSpawn = (Boolean)ConfigData.SERVER.enableNaturalSpawn.get();
                maxEyesSpawnDistance = (Integer)ConfigData.SERVER.maxEyesSpawnDistance.get();
                spawnCycleIntervalNormal = (Integer)ConfigData.SERVER.spawnCycleIntervalNormal.get();
                maxEyesAroundPlayerNormal = (Integer)ConfigData.SERVER.maxEyesAroundPlayerNormal.get();
                maxTotalEyesPerDimensionNormal = (Integer)ConfigData.SERVER.maxTotalEyesPerDimensionNormal.get();
                spawnCycleIntervalMidnight = (Integer)ConfigData.SERVER.spawnCycleIntervalMidnight.get();
                maxEyesAroundPlayerMidnight = (Integer)ConfigData.SERVER.maxEyesAroundPlayerMidnight.get();
                maxTotalEyesPerDimensionMidnight = (Integer)ConfigData.SERVER.maxTotalEyesPerDimensionMidnight.get();
                spawnCycleIntervalHalloween = (Integer)ConfigData.SERVER.spawnCycleIntervalHalloween.get();
                maxEyesAroundPlayerHalloween = (Integer)ConfigData.SERVER.maxEyesAroundPlayerHalloween.get();
                maxTotalEyesPerDimensionHalloween = (Integer)ConfigData.SERVER.maxTotalEyesPerDimensionHalloween.get();
                speedNoAggro = (Double)ConfigData.SERVER.speedNoAggro.get();
                speedFullAggro = (Double)ConfigData.SERVER.speedFullAggro.get();
                longSpawnCycleWarning = (Long)ConfigData.SERVER.longSpawnCycleWarning.get();
                List biomeRules = ConfigData.orDefault((List)ConfigData.SERVER.biomeRules.get(), Collections::emptyList);
                List dimensionRules = ConfigData.orDefault((List)ConfigData.SERVER.dimensionRules.get(), Collections::emptyList);
                BiomeRules.parseRules(biomeRules);
                DimensionRules.parseRules(dimensionRules);
            }
            if (config.getSpec() == CLIENT_SPEC) {
                jumpscareClient = (Boolean)ConfigData.CLIENT.jumpscare.get();
            }
        }
    }
}

