/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.eyes.entity;

import dev.gigaherz.eyes.EyesInTheDarkness;
import dev.gigaherz.eyes.InitiateJumpscarePacket;
import dev.gigaherz.eyes.config.ConfigData;
import java.util.EnumSet;
import java.util.List;
import java.util.function.DoubleSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class EyesEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> IS_DORMANT = SynchedEntityData.defineId(EyesEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> AGGRO = SynchedEntityData.defineId(EyesEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final float AGGRO_ESCALATION_PER_TICK = 1.6666666E-4f;
    public static final int BLINK_DURATION = 5;
    public boolean blinkingState;
    public int blinkProgress;

    public EyesEntity(EntityType<? extends EyesEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 1.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(AGGRO, (Object)Float.valueOf(0.1f));
        builder.define(IS_DORMANT, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.1));
        this.goalSelector.addGoal(8, (Goal)new CreepTowardPlayer(this, this::getSpeedFromAggro));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public float getAggroLevel() {
        return ((Float)this.getEntityData().get(AGGRO)).floatValue();
    }

    public void setAggroLevel(float aggro) {
        this.getEntityData().set(AGGRO, (Object)Float.valueOf(Mth.clamp((float)aggro, (float)0.0f, (float)1.0f)));
    }

    public boolean getIsDormant() {
        return (Boolean)this.getEntityData().get(IS_DORMANT);
    }

    public void setIsDormant(boolean value) {
        this.getEntityData().set(IS_DORMANT, (Object)value);
    }

    private double getSpeedFromAggro() {
        if (this.getIsDormant()) {
            return 0.0;
        }
        return Mth.clampedLerp((double)this.getAggroLevel(), (double)ConfigData.speedNoAggro, (double)ConfigData.speedFullAggro);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (ConfigData.eyeAggressionDependsOnLocalDifficulty) {
            float difficulty = difficultyInstance.getSpecialMultiplier();
            this.setAggroLevel(this.level().random.nextFloat() * difficulty);
        }
        return super.finalizeSpawn(level, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
    }

    public boolean doHurtTarget(Entity entityIn) {
        boolean jumpScared;
        boolean bl = jumpScared = ConfigData.jumpscare && entityIn instanceof ServerPlayer;
        if (jumpScared) {
            this.jumpscare((ServerPlayer)entityIn);
        }
        if (ConfigData.jumpscareHurtLevel > 0 && entityIn instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entityIn;
            living.addEffect(new MobEffectInstance(MobEffects.POISON, 100, ConfigData.jumpscareHurtLevel - 1));
        }
        this.disappear(!jumpScared);
        return true;
    }

    public void jumpscare(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new InitiateJumpscarePacket(this.getX(), this.getY(), this.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide) {
            if (this.getIsDormant()) {
                return;
            }
            if (!this.blinkingState) {
                if (this.level().random.nextFloat() < 0.02f) {
                    this.blinkingState = true;
                    this.blinkProgress = 0;
                }
            } else {
                ++this.blinkProgress;
                if (this.blinkProgress >= 5) {
                    this.blinkingState = false;
                }
            }
            return;
        }
        this.setIsDormant(this.isIlluminated(ConfigData.eyesCanAttackWhileLit));
        if (this.getIsDormant()) {
            return;
        }
        float maxWatchDistance = 16.0f;
        Vec3 eyes = this.getEyePosition(1.0f);
        List entities = this.level().getEntitiesOfClass(Player.class, new AABB(eyes.x - (double)maxWatchDistance, eyes.y - (double)maxWatchDistance, eyes.z - (double)maxWatchDistance, eyes.x + (double)maxWatchDistance, eyes.y + (double)maxWatchDistance, eyes.z + (double)maxWatchDistance), player -> {
            if (player.isSpectator() || !player.isAlive()) {
                return false;
            }
            if (player.getEyePosition(1.0f).distanceTo(eyes) > (double)maxWatchDistance) {
                return false;
            }
            Vec3 vec3d = player.getViewVector(1.0f).normalize();
            Vec3 vec3d1 = new Vec3(this.getX() - player.getX(), this.getBoundingBox().minY + (double)this.getEyeHeight() - (player.getY() + (double)player.getEyeHeight()), this.getZ() - player.getZ());
            double d0 = vec3d1.length();
            double d1 = vec3d.dot(vec3d1 = vec3d1.normalize());
            return d1 > 1.0 - 0.025 / d0 && player.hasLineOfSight((Entity)this);
        });
        if (entities.size() > 0) {
            this.disappear(true);
            return;
        }
        if (ConfigData.enableEyeAggressionEscalation && !this.getIsDormant()) {
            this.setAggroLevel(this.getAggroLevel() + 1.6666666E-4f);
        }
    }

    public boolean isInvertedHealAndHarm() {
        return true;
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public void push(Entity entityIn) {
    }

    protected void doPush(Entity entityIn) {
        if (this.getIsDormant()) {
            return;
        }
        if (entityIn instanceof Player) {
            this.disappear(true);
        }
    }

    private void disappear(boolean playDeathSound) {
        this.hurt(this.damageSources().generic(), 1.0f);
        if (playDeathSound) {
            this.playSound(this.getDeathSound(), this.getDisappearVolume(), this.getVoicePitch());
        }
    }

    protected float getSoundVolume() {
        return super.getSoundVolume() * (float)ConfigData.eyeIdleVolume;
    }

    protected float getDisappearVolume() {
        return super.getSoundVolume() * (float)ConfigData.eyeDisappearVolume;
    }

    protected void pushEntities() {
        super.pushEntities();
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    protected void tickDeath() {
        this.deathTime = 19;
        super.tickDeath();
    }

    @javax.annotation.Nullable
    protected SoundEvent getAmbientSound() {
        if (this.tickCount == 0 || this.getIsDormant()) {
            return null;
        }
        return (SoundEvent)EyesInTheDarkness.EYES_LAUGH.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)EyesInTheDarkness.EYES_DISAPPEAR.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)EyesInTheDarkness.EYES_DISAPPEAR.get();
    }

    public BlockPos getBlockPosEyes() {
        return BlockPos.containing((double)this.getX(), (double)(this.getY() + (double)this.getEyeHeight()), (double)this.getZ());
    }

    public float getSunBrightness() {
        float angleRadians = this.level().getSunAngle(1.0f);
        float f1 = 1.0f - (Mth.cos((float)angleRadians) * 2.0f + 0.2f);
        f1 = Mth.clamp((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(this.level().getRainLevel(1.0f) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(this.level().getThunderLevel(1.0f) * 5.0f) / 16.0));
        return f1 * 0.8f + 0.2f;
    }

    private float getLightLevel(boolean excludeDaylight) {
        BlockPos position = this.getBlockPosEyes();
        float blockLight = 0.0f;
        if (excludeDaylight) {
            if (this.level().dimensionType().hasSkyLight()) {
                float skyLight1;
                float skyLight = (float)this.level().getBrightness(LightLayer.SKY, position) - (1.0f - this.getSunBrightness()) * 11.0f;
                if (skyLight != (skyLight1 = (float)(this.level().getBrightness(LightLayer.SKY, position) - this.level().getSkyDarken()))) {
                    // empty if block
                }
                blockLight = Math.max(blockLight, skyLight);
            }
        } else {
            blockLight = this.level().getMaxLocalRawBrightness(position);
        }
        return blockLight;
    }

    private boolean isIlluminated(boolean excludeDaylight) {
        float blockLight = this.getLightLevel(excludeDaylight);
        return blockLight >= 8.0f;
    }

    public boolean countsTowardSpawnCap() {
        return this.requiresCustomPersistence() || this.isPersistenceRequired();
    }

    private static class CreepTowardPlayer
    extends Goal {
        protected final PathfinderMob attacker;
        private final EyesEntity eyes;
        private final DoubleSupplier speedGetter;
        protected int attackTick;
        private Path path;
        private int delayCounter;
        private double targetX;
        private double targetY;
        private double targetZ;

        public CreepTowardPlayer(EyesEntity creature, DoubleSupplier speedGetter) {
            this.attacker = creature;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.speedGetter = speedGetter;
            this.eyes = creature;
        }

        public boolean canUse() {
            if (this.eyes.getIsDormant()) {
                return false;
            }
            LivingEntity targetPlayer = this.attacker.getTarget();
            if (targetPlayer == null || !targetPlayer.isAlive()) {
                return false;
            }
            if (this.isPlayerLookingInMyGeneralDirection()) {
                return false;
            }
            this.path = this.attacker.getNavigation().createPath((Entity)targetPlayer, 0);
            return this.path != null || this.isWithinRange(targetPlayer);
        }

        public void start() {
            this.attacker.getNavigation().moveTo(this.path, this.speedGetter.getAsDouble());
            this.attacker.setAggressive(true);
            this.delayCounter = 0;
        }

        public boolean canContinueToUse() {
            if (this.eyes.getIsDormant()) {
                return false;
            }
            if (this.isPlayerLookingInMyGeneralDirection()) {
                return false;
            }
            LivingEntity livingentity = this.attacker.getTarget();
            if (livingentity == null || !livingentity.isAlive()) {
                return false;
            }
            return !this.attacker.getNavigation().isDone();
        }

        private boolean isWithinRange(LivingEntity targetPlayer) {
            return this.getAttackReachSqr(targetPlayer) >= this.attacker.distanceToSqr(targetPlayer.getX(), targetPlayer.getBoundingBox().minY, targetPlayer.getZ());
        }

        private boolean isPlayerLookingInMyGeneralDirection() {
            if (this.eyes.getIsDormant()) {
                return false;
            }
            Vec3 selfPos = this.eyes.position();
            LivingEntity target = this.eyes.getTarget();
            if (target == null) {
                return false;
            }
            Vec3 playerPos = target.position();
            Vec3 lookVec = target.getLookAngle();
            Vec3 playerLook = new Vec3(lookVec.x, lookVec.y, lookVec.z);
            playerLook.normalize();
            playerPos.subtract(selfPos);
            playerPos.normalize();
            return playerLook.dot(playerPos) < 0.0;
        }

        public void stop() {
            LivingEntity livingentity = this.attacker.getTarget();
            if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
                this.attacker.setTarget(null);
            }
            this.attacker.setAggressive(false);
            this.attacker.getNavigation().stop();
        }

        public void tick() {
            LivingEntity targetPlayer = this.attacker.getTarget();
            this.attacker.getLookControl().setLookAt((Entity)targetPlayer, 30.0f, 30.0f);
            double distanceSquared = this.attacker.distanceToSqr(targetPlayer.getX(), targetPlayer.getBoundingBox().minY, targetPlayer.getZ());
            --this.delayCounter;
            if (this.attacker.getSensing().hasLineOfSight((Entity)targetPlayer) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || targetPlayer.distanceToSqr(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.getRandom().nextFloat() < 0.05f)) {
                this.targetX = targetPlayer.getX();
                this.targetY = targetPlayer.getBoundingBox().minY;
                this.targetZ = targetPlayer.getZ();
                this.delayCounter = 4 + this.attacker.getRandom().nextInt(7);
                if (distanceSquared > 1024.0) {
                    this.delayCounter += 10;
                } else if (distanceSquared > 256.0) {
                    this.delayCounter += 5;
                }
                if (!this.attacker.getNavigation().moveTo((Entity)targetPlayer, this.speedGetter.getAsDouble())) {
                    this.delayCounter += 15;
                }
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            this.checkAndPerformAttack(targetPlayer, distanceSquared);
        }

        protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
            double reachSqr = this.getAttackReachSqr(enemy);
            if (distToEnemySqr <= reachSqr && this.attackTick <= 0) {
                this.attackTick = 20;
                this.attacker.swing(InteractionHand.MAIN_HAND);
                this.attacker.doHurtTarget((Entity)enemy);
            }
        }

        protected double getAttackReachSqr(LivingEntity attackTarget) {
            return this.attacker.getBbWidth() * 2.0f * this.attacker.getBbWidth() * 2.0f + attackTarget.getBbWidth();
        }
    }
}

