/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.network;

import java.io.ByteArrayInputStream;
import net.mehvahdjukaar.moonlight.api.platform.configs.ModConfigHolder;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SyncConfigsMessage
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, SyncConfigsMessage> TYPE = Message.makeType(Moonlight.res("bidi_sync_configs"), SyncConfigsMessage::new);
    public final ResourceLocation configId;
    public final byte[] configData;

    public SyncConfigsMessage(RegistryFriendlyByteBuf buf) {
        this.configId = buf.readResourceLocation();
        this.configData = buf.readByteArray();
    }

    public SyncConfigsMessage(byte[] configFileData, ResourceLocation configId) {
        this.configId = configId;
        this.configData = configFileData;
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.configId);
        buf.writeByteArray(this.configData);
    }

    @Override
    public void handle(Message.Context context) {
        ServerPlayer sp;
        Player player;
        if (context.getDirection() == Message.NetworkDir.SERVER_BOUND && (player = context.getPlayer()) instanceof ServerPlayer && !(sp = (ServerPlayer)player).hasPermissions(3)) {
            Moonlight.LOGGER.warn("Player {} tried to sync their configs without permission", (Object)sp.getName().getString());
            return;
        }
        ModConfigHolder config = ModConfigHolder.getConfigSpec(this.configId);
        if (config != null) {
            try (ByteArrayInputStream stream = new ByteArrayInputStream(this.configData);){
                config.loadFromBytes(stream);
                Moonlight.LOGGER.info("Synced {} configs", (Object)config.getFileName());
            }
            catch (Exception exception) {}
        } else {
            Moonlight.LOGGER.error("Failed to find config file with id {}", (Object)this.configId);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE.type();
    }
}

